/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.method;

import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.eclipse.sensinact.gateway.common.primitive.PathElement;
import org.eclipse.sensinact.gateway.core.message.AbstractSnaErrorfulMessage;
import org.eclipse.sensinact.gateway.core.method.AccessMethodResponse;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class AccessMethodResponseBuilder<T, A extends AccessMethodResponse<T>>
extends Stack<T>
implements PathElement {
    protected final Object[] parameters;
    protected boolean exitOnError;
    protected Deque<Exception> exceptions = null;
    protected final String uri;
    protected T resultObject;

    public abstract A createAccessMethodResponse(AccessMethodResponse.Status var1);

    public abstract Class<T> getComponentType();

    protected AccessMethodResponseBuilder(String uri, Object[] parameters) {
        this(uri, parameters, true);
    }

    protected AccessMethodResponseBuilder(String uri, Object[] parameters, boolean exitOnError) {
        this.uri = uri;
        this.exitOnError = exitOnError;
        this.parameters = parameters;
    }

    public Object getParameter(int index) {
        if (index < 0 || this.parameters == null || index >= this.parameters.length) {
            return null;
        }
        return this.parameters[index];
    }

    public int length() {
        return this.parameters == null ? 0 : this.parameters.length;
    }

    public void registerException(Exception exception) {
        if (this.exceptions == null) {
            this.exceptions = new LinkedList<Exception>();
        }
        this.exceptions.add(exception);
    }

    public List<Exception> Exceptions() {
        if (this.exceptions == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList((List)((Object)this.exceptions));
    }

    public A createAccessMethodResponse() {
        AccessMethodResponse.Status status = this.exceptions != null && this.exceptions.size() > 0 ? AccessMethodResponse.Status.ERROR : AccessMethodResponse.Status.SUCCESS;
        A response = this.createAccessMethodResponse(status);
        if (this.exceptions != null && this.exceptions.size() > 0) {
            Iterator<Exception> iterator = this.exceptions.iterator();
            JSONArray exceptionsArray = new JSONArray();
            while (iterator.hasNext()) {
                Exception exception = iterator.next();
                JSONObject exceptionObject = new JSONObject();
                exceptionObject.put("message", (Object)exception.getMessage());
                StringBuilder buffer = new StringBuilder();
                StackTraceElement[] trace = exception.getStackTrace();
                int length = trace.length;
                for (int index = 0; index < length; ++index) {
                    buffer.append(trace[index].toString());
                    buffer.append("\n");
                }
                exceptionObject.put("trace", (Object)buffer.toString());
                exceptionsArray.put((Object)exceptionObject);
            }
            ((AbstractSnaErrorfulMessage)response).setErrors(exceptionsArray);
        }
        ((AccessMethodResponse)response).setResponse(this.resultObject);
        return response;
    }

    public void setAccessMethodObjectResult(T resultObject) {
        this.resultObject = resultObject;
    }

    public T getAccessMethodObjectResult() {
        return this.resultObject;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public boolean exitOnError() {
        return this.exitOnError;
    }

    public boolean hasError() {
        return this.exceptions != null && this.exceptions.size() > 0;
    }

    public String getPath() {
        return this.uri;
    }
}

