/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.method;

import java.util.Iterator;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.primitive.InvalidValueException;
import org.eclipse.sensinact.gateway.common.primitive.JSONable;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.core.method.AccessMethodResponse;
import org.eclipse.sensinact.gateway.core.method.Parameter;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Signature
implements JSONable,
Iterable<Parameter>,
Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(Signature.class);
    protected Parameter[] parameters;
    protected final String name;
    protected final Mediator mediator;
    protected final AccessMethodResponse.Response returnedType;

    public Signature(Mediator mediator, String methodType, Parameter[] parameters) throws InvalidValueException {
        this.mediator = mediator;
        int length = parameters == null ? 0 : parameters.length;
        this.parameters = new Parameter[length];
        for (int index = 0; index < length; ++index) {
            this.parameters[index] = (Parameter)parameters[index].clone();
        }
        this.name = methodType;
        this.returnedType = AccessMethod.Type.valueOf(this.name).getReturnedType();
    }

    public Signature(Mediator mediator, AccessMethod.Type type, Class<?>[] parameterTypes, String[] parameterNames) throws InvalidValueException {
        String[] names;
        this.mediator = mediator;
        String name = null;
        int length = parameterTypes == null ? 0 : parameterTypes.length;
        this.parameters = new Parameter[length];
        String[] stringArray = names = parameterNames == null ? new String[]{} : parameterNames;
        for (int index = 0; index < length; ++index) {
            if (index < names.length) {
                name = names[index];
            }
            if (name == null) {
                name = "arg" + index;
            }
            this.parameters[index] = new Parameter(this.mediator, name, parameterTypes[index]);
            name = null;
        }
        this.name = type.name();
        this.returnedType = AccessMethod.Type.valueOf(this.name).getReturnedType();
    }

    protected Signature(Mediator mediator, String name, AccessMethodResponse.Response returnedType, Parameter[] parameters) throws InvalidValueException {
        this.mediator = mediator;
        this.name = name;
        this.returnedType = returnedType;
        this.parameters = new Parameter[parameters.length];
        for (int index = 0; index < parameters.length; ++index) {
            this.parameters[index] = (Parameter)parameters[index].clone();
        }
    }

    public String getName() {
        return this.name;
    }

    public AccessMethodResponse.Response getResponseType() {
        return this.returnedType;
    }

    public Class<?>[] getParameterTypes() {
        Class[] parameterTypes = new Class[this.length()];
        for (int index = 0; index < this.length(); ++index) {
            parameterTypes[index] = this.parameters[index].getType();
        }
        return parameterTypes;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        Class<?> objectClass = object.getClass();
        if (Signature.class.isAssignableFrom(objectClass)) {
            return this.equals((Signature)object);
        }
        return false;
    }

    public boolean equals(Signature signature) {
        return this.equals(signature.getName(), signature.getParameterTypes());
    }

    public boolean equals(String name, Class<?>[] parameterTypes) {
        int index;
        int length;
        int n = length = parameterTypes == null ? 0 : parameterTypes.length;
        if (this.length() != length || !this.getName().equals(name)) {
            return false;
        }
        Class<?>[] thisParameterTypes = this.getParameterTypes();
        for (index = 0; index < length && thisParameterTypes[index] == parameterTypes[index]; ++index) {
        }
        return index == length;
    }

    public Parameter get(String name) {
        Parameter parameter2 = null;
        for (Parameter parameter2 : this) {
            if (parameter2.getName().equals(name)) break;
            parameter2 = null;
        }
        return parameter2;
    }

    public Parameter get(int index) {
        int position = 0;
        Parameter parameter2 = null;
        for (Parameter parameter2 : this) {
            if (position == index) break;
            ++position;
            parameter2 = null;
        }
        return parameter2;
    }

    public Object[] values() {
        int position = 0;
        Object[] values = new Object[this.length()];
        Parameter parameter2 = null;
        for (Parameter parameter2 : this) {
            values[position++] = parameter2.getValue();
        }
        return values;
    }

    public boolean validParameters(Parameter[] methodParameters) {
        int length;
        int n = length = methodParameters == null ? 0 : methodParameters.length;
        if (this.parameters.length != length) {
            return false;
        }
        for (int index = 0; index < length; ++index) {
            this.parameters[index].reset();
            if (this.parameters[index].validParameter(methodParameters[index])) continue;
            return false;
        }
        return true;
    }

    public boolean validParameters(Object[] methodParameters) {
        try {
            int length;
            int n = length = methodParameters == null ? 0 : methodParameters.length;
            if (this.parameters.length != length) {
                return false;
            }
            for (int index = 0; index < length; ++index) {
                this.parameters[index].reset();
                if (this.parameters[index].validParameter(methodParameters[index])) continue;
                return false;
            }
        }
        catch (Error | Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean validParameters(JSONArray methodParameters) {
        int length;
        int n = length = methodParameters == null ? 0 : methodParameters.length();
        if (this.parameters.length != length) {
            return false;
        }
        for (int index = 0; index < length; ++index) {
            this.parameters[index].reset();
            if (this.parameters[index].validParameter(methodParameters.optJSONObject(index))) continue;
            return false;
        }
        return true;
    }

    public int length() {
        return this.parameters.length;
    }

    public String getJSON() {
        return this.getJSONObjectDescription().toString();
    }

    public JSONObject getJSONObjectDescription() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", (Object)this.getName());
        JSONArray paramtersArray = new JSONArray();
        Iterator<Parameter> iterator = this.iterator();
        while (iterator.hasNext()) {
            paramtersArray.put((Object)iterator.next().getJSONObject());
        }
        jsonObject.put("parameters", (Object)paramtersArray);
        return jsonObject;
    }

    @Override
    public Iterator<Parameter> iterator() {
        return new ParameterIterator();
    }

    public Object clone() {
        try {
            return new Signature(this.mediator, this.name, this.returnedType, this.parameters);
        }
        catch (InvalidValueException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private final class ParameterIterator
    implements Iterator<Parameter> {
        private int position = -1;
        private Parameter next = null;

        ParameterIterator() {
            this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Parameter next() {
            Parameter parameter = this.next;
            this.findNext();
            return parameter;
        }

        @Override
        public void remove() {
        }

        private final void findNext() {
            ++this.position;
            this.next = null;
            if (this.position < Signature.this.length()) {
                this.next = Signature.this.parameters[this.position];
            }
        }
    }
}

