/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.method;

import java.util.Collections;
import java.util.Set;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.execution.ErrorHandler;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.core.method.AccessMethodDescription;
import org.eclipse.sensinact.gateway.core.method.AccessMethodResponse;
import org.eclipse.sensinact.gateway.core.method.Signature;

public class UnaccessibleAccessMethod
implements AccessMethod<String, AccessMethodResponse<String>> {
    private final AccessMethod.Type method;
    private final String uri;
    protected final Mediator mediator;

    public UnaccessibleAccessMethod(Mediator mediator, String uri, AccessMethod.Type method) {
        this.mediator = mediator;
        this.method = method;
        this.uri = uri;
    }

    public AccessMethodDescription getDescription() {
        return new AccessMethodDescription(this);
    }

    public String getName() {
        return this.method.name();
    }

    @Override
    public AccessMethod.Type getType() {
        return this.method;
    }

    @Override
    public AccessMethodResponse<String> invoke(Object[] parameters) {
        return AccessMethodResponse.error(this.mediator, this.uri, this.method, 403, "Unaccessible method", null);
    }

    @Override
    public Set<Signature> getSignatures() {
        return Collections.emptySet();
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return null;
    }

    public String getPath() {
        return this.uri;
    }
}

