/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security;

import java.util.Base64;
import org.eclipse.sensinact.gateway.core.security.Authentication;

public class Credentials
implements Authentication<Credentials> {
    public static final String HEADER_SEP = " ";
    public static final String BASE64_SEP = ":";
    public static final String ANONYMOUS_LOGIN = "anonymous";
    public static final String ANONYMOUS_PASSWORD = "anonymous";
    public final String login;
    public final String password;

    public Credentials(String login, String password) {
        this.login = login;
        this.password = password;
    }

    public Credentials(String encoded) {
        String localLogin = null;
        String localPassword = null;
        try {
            String[] encodedElements = encoded.split(HEADER_SEP);
            int index = encodedElements.length == 1 ? 0 : 1;
            byte[] credBytes = Base64.getDecoder().decode(encodedElements[index]);
            String[] credentials = new String(credBytes).split(BASE64_SEP);
            localLogin = credentials[0];
            localPassword = credentials[1];
        }
        catch (Exception e) {
            localLogin = "anonymous";
            localPassword = "anonymous";
        }
        this.login = localLogin;
        this.password = localPassword;
    }

    @Override
    public Credentials getAuthenticationMaterial() {
        return this;
    }
}

