/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.endpoint;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.core.filtering.FilteringCollection;
import org.eclipse.sensinact.gateway.core.filtering.FilteringDefinition;
import org.eclipse.sensinact.gateway.core.message.SnaFilter;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.AllRequest;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.Argument;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.AttributeGetRequest;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.AttributeSetRequest;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.AttributeSubscribeRequest;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.AttributeUnsubscribeRequest;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundMediator;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRecipient;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRequest;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.RegisterAgentRequest;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.ResourceActRequest;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.ResourceRequest;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.ResourcesRequest;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.ServiceProviderRequest;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.ServiceProvidersRequest;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.ServiceRequest;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.ServicesRequest;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.UnregisterAgentRequest;
import org.eclipse.sensinact.gateway.util.CastUtils;
import org.json.JSONArray;

public class NorthboundRequestBuilder {
    protected NorthboundMediator mediator;
    protected String serviceProvider;
    protected String service;
    protected String resource;
    protected String attribute;
    protected String requestIdentifier;
    protected String method;
    protected boolean listElements;
    private List<Argument> arguments;
    private FilteringDefinition[] filterDefinitions;
    private boolean hiddenFilter;

    public NorthboundRequestBuilder(NorthboundMediator mediator) {
        this.mediator = mediator;
        this.arguments = new ArrayList<Argument>();
        if (this.mediator == null) {
            throw new NullPointerException("Mediator needed");
        }
    }

    public NorthboundRequestBuilder withServiceProvider(String serviceProvider) {
        this.serviceProvider = serviceProvider;
        return this;
    }

    public NorthboundRequestBuilder withService(String service) {
        this.service = service;
        return this;
    }

    public NorthboundRequestBuilder withResource(String resource) {
        this.resource = resource;
        return this;
    }

    public NorthboundRequestBuilder withAttribute(String attribute) {
        this.attribute = attribute;
        return this;
    }

    public NorthboundRequestBuilder withMethod(String method) {
        this.method = method;
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public NorthboundRequestBuilder withArgument(Argument argument) {
        this.arguments.add(argument);
        return this;
    }

    public NorthboundRequestBuilder withRequestId(String rid) {
        this.requestIdentifier = rid;
        return this;
    }

    public String getRequestIdentifier() {
        return this.requestIdentifier;
    }

    public NorthboundRequestBuilder isElementsList(boolean listElements) {
        this.listElements = listElements;
        return this;
    }

    public void withFilter(int size) {
        this.filterDefinitions = new FilteringDefinition[size];
    }

    public void withFilter(FilteringDefinition filterDefinition, int index) {
        if (filterDefinition == null || this.filterDefinitions == null) {
            return;
        }
        this.filterDefinitions[index] = filterDefinition;
    }

    public void withHiddenFilter(boolean hiddenFilter) {
        this.hiddenFilter = hiddenFilter;
    }

    public NorthboundRequest build() {
        NorthboundRequest request = null;
        if (this.method == null) {
            return request;
        }
        switch (this.method) {
            case "ALL": {
                FilteringCollection collection = null;
                if (this.filterDefinitions != null) {
                    collection = new FilteringCollection((Mediator)this.mediator, this.hiddenFilter, this.filterDefinitions);
                }
                request = new AllRequest(this.getRequestIdentifier(), collection);
                break;
            }
            case "ACT": {
                if (this.resource == null) break;
                request = new ResourceActRequest(this.getRequestIdentifier(), this.serviceProvider, this.service, this.resource, this.arguments.stream().collect(ArrayList::new, (l, a) -> l.add(a.value), List::addAll).toArray());
                break;
            }
            case "DESCRIBE": {
                if (this.resource != null) {
                    request = new ResourceRequest(this.getRequestIdentifier(), this.serviceProvider, this.service, this.resource);
                    break;
                }
                if (this.service != null) {
                    if (this.listElements) {
                        request = new ResourcesRequest(this.getRequestIdentifier(), this.serviceProvider, this.service, this.filterDefinitions == null ? null : new FilteringCollection((Mediator)this.mediator, this.hiddenFilter, this.filterDefinitions));
                        break;
                    }
                    request = new ServiceRequest(this.getRequestIdentifier(), this.serviceProvider, this.service, null);
                    break;
                }
                if (this.serviceProvider != null) {
                    if (this.listElements) {
                        request = new ServicesRequest(this.getRequestIdentifier(), this.serviceProvider, this.filterDefinitions == null ? null : new FilteringCollection((Mediator)this.mediator, this.hiddenFilter, this.filterDefinitions));
                        break;
                    }
                    request = new ServiceProviderRequest(this.getRequestIdentifier(), this.serviceProvider, null);
                    break;
                }
                request = new ServiceProvidersRequest(this.getRequestIdentifier(), this.filterDefinitions == null ? null : new FilteringCollection((Mediator)this.mediator, this.hiddenFilter, this.filterDefinitions));
                break;
            }
            case "GET": {
                request = new AttributeGetRequest(this.getRequestIdentifier(), this.serviceProvider, this.service, this.resource, this.attribute, this.arguments == null || this.arguments.size() == 0 ? null : this.arguments.toArray(new Argument[0]));
                break;
            }
            case "SET": {
                List<Argument> extraArguments = this.arguments.size() > 1 ? this.arguments.subList(1, this.arguments.size() - 1) : null;
                request = new AttributeSetRequest(this.getRequestIdentifier(), this.serviceProvider, this.service, this.resource, this.attribute, this.arguments.get((int)0).value, extraArguments == null || extraArguments.size() == 0 ? null : extraArguments.toArray(new Argument[0]));
                break;
            }
            case "SUBSCRIBE": {
                List<Argument> extraArguments;
                if (this.arguments == null || this.arguments.size() == 0) break;
                NorthboundRecipient northboundRecipient = null;
                try {
                    northboundRecipient = (NorthboundRecipient)this.arguments.get((int)0).value;
                }
                catch (ClassCastException e) {
                    break;
                }
                String policy = this.arguments.size() > 2 ? (String)this.arguments.get((int)2).value : String.valueOf(0x100010);
                List<Argument> list = extraArguments = this.arguments.size() > 3 ? this.arguments.subList(3, this.arguments.size() - 1) : null;
                if (this.resource != null) {
                    request = new AttributeSubscribeRequest(this.getRequestIdentifier(), this.serviceProvider, this.service, this.resource, this.attribute, northboundRecipient, (JSONArray)(this.arguments.size() > 1 ? this.arguments.get((int)1).value : new JSONArray()), policy, extraArguments == null || extraArguments.size() == 0 ? null : extraArguments.toArray(new Argument[0]));
                    break;
                }
                request = new RegisterAgentRequest(this.getRequestIdentifier(), this.serviceProvider, this.service, northboundRecipient, (SnaFilter)(this.arguments.size() > 1 ? this.arguments.get((int)1).value : null), policy);
                break;
            }
            case "UNSUBSCRIBE": {
                List<Argument> extraArguments = this.arguments.size() > 1 ? this.arguments.subList(1, this.arguments.size() - 1) : null;
                String subcriptionId = (String)CastUtils.cast(String.class, (Object)this.arguments.get((int)0).value);
                if (this.resource != null) {
                    request = new AttributeUnsubscribeRequest(this.getRequestIdentifier(), this.serviceProvider, this.service, this.resource, this.attribute, subcriptionId, extraArguments == null || extraArguments.size() == 0 ? null : extraArguments.toArray(new Argument[0]));
                    break;
                }
                request = new UnregisterAgentRequest(this.getRequestIdentifier(), subcriptionId);
                break;
            }
        }
        return request;
    }
}

