/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.simulated.button.internal;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.simulated.button.api.ButtonSetterItf;
import org.eclipse.sensinact.gateway.simulated.button.internal.ButtonAdapter;

public class ButtonGUI
extends JLabel
implements MouseListener,
ButtonSetterItf {
    private final ImageIcon buttonOn;
    private final ImageIcon buttonOff;
    private final ButtonAdapter listener;
    private boolean state;

    public ButtonGUI(Mediator mediator, ButtonAdapter listener) {
        super.setLayout(new BoxLayout(this, 3));
        this.buttonOn = new ImageIcon(mediator.getContext().getBundle().getResource("images/button/on.png"));
        this.buttonOff = new ImageIcon(mediator.getContext().getBundle().getResource("images/button/off.png"));
        super.setIcon(this.buttonOff);
        this.state = false;
        super.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        super.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        super.addMouseListener(this);
        this.listener = listener;
    }

    @Override
    public void stop() {
        super.setVisible(false);
    }

    @Override
    public void move(boolean value) {
        this.listener.mouseReleased(value);
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        if (this.state) {
            this.move(false);
            super.setIcon(this.buttonOff);
            this.state = false;
        } else {
            this.move(true);
            super.setIcon(this.buttonOn);
            this.state = true;
        }
    }
}

