/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.agent.http.onem2m.internal;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.sensinact.gateway.agent.http.onem2m.internal.Util;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneM2MModelResource {
    private static Logger LOG = LoggerFactory.getLogger((String)OneM2MModelResource.class.getCanonicalName());
    private final String cseBase;
    private final String provider;
    private Set<String> resources = new HashSet<String>();
    private final String origin;

    public OneM2MModelResource(String provider, String cseBase) {
        this.cseBase = cseBase;
        this.provider = provider;
        this.origin = "Kentyou" + provider.toUpperCase();
    }

    public void addResourceInfo(String service, String resource, String value) {
        JSONObject content;
        LOG.debug("Integrating reading from provider '{}' resource '{}' with value '{}'. The server is '{}'.", new Object[]{this.provider, resource, value, this.cseBase});
        String fullId = String.format("%s/%s", service, resource);
        if (!this.resources.contains(fullId)) {
            this.resources.add(fullId);
            JSONObject resourceContainer = new JSONObject();
            content = new JSONObject();
            content.put("rn", (Object)resource);
            content.put("lbl", (Object)new JSONArray().put((Object)this.provider));
            resourceContainer.put("m2m:cnt", (Object)content);
            try {
                Util.createRequest(this.cseBase, "POST", "Kentyou" + this.provider.toUpperCase(), "/" + this.provider, "application/json;ty=3", resourceContainer);
            }
            catch (IOException e) {
                LOG.error("Failed to process http request to OneM2M server {} to update device location", (Object)this.cseBase, (Object)e);
            }
        }
        JSONObject resourceValueContent = new JSONObject();
        content = new JSONObject();
        content.put("con", (Object)value.toString());
        resourceValueContent.put("m2m:cin", (Object)content);
        try {
            Util.createRequest(this.cseBase, "POST", "Kentyou" + this.provider.toUpperCase(), "/" + this.provider + "/" + resource, "application/json;ty=4", resourceValueContent);
        }
        catch (IOException e) {
            LOG.error("Failed to process http request to OneM2M server {} to update device info", (Object)this.cseBase, (Object)e);
        }
    }

    private void removeResource(String service, String resource) {
        try {
            JSONObject content = new JSONObject();
            content.put("rn", (Object)resource);
            Util.createRequest(this.cseBase, "DELETE", this.origin, "/" + this.provider, "application/json;ty=3", new JSONObject().put("m2m:cnt", (Object)content));
        }
        catch (IOException e) {
            LOG.debug("Failed to remove resource", (Throwable)e);
        }
    }

    public void removeResource() {
        for (String vl : this.resources) {
            String[] splitName = vl.split("/");
            String service = splitName[0];
            String resource = splitName[1];
            this.removeResource(service, resource);
            this.resources.remove(vl);
        }
    }
}

