/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.agent.http.onem2m.internal;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.gateway.protocol.http.client.ConnectionConfiguration;
import org.eclipse.sensinact.gateway.protocol.http.client.ConnectionConfigurationImpl;
import org.eclipse.sensinact.gateway.protocol.http.client.SimpleRequest;
import org.eclipse.sensinact.gateway.protocol.http.client.SimpleResponse;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static Logger LOG = LoggerFactory.getLogger((String)Util.class.getCanonicalName());

    public static final int createRequest(String cseBase, String method, String origin, String path, String contentType, JSONObject content) throws IOException {
        ConnectionConfigurationImpl configuration = new ConnectionConfigurationImpl();
        configuration.setHttpMethod(method);
        if (path != null) {
            configuration.setUri(cseBase + path);
        } else {
            configuration.setUri(cseBase);
        }
        if (origin != null) {
            configuration.addHeader("X-M2M-Origin", origin);
        } else {
            configuration.addHeader("X-M2M-Origin", "C");
        }
        configuration.setAccept("application/json");
        configuration.setContentType(contentType);
        configuration.setContent((Object)content.toString());
        LOG.debug("Sending request to URI {}", (Object)configuration.getUri());
        LOG.debug("Headers from request to {}", (Object)configuration.getUri());
        for (Map.Entry entry : configuration.getHeaders().entrySet()) {
            LOG.debug("{} : {}", entry.getKey(), (Object)((List)entry.getValue()).toString());
        }
        LOG.debug("Request body: {}", (Object)content.toString());
        SimpleRequest req = new SimpleRequest((ConnectionConfiguration)configuration);
        SimpleResponse resp = (SimpleResponse)req.send();
        Integer status = resp.getStatusCode();
        LOG.debug("HTTP response code {}, with payload '{}'", (Object)status, (Object)resp.toString());
        return status;
    }
}

