/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.http.callback;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.sensinact.gateway.nthbnd.http.callback.AbstractRequestWrapper;
import org.json.JSONException;
import org.json.JSONObject;

public class WebSocketRequestWrapper
extends AbstractRequestWrapper {
    private String content;

    public WebSocketRequestWrapper(String content) {
        this.content = content;
    }

    @Override
    public String getRequestURI() {
        try {
            JSONObject request = new JSONObject(this.content);
            String uri = request.optString("uri");
            String[] uriElements = uri.split("\\?");
            return uriElements[0];
        }
        catch (JSONException e) {
            LOG.config(String.format("Unable to convert the request content into a JSON object:\n %s", this.content));
            return null;
        }
    }

    @Override
    public Map<String, List<String>> getQueryMap() {
        try {
            JSONObject request = new JSONObject(this.content);
            String uri = request.optString("uri");
            String[] uriElements = uri.split("\\?");
            if (uriElements.length == 2) {
                try {
                    return AbstractRequestWrapper.processRequestQuery(uriElements[1]);
                }
                catch (UnsupportedEncodingException e) {
                    LOG.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        catch (JSONException e) {
            LOG.config(String.format("Unable to convert the request content into a JSON object:\n %s", this.content));
        }
        return Collections.emptyMap();
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public Map<String, List<String>> getAttributes() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        if (this.content != null && this.content.length() > 0) {
            try {
                JSONObject request = new JSONObject(this.content);
                request.remove("uri");
                Iterator en = request.keys();
                while (en.hasNext()) {
                    String key = (String)en.next();
                    String value = String.valueOf(request.get(key));
                    map.put(key, Collections.singletonList(value));
                }
            }
            catch (JSONException e) {
                LOG.config(String.format("Unable to convert the request content into a JSON object:\n %s", this.content));
            }
        }
        return map;
    }
}

