/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.protocol.ssdp.listener;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.sensinact.gateway.protocol.ssdp.api.SSDPDiscoveryListenerItf;
import org.eclipse.sensinact.gateway.protocol.ssdp.api.SSDPDiscoveryNotifierItf;
import org.eclipse.sensinact.gateway.protocol.ssdp.description.SSDPDescriptionRequest;
import org.eclipse.sensinact.gateway.protocol.ssdp.model.SSDPDescriptionPacket;
import org.eclipse.sensinact.gateway.protocol.ssdp.model.SSDPMessage;
import org.eclipse.sensinact.gateway.protocol.ssdp.model.SSDPReceivedMessage;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class SSDPDiscoveryNotifier
implements SSDPDiscoveryNotifierItf {
    private ServiceReference<SSDPDiscoveryNotifierItf> registration;
    private Map<SSDPDiscoveryListenerItf, String> listeners = new HashMap<SSDPDiscoveryListenerItf, String>();
    private Map<String, SSDPDescriptionPacket> discoveredDevices = new HashMap<String, SSDPDescriptionPacket>();

    public SSDPDiscoveryNotifier(BundleContext context) {
        this.registration = context.registerService(SSDPDiscoveryNotifierItf.class, (Object)this, null).getReference();
    }

    public void stop(BundleContext context) {
        context.ungetService(this.registration);
    }

    @Override
    public void addListener(SSDPDiscoveryListenerItf listener, String filter) {
        this.listeners.put(listener, filter);
    }

    @Override
    public void removeListener(SSDPDiscoveryListenerItf listener) {
        this.listeners.remove(listener);
    }

    @Override
    public List<SSDPDescriptionPacket> getDescriptions(String filter) {
        ArrayList<SSDPDescriptionPacket> descriptionPackets = new ArrayList<SSDPDescriptionPacket>();
        Pattern pattern = Pattern.compile(filter);
        for (Map.Entry<String, SSDPDescriptionPacket> map : this.discoveredDevices.entrySet()) {
            Matcher matcher = pattern.matcher(map.getKey());
            if (!matcher.find()) continue;
            descriptionPackets.add(map.getValue());
        }
        return descriptionPackets;
    }

    public void newSSDPPacket(SSDPMessage message) {
        if (message instanceof SSDPReceivedMessage && ((SSDPReceivedMessage)message).getLocation() != null) {
            SSDPDescriptionPacket descriptionPacket = SSDPDescriptionRequest.getDescription((SSDPReceivedMessage)message);
            for (Map.Entry<SSDPDiscoveryListenerItf, String> map : this.listeners.entrySet()) {
                this.discoveredDevices.put(descriptionPacket.getFriendlyName(), descriptionPacket);
                if (map.getValue() != null) {
                    Pattern pattern = Pattern.compile(map.getValue());
                    Matcher matcher = pattern.matcher(descriptionPacket.getFriendlyName());
                    if (!matcher.find()) continue;
                    map.getKey().eventSSDP(message.getEvent(), descriptionPacket);
                    continue;
                }
                map.getKey().eventSSDP(message.getEvent(), descriptionPacket);
            }
        }
    }
}

