/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.android;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.generic.local.LocalProtocolStackEndpoint;
import org.eclipse.sensinact.gateway.generic.packet.InvalidPacketException;
import org.eclipse.sensinact.gateway.generic.packet.Packet;
import org.eclipse.sensinact.gateway.sthbnd.http.android.DevGenPacket;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSocket(maxTextMessageSize=65536)
public class AndroidWebSocketWrapper {
    private Logger LOG = LoggerFactory.getLogger((String)AndroidWebSocketWrapper.class.getName());
    private final LocalProtocolStackEndpoint<DevGenPacket> endpoint;
    private List<String> providers = new ArrayList<String>();
    protected Session session;
    protected Mediator mediator;

    protected AndroidWebSocketWrapper(Mediator mediator, LocalProtocolStackEndpoint<DevGenPacket> endpoint) {
        this.mediator = mediator;
        this.endpoint = endpoint;
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        this.LOG.debug("new websocket connection was open");
        this.session = session;
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        for (String provider : this.providers) {
            DevGenPacket pack = new DevGenPacket(provider);
            pack.isGoodbye(true);
            try {
                this.endpoint.process((Packet)pack);
            }
            catch (InvalidPacketException e) {
                this.LOG.error("failed to remove all providers generated via websocket", (Throwable)e);
            }
        }
    }

    @OnWebSocketMessage
    public void onMessage(String message) {
        try {
            this.LOG.debug("Message received from the client {}, starting packet transformation", (Object)message);
            JSONObject jsonPayload = new JSONObject(message);
            String provider = jsonPayload.getString("provider");
            String service = jsonPayload.getString("service");
            String resource = jsonPayload.getString("resource");
            String value = null;
            Object type = null;
            DevGenPacket packet = new DevGenPacket(provider, service, resource);
            if (jsonPayload.has("value")) {
                value = jsonPayload.get("value").toString();
            }
            if (jsonPayload.has("type") && jsonPayload.get("type") != null && jsonPayload.get("type").equals("remove")) {
                packet.isGoodbye(true);
            }
            if (value != null) {
                packet.setCurrentState(value);
            }
            this.endpoint.process((Packet)packet);
            this.providers.add(provider);
            this.LOG.debug("Package {}/{}/{}/{} received from the client processed with success.", new Object[]{provider, service, resource, value});
        }
        catch (Exception e) {
            this.LOG.error("Failed to process the package received from the client", (Throwable)e);
        }
    }

    @OnWebSocketError
    public void handleError(Throwable error) {
        error.printStackTrace();
    }

    protected void close() {
        if (this.session == null) {
            return;
        }
        if (this.session.isOpen()) {
            this.session.close();
        }
        this.session = null;
    }

    public InetSocketAddress getClientAddress() {
        return this.session.getRemoteAddress();
    }
}

