/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.test;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.sensinact.gateway.core.AnonymousSession;
import org.eclipse.sensinact.gateway.core.Core;
import org.eclipse.sensinact.gateway.core.Resource;
import org.eclipse.sensinact.gateway.core.Service;
import org.eclipse.sensinact.gateway.core.ServiceProvider;
import org.eclipse.sensinact.gateway.core.method.GetResponse;
import org.eclipse.sensinact.gateway.protocol.http.client.ConnectionConfiguration;
import org.eclipse.sensinact.gateway.protocol.http.client.ConnectionConfigurationImpl;
import org.eclipse.sensinact.gateway.protocol.http.client.SimpleRequest;
import org.eclipse.sensinact.gateway.protocol.http.client.SimpleResponse;
import org.eclipse.sensinact.gateway.sthbnd.http.test.JettyServerTestCallback;
import org.eclipse.sensinact.gateway.sthbnd.http.test.JettyTestServer;
import org.json.JSONObject;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.Extensions;
import org.osgi.framework.Bundle;
import org.osgi.test.common.annotation.InjectInstalledBundle;
import org.osgi.test.common.annotation.InjectService;
import org.osgi.test.junit5.context.InstalledBundleExtension;
import org.osgi.test.junit5.service.ServiceExtension;

@Extensions(value={@ExtendWith(value={InstalledBundleExtension.class}), @ExtendWith(value={ServiceExtension.class})})
public class TestHttpDevice {
    public static int HTTP_PORT = 8898;
    public static int SERVER_PORT = 8899;
    public static String HTTP_ROOTURL = "http://127.0.0.1:" + HTTP_PORT;
    private static JettyTestServer server = null;
    private static JettyServerTestCallback callback = null;

    public static String newRequest(String configuration) throws IOException {
        ConnectionConfigurationImpl builder = new ConnectionConfigurationImpl(configuration);
        SimpleRequest request = new SimpleRequest((ConnectionConfiguration)builder);
        SimpleResponse response = (SimpleResponse)request.send();
        byte[] responseContent = response.getContent();
        String contentStr = responseContent == null ? null : new String(responseContent);
        return contentStr;
    }

    public static String newRequest(String url, String content, String method) {
        ConnectionConfigurationImpl builder = new ConnectionConfigurationImpl();
        builder.setUri(url);
        try {
            if (method.equals("GET")) {
                builder.setHttpMethod("GET");
            } else if (method.equals("POST")) {
                builder.setContentType("application/json");
                builder.setHttpMethod("POST");
                if (content != null && content.length() > 0) {
                    JSONObject jsonData = new JSONObject(content);
                    builder.setContent((Object)jsonData.toString());
                }
            } else {
                return null;
            }
            builder.setAccept("application/json");
            SimpleRequest request = new SimpleRequest((ConnectionConfiguration)builder);
            SimpleResponse response = (SimpleResponse)request.send();
            byte[] responseContent = response.getContent();
            String contentStr = responseContent == null ? null : new String(responseContent);
            return contentStr;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @BeforeAll
    public static void beforeClass() throws Exception {
        if (server != null) {
            if (server.isStarted()) {
                server.stop();
                server.join();
            }
            server = null;
        }
        server = new JettyTestServer(SERVER_PORT);
        new Thread(server).start();
        server.join();
        callback = new JettyServerTestCallback();
        server.registerCallback(callback);
    }

    @AfterAll
    public static void afterClass() throws Exception {
        server.stop();
        server.join();
    }

    public boolean isExcluded(String fileName) {
        return "org.apache.felix.framework.security.jar".equals(fileName);
    }

    @Test
    public void testHttpTask(@InjectService(timeout=500L) Core core, @InjectInstalledBundle(value="resources.jar", start=true) Bundle bundle) throws Throwable {
        callback.setRemoteEntity(new JSONObject().put("serviceProviderId", (Object)"TestForSensiNactGateway").put("serviceId", (Object)"service1").put("resourceId", (Object)"temperature").put("data", 24));
        AnonymousSession session = core.getAnonymousSession();
        ServiceProvider provider = session.serviceProvider("TestForSensiNactGateway");
        Service service = provider.getService("service1");
        Resource variable = service.getResource("temperature");
        GetResponse response = variable.get("value", (Object[])null);
        JSONObject jsonObject = new JSONObject(response.getJSON());
        Assertions.assertEquals((int)24, (int)jsonObject.getJSONObject("response").getInt("value"));
        response = variable.set("value", (Object)25, (Object[])null);
        jsonObject = new JSONObject(response.getJSON());
        Assertions.assertEquals((int)25, (int)jsonObject.getJSONObject("response").getInt("value"));
        response = variable.get("value", (Object[])null);
        jsonObject = new JSONObject(response.getJSON());
        Assertions.assertEquals((int)25, (int)jsonObject.getJSONObject("response").getInt("value"));
        core.close();
    }

    @Test
    public void testHttpTaskWithProcessingContext(@InjectService(timeout=500L) Core core, @InjectInstalledBundle(value="resources5.jar", start=true) Bundle bundle) throws Throwable {
        callback.setRemoteEntity(new JSONObject().put("serviceProviderId", (Object)"TestForSensiNactGateway5").put("serviceId", (Object)"service1").put("resourceId", (Object)"temperature").put("data", 24));
        AnonymousSession session = core.getAnonymousSession();
        ServiceProvider provider = session.serviceProvider("TestForSensiNactGateway5");
        Service service = provider.getService("service1");
        Resource variable = service.getResource("temperature");
        GetResponse response = variable.get("value", (Object[])null);
        JSONObject jsonObject = new JSONObject(response.getJSON());
        Assertions.assertEquals((int)24, (int)jsonObject.getJSONObject("response").getInt("value"));
        response = variable.set("value", (Object)25, (Object[])null);
        jsonObject = new JSONObject(response.getJSON());
        Assertions.assertEquals((int)25, (int)jsonObject.getJSONObject("response").getInt("value"));
        response = variable.get("value", (Object[])null);
        jsonObject = new JSONObject(response.getJSON());
        Assertions.assertEquals((int)25, (int)jsonObject.getJSONObject("response").getInt("value"));
        core.close();
    }

    @Test
    public void testHttpTaskWithServicesEnumeration(@InjectService(timeout=500L) Core core, @InjectInstalledBundle(value="resources4.jar", start=true) Bundle bundle) throws Throwable {
        callback.setRemoteEntity(new JSONObject().put("serviceProviderId", (Object)"TestForSensiNactGateway4").put("serviceId", (Object)"service1").put("resourceId", (Object)"temperature").put("data", 24));
        AnonymousSession session = core.getAnonymousSession();
        ServiceProvider provider = session.serviceProvider("TestForSensiNactGateway4");
        provider.getServices().forEach(s -> System.err.println(s.getName()));
        Service service = provider.getService("service1");
        Resource variable = service.getResource("temperature");
        GetResponse response = variable.get("value", (Object[])null);
        JSONObject jsonObject = new JSONObject(response.getJSON());
        Assertions.assertEquals((int)24, (int)jsonObject.getJSONObject("response").getInt("value"));
        response = variable.set("value", (Object)25, (Object[])null);
        jsonObject = new JSONObject(response.getJSON());
        Assertions.assertEquals((int)25, (int)jsonObject.getJSONObject("response").getInt("value"));
        response = variable.get("value", (Object[])null);
        jsonObject = new JSONObject(response.getJSON());
        Assertions.assertEquals((int)25, (int)jsonObject.getJSONObject("response").getInt("value"));
        core.close();
    }

    @Test
    public void testChainedHttpTask(@InjectService(timeout=500L) Core core, @InjectInstalledBundle(value="resources3.jar", start=true) Bundle bundle) throws Throwable {
        callback.setRemoteEntity(new JSONObject().put("serviceProviderId", (Object)"TestForSensiNactGateway3").put("serviceId", (Object)"service1").put("resourceId", (Object)"temperature").put("data", 24));
        AnonymousSession session = core.getAnonymousSession();
        ServiceProvider provider = session.serviceProvider("TestForSensiNactGateway3");
        Service service = provider.getService("service1");
        Resource variable = service.getResource("temperature");
        GetResponse response = variable.get("value", (Object[])null);
        JSONObject jsonObject = new JSONObject(response.getJSON());
        Assertions.assertEquals((int)24, (int)jsonObject.getJSONObject("response").getInt("value"));
        core.close();
    }

    @Test
    public void testHttpDeviceReccurrent(@InjectService(timeout=500L) Core core, @InjectInstalledBundle(value="resources2.jar") Bundle bundle) throws Throwable {
        CountDownLatch latch = new CountDownLatch(1);
        callback.setCountDownLatch(latch);
        callback.setRemoteEntity(new JSONObject().put("serviceProviderId", (Object)"TestForSensiNactGateway2").put("serviceId", (Object)"service1").put("resourceId", (Object)"temperature").put("data", 24));
        bundle.start();
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS), (String)"GET was never called");
        AnonymousSession session = core.getAnonymousSession();
        ServiceProvider provider = session.serviceProvider("TestForSensiNactGateway2");
        Service service = provider.getService("service1");
        Resource variable = service.getResource("temperature");
        GetResponse response = variable.get("value", (Object[])null);
        JSONObject jsonObject = new JSONObject(response.getJSON());
        Assertions.assertEquals((int)24, (int)jsonObject.getJSONObject("response").getInt("value"));
        callback.setRemoteEntity(new JSONObject().put("serviceProviderId", (Object)"TestForSensiNactGateway2").put("serviceId", (Object)"service1").put("resourceId", (Object)"temperature").put("data", 25));
        Thread.sleep(2000L);
        response = variable.get("value", (Object[])null);
        jsonObject = new JSONObject(response.getJSON());
        Assertions.assertEquals((int)25, (int)jsonObject.getJSONObject("response").getInt("value"));
        callback.setRemoteEntity(new JSONObject().put("serviceProviderId", (Object)"TestForSensiNactGateway2").put("serviceId", (Object)"service1").put("resourceId", (Object)"temperature").put("data", 32));
        Thread.sleep(2000L);
        response = variable.get("value", (Object[])null);
        jsonObject = new JSONObject(response.getJSON());
        Assertions.assertEquals((int)32, (int)jsonObject.getJSONObject("response").getInt("value"));
        Thread.sleep(16000L);
        callback.setRemoteEntity(new JSONObject().put("serviceProviderId", (Object)"TestForSensiNactGateway2").put("serviceId", (Object)"service1").put("resourceId", (Object)"temperature").put("data", 45));
        Thread.sleep(2000L);
        response = variable.get("value", (Object[])null);
        jsonObject = new JSONObject(response.getJSON());
        Assertions.assertEquals((int)32, (int)jsonObject.getJSONObject("response").getInt("value"));
        core.close();
    }

    protected void doInit(Map configuration) {
        configuration.put("felix.auto.start.4", "file:target/felix/bundle/dynamicBundle.jar ");
        configuration.put("org.eclipse.sensinact.gateway.security.jks.filename", "target/felix/bundle/keystore.jks");
        configuration.put("org.eclipse.sensinact.gateway.security.jks.password", "sensiNact_team");
        configuration.put("org.eclipse.sensinact.gateway.location.latitude", "45.2d");
        configuration.put("org.eclipse.sensinact.gateway.location.longitude", "5.7d");
        configuration.put("org.osgi.service.http.port", "8898");
        configuration.put("org.apache.felix.http.jettyEnabled", true);
        configuration.put("org.apache.felix.http.whiteboardEnabled", true);
    }
}

