/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http;

import java.io.IOException;
import java.util.Deque;
import java.util.LinkedList;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.sensinact.gateway.generic.ExtModelConfiguration;
import org.eclipse.sensinact.gateway.generic.InvalidProtocolStackException;
import org.eclipse.sensinact.gateway.generic.ProtocolStackEndpoint;
import org.eclipse.sensinact.gateway.generic.Task;
import org.eclipse.sensinact.gateway.protocol.http.Headers;
import org.eclipse.sensinact.gateway.protocol.http.HeadersCollection;
import org.eclipse.sensinact.gateway.sthbnd.http.HttpPacket;
import org.eclipse.sensinact.gateway.sthbnd.http.HttpResponse;
import org.eclipse.sensinact.gateway.sthbnd.http.task.HttpDiscoveryTask;
import org.eclipse.sensinact.gateway.sthbnd.http.task.HttpTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public abstract class HttpProtocolStackEndpoint
extends ProtocolStackEndpoint<HttpPacket> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpProtocolStackEndpoint.class);
    protected Headers permanentHeaders = new HeadersCollection();
    protected Deque<HttpDiscoveryTask<?, ?>> discovery = new LinkedList();
    protected Deque<HttpTask<?, ?>> disconnexion = new LinkedList();
    protected Class<? extends HttpPacket> packetType;
    private boolean stopping = false;

    public void send(Task task) {
        HttpTask _task = (HttpTask)task;
        _task.addHeaders(this.permanentHeaders.getHeaders());
        if (_task.getPacketType() == null) {
            _task.setPacketType(this.packetType);
        }
        try {
            Object request = _task.build();
            HttpResponse response = (HttpResponse)request.send();
            if (response == null) {
                LOG.error("Unable to connect");
                return;
            }
            if (!_task.isDirect()) {
                HttpPacket packet = response.createPacket();
                this.process(packet);
            } else {
                _task.setResult(new String(response.getContent()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public void connect(ExtModelConfiguration<HttpPacket> manager) throws InvalidProtocolStackException {
        this.packetType = manager.getPacketType();
        super.connect(manager);
        block2: for (HttpDiscoveryTask<?, ?> discoveryTask : this.discovery) {
            if (discoveryTask == null) continue;
            this.connector.execute(discoveryTask);
            for (long wait = discoveryTask.getTimeout(); !discoveryTask.isResultAvailable() && wait > 0L; wait -= 150L) {
                try {
                    Thread.sleep(150L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    if (!LOG.isErrorEnabled()) continue block2;
                    LOG.error(e.getMessage(), (Throwable)e);
                    continue block2;
                }
            }
        }
    }

    public void registerPermanentHeader(String header, String value) {
        if (header != null && value != null) {
            this.permanentHeaders.addHeader(header, value);
        }
    }

    public void registerDiscoveryTask(HttpDiscoveryTask<?, ?> task) {
        if (task != null) {
            this.discovery.add(task);
        }
    }

    public void registerDisconnexionTask(HttpTask<?, ?> task) {
        if (task != null) {
            this.disconnexion.add(task);
        }
    }

    public Task.RequestType getRequestType() {
        return Task.RequestType.URI;
    }

    public void stop() {
        this.stopping = true;
        block2: for (HttpTask<?, ?> disconnexionTask : this.disconnexion) {
            if (disconnexionTask == null) continue;
            this.connector.execute(disconnexionTask);
            for (long wait = disconnexionTask.getTimeout(); !disconnexionTask.isResultAvailable() && wait > 0L; wait -= 150L) {
                try {
                    Thread.sleep(150L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    if (!LOG.isErrorEnabled()) continue block2;
                    LOG.error(e.getMessage(), (Throwable)e);
                    continue block2;
                }
            }
        }
        if (this.connector != null) {
            this.connector.stop();
        }
    }
}

