/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http;

import java.io.InputStream;
import org.eclipse.sensinact.gateway.generic.Task;
import org.eclipse.sensinact.gateway.sthbnd.http.HttpPacket;
import org.eclipse.sensinact.gateway.sthbnd.http.HttpResponse;

public class HttpResponsePacket
extends HttpPacket {
    protected Task.CommandType command;
    protected int statusCode = -1;
    protected String path;
    protected String savedContent;
    protected boolean consume;
    private HttpResponse response;

    public HttpResponsePacket(HttpResponse response) {
        this(response, false, true);
        this.savedContent = null;
    }

    public HttpResponsePacket(HttpResponse response, boolean save, boolean consume) {
        super(response != null && !save && consume ? response.getContent() : new byte[]{});
        if (save) {
            this.savedContent = response.save();
        }
        if (!consume) {
            this.response = response;
        }
        this.consume = consume;
        this.setStatusCode(this.statusCode);
        this.path = response.getPath();
        this.command = response.getCommand();
        super.addHeaders(response.getHeaders());
    }

    public Task.CommandType getCommand() {
        return this.command;
    }

    public String getPath() {
        return this.path;
    }

    public InputStream getInputStream() {
        if (!this.consume && this.response != null) {
            return this.response.inputStream();
        }
        return null;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void finalize() {
        if (this.response != null) {
            this.response.disconnect();
        }
        this.response = null;
    }
}

