/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.smpl;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.sensinact.gateway.generic.Task;
import org.eclipse.sensinact.gateway.sthbnd.http.HttpPacket;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpTaskBuilder;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpTaskConfigurator;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.SimpleHttpProtocolStackEndpoint;
import org.eclipse.sensinact.gateway.sthbnd.http.task.HttpTask;
import org.eclipse.sensinact.gateway.sthbnd.http.task.config.HttpChildTaskConfigurationDescription;
import org.eclipse.sensinact.gateway.sthbnd.http.task.config.HttpTaskConfigurationDescription;
import org.eclipse.sensinact.gateway.sthbnd.http.task.config.KeyValuePairDescription;
import org.eclipse.sensinact.gateway.sthbnd.http.task.config.NestedMappingDescription;
import org.eclipse.sensinact.gateway.sthbnd.http.task.config.RootMappingDescription;
import org.eclipse.sensinact.gateway.util.ReflectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SimpleTaskConfigurator
implements HttpTaskBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleTaskConfigurator.class);
    public static final String VALUE_PATTERN = "\\$\\(([^\\)\\@]+)\\)";
    public static final String CONTEXT_PATTERN = "\\@context\\[([^\\]\\$]+)\\]";
    protected SimpleHttpProtocolStackEndpoint endpoint;
    private Pattern valuePattern;
    private Pattern contextPattern;
    private String acceptType = null;
    private String contentType = null;
    private String httpMethod = null;
    private String scheme = null;
    private String host = null;
    private String port = null;
    private String path = null;
    private String profile = null;
    private String clientCertificate = null;
    private String clientCertificatePassword = null;
    private String serverCertificate = null;
    private boolean direct = false;
    private int readTimeout = -1;
    private int connectTimeout = -1;
    private Task.CommandType command = null;
    private Map<String, List<String>> query = null;
    private Map<String, List<String>> headers = null;
    private Class<? extends HttpPacket> packetType = null;
    private HttpTaskConfigurator contentBuilder = null;
    private HttpTaskConfigurator urlBuilder = null;
    private NestedMappingDescription[] nestedMapping = null;
    private RootMappingDescription[] rootMapping = null;

    private static List<KeyValuePairDescription> join(List<KeyValuePairDescription> pa, List<KeyValuePairDescription> pb) {
        ArrayList<KeyValuePairDescription> joined = new ArrayList<KeyValuePairDescription>();
        if (pa != null && !pa.isEmpty()) {
            joined.addAll(pa);
        }
        if (pb != null && !pb.isEmpty()) {
            joined.addAll(pb);
        }
        return joined;
    }

    public SimpleTaskConfigurator(SimpleHttpProtocolStackEndpoint endpoint, String profile, Task.CommandType command, HttpTaskConfigurator urlBuilder, HttpTaskConfigurationDescription annotation) {
        this(endpoint, profile, command, urlBuilder, annotation, null);
    }

    public SimpleTaskConfigurator(SimpleHttpProtocolStackEndpoint endpoint, String profile, Task.CommandType command, HttpTaskConfigurator urlBuilder, HttpTaskConfigurationDescription parent, HttpChildTaskConfigurationDescription child) {
        Class<? extends HttpTaskConfigurator> taskContentConfigurationType;
        int index;
        this.endpoint = endpoint;
        this.valuePattern = Pattern.compile(VALUE_PATTERN);
        this.contextPattern = Pattern.compile(CONTEXT_PATTERN);
        this.acceptType = child != null && !"#EMPTY#".equals(child.getAcceptType()) ? child.getAcceptType() : parent.getAcceptType();
        this.contentType = child != null && !"#EMPTY#".equals(child.getContentType()) ? child.getContentType() : parent.getContentType();
        this.httpMethod = child != null && !"#EMPTY#".equals(child.getHttpMethod()) ? child.getHttpMethod() : parent.getHttpMethod();
        this.scheme = child != null && !"#EMPTY#".equals(child.getScheme()) ? child.getScheme() : parent.getScheme();
        this.host = child != null && !"#EMPTY#".equals(child.getHost()) ? child.getHost() : parent.getHost();
        this.port = child != null && !"#EMPTY#".equals(child.getPort()) ? child.getPort() : parent.getPort();
        this.path = child != null && !"#EMPTY#".equals(child.getPath()) ? child.getPath() : parent.getPath();
        this.clientCertificate = child != null && !"#NO_CERTIFICATE#".equals(child.getClientSSLCertificate()) ? child.getClientSSLCertificate() : parent.getClientSSLCertificate();
        this.clientCertificatePassword = child != null && !"#NO_CERTIFICATE#".equals(child.getClientSSLCertificatePassword()) ? child.getClientSSLCertificatePassword() : parent.getClientSSLCertificatePassword();
        this.serverCertificate = child != null && !"#NO_CERTIFICATE#".equals(child.getClientSSLCertificate()) ? child.getClientSSLCertificate() : parent.getClientSSLCertificate();
        this.readTimeout = child != null && -1 != child.getReadTimeout() ? child.getReadTimeout() : parent.getReadTimeout();
        this.connectTimeout = child != null && -1 != child.getConnectTimeout() ? child.getConnectTimeout() : parent.getConnectTimeout();
        this.nestedMapping = child != null && HttpChildTaskConfigurationDescription.DEFAULT_NESTED_MAPPING != child.getNestedMapping() ? child.getNestedMapping() : parent.getNestedMapping();
        this.rootMapping = child != null && HttpChildTaskConfigurationDescription.DEFAULT_ROOT_MAPPING != child.getRootMapping() ? child.getRootMapping() : parent.getRootMapping();
        this.setProfile(profile);
        this.urlBuilder = urlBuilder;
        this.command = command;
        this.direct = child != null ? child.isDirect() : parent.isDirect();
        this.packetType = child != null && HttpPacket.class != child.getPacket() ? child.getPacket() : parent.getPacket();
        List<KeyValuePairDescription> queryParameters = SimpleTaskConfigurator.join(child == null ? null : child.getQuery(), parent.getQuery());
        int length = queryParameters == null ? 0 : queryParameters.size();
        this.query = new HashMap<String, List<String>>();
        for (index = 0; index < length; ++index) {
            String key = queryParameters.get(index).getKey();
            String value = queryParameters.get(index).getValue();
            List<String> values = this.query.get(key);
            if (values == null) {
                values = new ArrayList<String>();
                this.query.put(key, values);
            }
            values.add(value);
        }
        this.headers = new HashMap<String, List<String>>();
        List<KeyValuePairDescription> headersParameters = SimpleTaskConfigurator.join(child == null ? null : child.getHeaders(), parent.getHeaders());
        int n = length = headersParameters == null ? 0 : headersParameters.size();
        for (index = 0; index < length; ++index) {
            String key = headersParameters.get(index).getKey();
            String value = headersParameters.get(index).getValue();
            List<String> values = this.headers.get(key);
            if (values == null) {
                values = new ArrayList<String>();
                this.headers.put(key, values);
            }
            values.add(value);
        }
        Class<? extends HttpTaskConfigurator> clazz = taskContentConfigurationType = child != null && HttpTaskConfigurator.class != child.getContent() ? child.getContent() : parent.getContent();
        if (taskContentConfigurationType != null && taskContentConfigurationType != HttpTaskConfigurator.class) {
            try {
                this.contentBuilder = (HttpTaskConfigurator)ReflectUtils.getTheBestInstance(taskContentConfigurationType, (Object[])new Object[]{this.endpoint.getMediator()});
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private String resolve(HttpTask<?, ?> key, String value) {
        String argument = value;
        String resolved = null;
        while (argument != null) {
            StringBuilder builder;
            String val;
            int contextIndex;
            Matcher valueMatcher = this.valuePattern.matcher(argument);
            Matcher contextMatcher = this.contextPattern.matcher(argument);
            int valueIndex = valueMatcher.find() ? valueMatcher.start(1) : -1;
            int n = contextIndex = contextMatcher.find() ? contextMatcher.start(1) : -1;
            if (valueIndex > contextIndex) {
                val = (String)this.endpoint.getMediator().getProperty(valueMatcher.group(1));
                builder = new StringBuilder().append(argument.substring(0, valueMatcher.start(1) - 2)).append(val).append(argument.substring(valueMatcher.end(1) + 1, argument.length()));
                argument = builder.toString();
                continue;
            }
            if (contextIndex > valueIndex) {
                val = this.endpoint.getMediator().resolve(key, contextMatcher.group(1));
                builder = new StringBuilder().append(argument.substring(0, contextMatcher.start(1) - 9)).append(val).append(argument.substring(contextMatcher.end(1) + 1, argument.length()));
                argument = builder.toString();
                continue;
            }
            resolved = argument;
            break;
        }
        return resolved;
    }

    @Override
    public <T extends HttpTask<?, ?>> void configure(T task) throws Exception {
        try {
            int port;
            String portStr = this.resolve(task, this.port);
            try {
                port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException e) {
                port = 80;
            }
            String uri = new URL(this.resolve(task, this.scheme), this.resolve(task, this.host), port, this.resolve(task, this.path)).toExternalForm();
            StringBuilder queryBuilder = new StringBuilder();
            Iterator<Map.Entry<String, List<String>>> iterator = this.query.entrySet().iterator();
            Map.Entry<String, List<String>> entry = null;
            int position = -1;
            while (iterator.hasNext()) {
                int length;
                entry = iterator.next();
                List<String> values = entry.getValue();
                if (values == null || values.isEmpty()) continue;
                queryBuilder.append(++position == 0 ? "?" : "");
                int n = length = values == null ? 0 : values.size();
                for (int index = 0; index < length; ++index) {
                    queryBuilder.append(position > 0 || index > 0 ? "&" : "");
                    queryBuilder.append(this.resolve(task, entry.getKey()));
                    queryBuilder.append("=");
                    queryBuilder.append(this.resolve(task, values.get(index)));
                }
            }
            String queryRequest = queryBuilder.toString();
            if (queryRequest.length() > 1) {
                uri = uri + queryRequest;
            }
            task.setUri(uri);
            if (this.urlBuilder != null) {
                this.urlBuilder.configure(task);
            }
            task.setClientSSLCertificate("#NO_CERTIFICATE#".equals(this.clientCertificate) ? null : this.clientCertificate);
            task.setClientSSLCertificatePassword("#NO_CERTIFICATE#".equals(this.clientCertificatePassword) ? null : this.clientCertificatePassword);
            task.setServerSSLCertificate("#NO_CERTIFICATE#".equals(this.serverCertificate) ? "TRUST_ALL" : this.serverCertificate);
            task.setDirect(this.direct);
            iterator = this.headers.entrySet().iterator();
            entry = null;
            position = -1;
            while (iterator.hasNext()) {
                int length;
                entry = iterator.next();
                List<String> values = entry.getValue();
                if (values == null || values.isEmpty()) continue;
                int n = length = values == null ? 0 : values.size();
                for (int index = 0; index < length; ++index) {
                    task.addHeader(this.resolve(task, entry.getKey()), this.resolve(task, values.get(index)));
                }
            }
            if (this.packetType != HttpPacket.class) {
                task.setPacketType(this.packetType);
            }
            task.setAccept(this.resolve(task, this.acceptType));
            task.setContentType(this.resolve(task, this.contentType));
            task.setHttpMethod(this.resolve(task, this.httpMethod));
            task.setReadTimeout(this.readTimeout);
            task.setConnectTimeout(this.connectTimeout);
            if (this.nestedMapping != null && this.nestedMapping.length > 0) {
                task.setMapping(this.nestedMapping);
            } else if (this.rootMapping != null && this.rootMapping.length > 0) {
                task.setMapping(this.rootMapping);
            }
            if (this.contentBuilder != null) {
                this.contentBuilder.configure(task);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Task.CommandType handled() {
        return this.command;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }
}

