/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.task;

import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.generic.Task;
import org.eclipse.sensinact.gateway.protocol.http.client.Request;
import org.eclipse.sensinact.gateway.sthbnd.http.HttpProtocolStackEndpoint;
import org.eclipse.sensinact.gateway.sthbnd.http.HttpResponse;
import org.eclipse.sensinact.gateway.sthbnd.http.task.HttpDiscoveryTask;
import org.eclipse.sensinact.gateway.util.CastUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSubscribingTask<RESPONSE extends HttpResponse, REQUEST extends Request<RESPONSE>>
extends HttpDiscoveryTask<RESPONSE, REQUEST> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpSubscribingTask.class);
    private Executable<Object, String> subscriptionIdExtractor;
    private String subscriptionId;

    public HttpSubscribingTask(HttpProtocolStackEndpoint transmitter, Class<REQUEST> requestType, Object[] parameters) {
        super(Task.CommandType.SUBSCRIBE, transmitter, requestType, parameters);
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    public String getSubscriptionIdentitifer() {
        return this.subscriptionId;
    }

    private void setSubscriptionIdentitifer(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public void registerSubscriptionIdExtractor(Executable<Object, String> subscriptionIdExtractor) {
        this.subscriptionIdExtractor = subscriptionIdExtractor;
    }

    public void setResult(Object result, long timestamp) {
        super.setResult(result, timestamp);
        if (this.result != null && this.result == AccessMethod.EMPTY) {
            return;
        }
        String value = null;
        try {
            value = this.subscriptionIdExtractor == null ? (String)CastUtils.cast(String.class, (Object)result) : (String)this.subscriptionIdExtractor.execute(result);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        this.setSubscriptionIdentitifer(value);
    }
}

