/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.task;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.gateway.core.ResourceConfig;
import org.eclipse.sensinact.gateway.generic.Task;
import org.eclipse.sensinact.gateway.generic.TaskImpl;
import org.eclipse.sensinact.gateway.generic.TaskTranslator;
import org.eclipse.sensinact.gateway.protocol.http.HeadersCollection;
import org.eclipse.sensinact.gateway.protocol.http.client.ConnectionConfiguration;
import org.eclipse.sensinact.gateway.protocol.http.client.ProxyConfiguration;
import org.eclipse.sensinact.gateway.protocol.http.client.Request;
import org.eclipse.sensinact.gateway.sthbnd.http.HttpPacket;
import org.eclipse.sensinact.gateway.sthbnd.http.HttpResponse;
import org.eclipse.sensinact.gateway.sthbnd.http.task.HttpTask;
import org.eclipse.sensinact.gateway.sthbnd.http.task.config.MappingDescription;
import org.eclipse.sensinact.gateway.util.ReflectUtils;

public class HttpTaskImpl<RESPONSE extends HttpResponse, REQUEST extends Request<RESPONSE>>
extends TaskImpl
implements HttpTask<RESPONSE, REQUEST> {
    protected Object content;
    protected int readTimeout;
    protected int connectTimeout;
    protected String contentType;
    protected String acceptType;
    protected String uri;
    protected String httpMethod;
    protected String serverCertificate;
    protected String clientCertificate;
    protected String clientCertificatePassword;
    protected ProxyConfiguration proxyConfiguration;
    protected Map<String, String> queries;
    protected HeadersCollection headers;
    protected Class<? extends HttpPacket> packetType;
    protected Class<REQUEST> requestType;
    protected MappingDescription[] mappings;
    protected boolean direct;

    public HttpTaskImpl(Task.CommandType command, TaskTranslator transmitter, Class<REQUEST> requestType, String path, String profileId, ResourceConfig resourceConfig, Object[] parameters) {
        super(command, transmitter, path, profileId, resourceConfig, parameters);
        this.requestType = requestType;
        this.queries = new HashMap<String, String>();
        this.headers = new HeadersCollection();
        this.proxyConfiguration = new ProxyConfiguration();
    }

    public HttpTaskImpl<RESPONSE, REQUEST> queryParameter(String key, String value) {
        if (key != null && key.length() > 0 && value != null && value.length() > 0) {
            this.queries.put(key, value);
        }
        return this;
    }

    @Override
    public HttpTaskImpl<RESPONSE, REQUEST> setPacketType(Class<? extends HttpPacket> packetType) {
        this.packetType = packetType;
        return this;
    }

    @Override
    public Class<? extends HttpPacket> getPacketType() {
        return this.packetType;
    }

    @Override
    public HttpTask<RESPONSE, REQUEST> setMapping(MappingDescription[] mappings) {
        this.mappings = mappings;
        return this;
    }

    @Override
    public MappingDescription[] getMapping() {
        return this.mappings;
    }

    public HttpTaskImpl<RESPONSE, REQUEST> setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public String getUri() {
        if (!this.queries.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.uri);
            Iterator<Map.Entry<String, String>> iterator = this.queries.entrySet().iterator();
            int index = 0;
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                builder.append(index == 0 ? "?" : "&");
                builder.append(entry.getKey());
                builder.append("=");
                builder.append(entry.getValue());
                ++index;
            }
            return builder.toString();
        }
        return this.uri;
    }

    public HttpTaskImpl<RESPONSE, REQUEST> setContent(Object content) {
        this.content = content;
        return this;
    }

    public Object getContent() {
        return this.content;
    }

    public HttpTaskImpl<RESPONSE, REQUEST> setAccept(String acceptType) {
        this.acceptType = acceptType;
        return this;
    }

    public String getAccept() {
        return this.acceptType;
    }

    public HttpTaskImpl<RESPONSE, REQUEST> setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public HttpTaskImpl<RESPONSE, REQUEST> setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    public String getHttpMethod() {
        if (this.httpMethod == null) {
            return "GET";
        }
        return this.httpMethod;
    }

    public HttpTaskImpl<RESPONSE, REQUEST> setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public int getConnectTimeout() {
        if (this.connectTimeout <= 0) {
            return 5000;
        }
        return this.connectTimeout;
    }

    public HttpTaskImpl<RESPONSE, REQUEST> setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public int getReadTimeout() {
        if (this.readTimeout <= 0) {
            return 5000;
        }
        return this.readTimeout;
    }

    public HttpTaskImpl<RESPONSE, REQUEST> setProxyHost(String proxyHost) {
        this.proxyConfiguration.setProxyHost(proxyHost);
        return this;
    }

    public HttpTaskImpl<RESPONSE, REQUEST> setProxyPort(int proxyPort) {
        this.proxyConfiguration.setProxyPort(proxyPort);
        return this;
    }

    public Proxy getProxy() {
        return this.proxyConfiguration.getProxy();
    }

    public void setServerSSLCertificate(String serverCertificate) {
        this.serverCertificate = serverCertificate;
    }

    public String getServerSSLCertificate() {
        return this.serverCertificate;
    }

    public void setClientSSLCertificate(String clientCertificate) {
        this.clientCertificate = clientCertificate;
    }

    public String getClientSSLCertificate() {
        return this.clientCertificate;
    }

    public String getClientSSLCertificatePassword() {
        return this.clientCertificatePassword;
    }

    public void setClientSSLCertificatePassword(String clientCertificatePassword) {
        this.clientCertificatePassword = clientCertificatePassword;
    }

    public HttpURLConnection connect() throws IOException {
        return ConnectionConfiguration.HttpURLConnectionBuilder.build((ConnectionConfiguration)this);
    }

    public void addHeaders(Map<String, List<String>> headers) {
        this.headers.addHeaders(headers);
    }

    public void addHeader(String header, String value) {
        this.headers.addHeader(header, value);
    }

    public void addHeader(String header, List<String> values) {
        this.headers.addHeader(header, values);
    }

    public List<String> getHeader(String header) {
        return this.headers.getHeader(header);
    }

    public String getHeaderAsString(String header) {
        return this.headers.getHeaderAsString(header);
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers.getHeaders();
    }

    public Iterator<String> iterator() {
        return this.headers.iterator();
    }

    public Task.RequestType getRequestType() {
        return Task.RequestType.URI;
    }

    public Map<String, List<String>> getOptions() {
        return this.getHeaders();
    }

    @Override
    public HttpTaskImpl<RESPONSE, REQUEST> setDirect(boolean direct) {
        this.direct = direct;
        return this;
    }

    @Override
    public boolean isDirect() {
        return this.direct;
    }

    @Override
    public REQUEST build() {
        return (REQUEST)((Request)ReflectUtils.getInstance(Request.class, this.requestType, (Object[])new Object[]{this}));
    }
}

