/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.task.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.sensinact.gateway.generic.Task;
import org.eclipse.sensinact.gateway.sthbnd.http.annotation.ChainedHttpTask;
import org.eclipse.sensinact.gateway.sthbnd.http.task.HttpChainedTasks;
import org.eclipse.sensinact.gateway.sthbnd.http.task.JSONHttpChainedTasks;
import org.eclipse.sensinact.gateway.sthbnd.http.task.config.HttpChildTaskConfigurationDescription;
import org.eclipse.sensinact.gateway.sthbnd.http.task.config.HttpTaskConfigurationDescription;

public class ChainedHttpTaskDescription {
    @JsonProperty(value="profile")
    private String profile;
    @JsonProperty(value="commands")
    private List<Task.CommandType> commands;
    @JsonProperty(value="chaining")
    private Class<? extends HttpChainedTasks> chaining;
    @JsonProperty(value="configuration")
    private HttpTaskConfigurationDescription configuration;
    @JsonProperty(value="chain")
    private List<HttpChildTaskConfigurationDescription> chain;

    public static ChainedHttpTaskDescription toDescription(ChainedHttpTask chainedHttpTask) {
        ChainedHttpTaskDescription description = new ChainedHttpTaskDescription();
        description.setChain(HttpChildTaskConfigurationDescription.toDescription(chainedHttpTask.chain()));
        description.setChaining(chainedHttpTask.chaining());
        description.setCommands(Arrays.asList(chainedHttpTask.commands()));
        description.setConfiguration(HttpTaskConfigurationDescription.toDescription(chainedHttpTask.configuration()));
        description.setProfile(chainedHttpTask.profile());
        return description;
    }

    public ChainedHttpTaskDescription() {
    }

    public ChainedHttpTaskDescription(String profile, List<Task.CommandType> commands, Class<? extends HttpChainedTasks> chaining, HttpTaskConfigurationDescription configuration, List<HttpChildTaskConfigurationDescription> chain) {
        this.profile = profile;
        if (commands != null) {
            this.commands = Collections.unmodifiableList(commands);
        }
        this.chaining = chaining;
        this.configuration = configuration;
        if (chain != null) {
            this.chain = Collections.unmodifiableList(chain);
        }
    }

    public String getProfile() {
        if (this.profile == null) {
            return "#ANY_PROFILE#";
        }
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public List<Task.CommandType> getCommands() {
        if (this.commands == null) {
            return Arrays.asList(Task.CommandType.GET);
        }
        return this.commands;
    }

    public void setCommands(List<Task.CommandType> commands) {
        if (commands != null) {
            this.commands = Collections.unmodifiableList(commands);
        }
    }

    public Class<? extends HttpChainedTasks> getChaining() {
        if (this.chaining == null) {
            return JSONHttpChainedTasks.class;
        }
        return this.chaining;
    }

    public void setChaining(Class<? extends HttpChainedTasks> chaining) {
        this.chaining = chaining;
    }

    public HttpTaskConfigurationDescription getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(HttpTaskConfigurationDescription configuration) {
        this.configuration = configuration;
    }

    public List<HttpChildTaskConfigurationDescription> getChain() {
        if (this.chain == null) {
            return Collections.emptyList();
        }
        return this.chain;
    }

    public void setChain(List<HttpChildTaskConfigurationDescription> chain) {
        if (chain != null) {
            this.chain = Collections.unmodifiableList(chain);
        }
    }
}

