/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.task.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.sensinact.gateway.sthbnd.http.annotation.KeyValuePair;

public class KeyValuePairDescription {
    private static String DEFAULT_OPERATOR = "=";
    @JsonProperty(value="key")
    private String key;
    @JsonProperty(value="value")
    private String value;
    @JsonProperty(value="operator")
    private String operator;

    public static List<KeyValuePairDescription> toDescription(KeyValuePair[] keyValuePairs) {
        ArrayList<KeyValuePairDescription> description = new ArrayList<KeyValuePairDescription>();
        if (keyValuePairs == null || keyValuePairs.length == 0) {
            return description;
        }
        for (KeyValuePair pair : keyValuePairs) {
            description.add(KeyValuePairDescription.toDescription(pair));
        }
        return description;
    }

    public static KeyValuePairDescription toDescription(KeyValuePair keyValuePair) {
        KeyValuePairDescription description = new KeyValuePairDescription();
        description.setKey(keyValuePair.key());
        description.setValue(keyValuePair.value());
        description.setOperator(keyValuePair.operator());
        return description;
    }

    public KeyValuePairDescription() {
    }

    public KeyValuePairDescription(String key, String value, String operator) {
        this.key = key;
        this.value = value;
        this.operator = operator;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getOperator() {
        if (this.operator == null) {
            return DEFAULT_OPERATOR;
        }
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }
}

