/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.task.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import org.eclipse.sensinact.gateway.generic.Task;
import org.eclipse.sensinact.gateway.sthbnd.http.annotation.RecurrentChainedHttpTask;
import org.eclipse.sensinact.gateway.sthbnd.http.task.HttpChainedTasks;
import org.eclipse.sensinact.gateway.sthbnd.http.task.JSONHttpChainedTasks;
import org.eclipse.sensinact.gateway.sthbnd.http.task.config.HttpChildTaskConfigurationDescription;
import org.eclipse.sensinact.gateway.sthbnd.http.task.config.HttpTaskConfigurationDescription;

public class RecurrentChainedHttpTaskDescription {
    @JsonProperty(value="chaining")
    private Class<? extends HttpChainedTasks> chaining;
    @JsonProperty(value="chain")
    private List<HttpChildTaskConfigurationDescription> chain;
    @JsonProperty(value="command")
    private Task.CommandType command;
    @JsonProperty(value="configuration")
    private HttpTaskConfigurationDescription configuration;
    @JsonProperty(value="period")
    private long period;
    @JsonProperty(value="delay")
    private long delay;
    @JsonProperty(value="timeout")
    private long timeout;

    public static RecurrentChainedHttpTaskDescription toDescription(RecurrentChainedHttpTask recurrentChainedHttpTask) {
        RecurrentChainedHttpTaskDescription description = new RecurrentChainedHttpTaskDescription();
        description.setChain(HttpChildTaskConfigurationDescription.toDescription(recurrentChainedHttpTask.chain()));
        description.setChaining(recurrentChainedHttpTask.chaining());
        description.setCommand(recurrentChainedHttpTask.command());
        description.setConfiguration(HttpTaskConfigurationDescription.toDescription(recurrentChainedHttpTask.configuration()));
        description.setDelay(recurrentChainedHttpTask.delay());
        description.setPeriod(recurrentChainedHttpTask.period());
        description.setTimeout(recurrentChainedHttpTask.timeout());
        return description;
    }

    public RecurrentChainedHttpTaskDescription() {
    }

    public RecurrentChainedHttpTaskDescription(Task.CommandType command, Class<? extends HttpChainedTasks> chaining, HttpTaskConfigurationDescription configuration, List<HttpChildTaskConfigurationDescription> chain, long period, long delay, long timeout) {
        this.command = command;
        this.chaining = chaining;
        this.configuration = configuration;
        if (chain != null) {
            this.chain = Collections.unmodifiableList(chain);
        }
        this.period = period;
        this.delay = delay;
        this.timeout = timeout;
    }

    public Class<? extends HttpChainedTasks> getChaining() {
        if (this.chaining == null) {
            return JSONHttpChainedTasks.class;
        }
        return this.chaining;
    }

    public void setChaining(Class<? extends HttpChainedTasks> chaining) {
        this.chaining = chaining;
    }

    public List<HttpChildTaskConfigurationDescription> getChain() {
        if (this.chain == null) {
            return Collections.emptyList();
        }
        return this.chain;
    }

    public void setChain(List<HttpChildTaskConfigurationDescription> chain) {
        if (chain != null) {
            this.chain = Collections.unmodifiableList(chain);
        }
    }

    public Task.CommandType getCommand() {
        if (this.command == null) {
            return Task.CommandType.GET;
        }
        return this.command;
    }

    public void setCommand(Task.CommandType command) {
        this.command = command;
    }

    public HttpTaskConfigurationDescription getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(HttpTaskConfigurationDescription configuration) {
        this.configuration = configuration;
    }

    public long getPeriod() {
        if (this.period <= 0L) {
            return 60000L;
        }
        return this.period;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public long getDelay() {
        if (this.delay <= 0L) {
            return 1000L;
        }
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public long getTimeout() {
        if (this.timeout <= 0L) {
            return -1L;
        }
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

