/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.task.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.sensinact.gateway.generic.Task;
import org.eclipse.sensinact.gateway.sthbnd.http.annotation.SimpleHttpTask;
import org.eclipse.sensinact.gateway.sthbnd.http.task.config.HttpTaskConfigurationDescription;

public class SimpleHttpTaskDescription {
    @JsonProperty(value="profile")
    private String profile;
    @JsonProperty(value="commands")
    private List<Task.CommandType> commands;
    @JsonProperty(value="configuration")
    private HttpTaskConfigurationDescription configuration;

    public static SimpleHttpTaskDescription toDescription(SimpleHttpTask simpleHttpTask) {
        SimpleHttpTaskDescription description = new SimpleHttpTaskDescription();
        description.setCommands(Arrays.asList(simpleHttpTask.commands()));
        description.setConfiguration(HttpTaskConfigurationDescription.toDescription(simpleHttpTask.configuration()));
        description.setProfile(simpleHttpTask.profile());
        return description;
    }

    public SimpleHttpTaskDescription() {
    }

    public SimpleHttpTaskDescription(String profile, List<Task.CommandType> commands, HttpTaskConfigurationDescription configuration) {
        this.profile = profile;
        if (commands != null) {
            this.commands = Collections.unmodifiableList(commands);
        }
        this.configuration = configuration;
    }

    public String getProfile() {
        if (this.profile == null) {
            return "#ANY_PROFILE#";
        }
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public List<Task.CommandType> getCommands() {
        if (this.commands == null) {
            return Arrays.asList(Task.CommandType.GET);
        }
        return this.commands;
    }

    public void setCommands(List<Task.CommandType> commands) {
        if (commands != null) {
            this.commands = Collections.unmodifiableList(commands);
        }
    }

    public HttpTaskConfigurationDescription getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(HttpTaskConfigurationDescription configuration) {
        this.configuration = configuration;
    }
}

