/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.onem2m.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sensinact.gateway.generic.packet.InvalidPacketException;
import org.eclipse.sensinact.gateway.generic.packet.PacketReader;
import org.eclipse.sensinact.gateway.generic.packet.SimplePacketReader;
import org.eclipse.sensinact.gateway.sthbnd.http.HttpPacket;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneM2MHttpPacketReader
extends SimplePacketReader<HttpPacket> {
    private static final Logger LOG = LoggerFactory.getLogger(PacketReader.class);
    public static final String DEFAULT_SERVICE_NAME = "container";
    private List<OneM2MHttpSubPacket> subPackets;
    private HttpPacket packet;

    public void load(HttpPacket packet) throws InvalidPacketException {
        this.packet = packet;
        this.subPackets = new ArrayList<OneM2MHttpSubPacket>();
    }

    public void parse() throws InvalidPacketException {
        if (this.packet == null) {
            super.configureEOF();
            return;
        }
        if (this.subPackets.isEmpty()) {
            try {
                JSONObject content = new JSONObject(new String(this.packet.getBytes()));
                if (LOG.isDebugEnabled()) {
                    LOG.debug(content.toString());
                }
                if (content.has("m2m:uril")) {
                    String[] uris;
                    for (String uri : uris = content.getString("m2m:uril").split(" ")) {
                        String[] elements = uri.split("/");
                        if (elements.length < 3) continue;
                        OneM2MHttpSubPacket sub = new OneM2MHttpSubPacket();
                        if (elements.length >= 5 && elements.length < 6) {
                            sub.resource = elements[4];
                            sub.service = elements[3];
                        } else if ("admin".equalsIgnoreCase(elements[3])) {
                            sub.service = elements[3];
                        } else {
                            sub.resource = elements[3];
                            sub.service = DEFAULT_SERVICE_NAME;
                        }
                        sub.serviceProvider = elements[2];
                        this.subPackets.add(sub);
                    }
                }
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                super.configureEOF();
                throw new InvalidPacketException((Throwable)e);
            }
            if (!this.subPackets.isEmpty()) {
                this.parse();
            }
        } else {
            OneM2MHttpSubPacket sub = this.subPackets.remove(0);
            super.setServiceProviderId(sub.serviceProvider);
            super.setServiceId(sub.service);
            super.setResourceId(sub.resource);
            super.setData(sub.data);
            if (this.subPackets.isEmpty()) {
                this.packet = null;
            }
            super.configure();
            return;
        }
        super.configureEOF();
    }

    class OneM2MHttpSubPacket {
        String serviceProvider;
        String service;
        String resource;
        Object data;

        OneM2MHttpSubPacket() {
        }
    }
}

