/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.onem2m.task;

import java.util.UUID;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.sthbnd.http.HttpProtocolStackEndpoint;
import org.eclipse.sensinact.gateway.sthbnd.http.SimpleHttpRequest;
import org.eclipse.sensinact.gateway.sthbnd.http.SimpleHttpResponse;
import org.eclipse.sensinact.gateway.sthbnd.http.task.HttpBrowsingTask;

public class OneM2MDiscoveryTask
extends HttpBrowsingTask<SimpleHttpResponse, SimpleHttpRequest> {
    private Mediator mediator;

    public OneM2MDiscoveryTask(Mediator mediator, HttpProtocolStackEndpoint transmitter) {
        super(transmitter, SimpleHttpRequest.class);
        this.mediator = mediator;
    }

    public String getUri() {
        String host = (String)this.mediator.getProperty("http.onem2m.host");
        String port = (String)this.mediator.getProperty("http.onem2m.port");
        String cseBase = (String)this.mediator.getProperty("http.onem2m.cse.base");
        String filter = "?ty=3&fu=1";
        super.addHeader("X-M2M-RI", UUID.randomUUID().toString());
        super.addHeader("X-M2M-Origin", "SOrigin");
        return "http://" + host + ":" + port + "/" + cseBase + filter;
    }

    public String getAccept() {
        return "application/json";
    }

    public String getContentType() {
        return "application/json";
    }
}

