/*
 * Decompiled with CFR 0.152.
 */
package org.sensinact.mqtt.server.impl;

import io.moquette.server.config.MemoryConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.sensinact.mqtt.server.MQTTException;
import org.sensinact.mqtt.server.MQTTServerService;
import org.sensinact.mqtt.server.internal.SensiNactServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Designate(ocd=Config.class)
@Component(immediate=true, service={MQTTServerService.class}, configurationPid={"mqtt.server"})
public class MQTTServerImpl
implements MQTTServerService {
    private Logger LOG = LoggerFactory.getLogger(MQTTServerImpl.class);
    public static final String CONFIGURATION_PID = "mqtt.server";
    SensiNactServer server;
    private HashMap<String, SensiNactServer> mqttServiceMap = new HashMap();
    @Activate
    private BundleContext bc;

    @Activate
    public void updateConfig(Config config) {
        if (config.autostart()) {
            try {
                if (config.port() > 0) {
                    this.startService(config.host(), String.valueOf(config.port()));
                } else {
                    this.startService();
                }
            }
            catch (MQTTException e) {
                this.LOG.error("Failed to start MQTT service", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deactivate
    public void stopServer() {
        for (SensiNactServer server : this.mqttServiceMap.values()) {
            try {
                server.stopServer();
            }
            catch (Exception exception) {}
            continue;
            finally {
                this.mqttServiceMap = new HashMap();
            }
        }
    }

    private void pushService(String id, SensiNactServer server) throws MQTTException {
        if (this.mqttServiceMap.get(id) != null) {
            throw new MQTTException(String.format("mqtt service already exists with id %s", id));
        }
        this.mqttServiceMap.put(id, server);
    }

    @Override
    public String startService(String hostParam, String portParam) throws MQTTException {
        try {
            String host = "127.0.0.1";
            String port = "1883";
            Properties properties = new Properties();
            if (portParam != null) {
                Integer.parseInt(portParam);
                port = portParam;
            }
            if (hostParam != null) {
                host = hostParam;
            }
            properties.put("host", host);
            properties.put("port", port);
            properties.put("websocket_port", "disabled");
            this.server = new SensiNactServer(this.bc);
            String id = String.format("%s:%s", host, port);
            if (this.mqttServiceMap.get(id) != null) {
                throw new MQTTException(String.format("MQTT service id %s already exists", id));
            }
            MemoryConfig config = new MemoryConfig(properties);
            this.server.startServer(config, Collections.emptyList(), null, null, null);
            this.pushService(id, this.server);
            return id;
        }
        catch (Exception e) {
            throw new MQTTException("Failed to start MQTT service with the configuration", e);
        }
    }

    @Override
    public String startService(String port) throws MQTTException {
        return this.startService(null, port);
    }

    @Override
    public String startService() throws MQTTException {
        return this.startService(null, null);
    }

    @Override
    public void stopService(String id) throws MQTTException {
        SensiNactServer server = this.mqttServiceMap.remove(id);
        if (server != null) {
            server.stopServer();
        }
    }

    @Override
    public Boolean activeService(String id) throws MQTTException {
        return this.mqttServiceMap.get(id) != null;
    }

    @ObjectClassDefinition
    static @interface Config {
        public boolean autostart() default false;

        public String host() default "";

        public int port() default 0;
    }
}

