/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.test;

import java.io.File;
import java.util.Enumeration;
import java.util.Stack;

public class FilesEnumerator
implements Enumeration<File> {
    Stack<Enumeration<File>> stack = new Stack();

    public FilesEnumerator(File sourceDirectory) {
        this.stack.push(FilesEnumerator.newEnumeration(sourceDirectory));
    }

    @Override
    public boolean hasMoreElements() {
        if (this.stack.isEmpty()) {
            return false;
        }
        Enumeration<File> current = null;
        while (!this.stack.isEmpty() && !(current = this.stack.pop()).hasMoreElements()) {
            current = null;
        }
        if (current != null) {
            this.stack.push(current);
            return true;
        }
        return false;
    }

    @Override
    public File nextElement() {
        if (this.stack.isEmpty()) {
            return null;
        }
        Enumeration<File> current = this.stack.pop();
        File file = current.nextElement();
        this.stack.push(current);
        if (file.isDirectory()) {
            this.stack.push(FilesEnumerator.newEnumeration(file));
        }
        return file;
    }

    private static Enumeration<File> newEnumeration(final File file) {
        return new Enumeration<File>(){
            int position = 0;
            File[] files;
            {
                File[] fileArray;
                if (file.isDirectory()) {
                    fileArray = file.listFiles();
                } else {
                    File[] fileArray2 = new File[1];
                    fileArray = fileArray2;
                    fileArray2[0] = file;
                }
                this.files = fileArray;
            }

            @Override
            public boolean hasMoreElements() {
                return this.position < this.files.length;
            }

            @Override
            public File nextElement() {
                if (this.hasMoreElements()) {
                    return this.files[this.position++];
                }
                return null;
            }
        };
    }
}

