/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.security.Policy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.eclipse.sensinact.gateway.test.BundleContextProvider;
import org.eclipse.sensinact.gateway.test.FilesEnumerator;
import org.eclipse.sensinact.gateway.test.FilterOSGiClassLoader;
import org.eclipse.sensinact.gateway.test.TestPolicy;
import org.eclipse.sensinact.gateway.util.IOUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public abstract class MidOSGiTestBak
implements BundleContextProvider {
    protected static final String AUTO_PROCESSOR = "org.apache.felix.main.AutoProcessor";
    protected static final String FELIX_FRAMEWORK = "org.osgi.framework.launch.Framework";
    protected static final String FELIX_FRAMEWORK_FACTORY = "org.apache.felix.framework.FrameworkFactory";
    protected static final String BUNDLE = "org.osgi.framework.Bundle";
    protected static final String BUNDLE_GET_CONTEXT = "getBundleContext";
    protected static final String BUNDLE_STATE = "getState";
    protected static final String FRAMEWORK_INIT = "init";
    protected static final String FRAMEWORK_START = "start";
    protected static final String FRAMEWORK_STOP = "stop";
    protected static final String FRAMEWORK_FACTORY_INIT_FRAMEWORK = "newFramework";
    protected static final Class<?>[] FRAMEWORK_FACTORY_INIT_FRAMEWORK_TYPES;
    protected static final String FRAMEWORK_WAIT_FOR_STOP = "waitForStop";
    protected static final Class<?>[] FRAMEWORK_WAIT_FOR_STOP_TYPES;
    protected static final long WAIT_FOR_STOP_TIMEOUT = 60000L;
    protected final FilterOSGiClassLoader classloader;
    protected final ClassLoader current;
    protected Object felix;
    protected Class<?> frameworkClass;
    protected BundleContext context;
    protected String policy = null;
    protected File felixDir = null;
    protected File cacheDir = null;
    protected File bundleDir = null;
    protected File loadDir = null;

    protected abstract void doInit(Map<String, Serializable> var1);

    protected abstract boolean isExcluded(String var1);

    public MidOSGiTestBak() throws Exception {
        File confDir;
        String directoryName = "target/felix";
        this.felixDir = new File(directoryName);
        this.bundleDir = new File(this.felixDir, "bundle");
        if (!this.bundleDir.exists()) {
            this.bundleDir.mkdir();
        }
        this.loadDir = new File(this.felixDir, "load");
        if (!this.loadDir.exists()) {
            this.loadDir.mkdir();
        }
        this.cacheDir = new File(this.felixDir, "felix-cache");
        if (!this.cacheDir.exists()) {
            this.cacheDir.mkdir();
        }
        if (!(confDir = new File(this.felixDir, "conf")).exists()) {
            confDir.mkdir();
        }
        this.current = Thread.currentThread().getContextClassLoader();
        FilesEnumerator enumerator = new FilesEnumerator(this.bundleDir);
        ArrayList<URL> urls = new ArrayList<URL>();
        while (enumerator.hasMoreElements()) {
            File file = enumerator.nextElement();
            if (!file.getName().endsWith(".jar") || this.isExcluded(file.getName())) continue;
            urls.add(file.toURI().toURL());
        }
        this.classloader = new FilterOSGiClassLoader(this.current, (BundleContextProvider)this, urls.toArray(new URL[0]));
    }

    public void createDynamicBundle(File manifestFile, File destDirectory, File ... sourceDirectories) throws IOException {
        if (!destDirectory.exists()) {
            return;
        }
        File dynamicBundleFile = new File(destDirectory, "dynamicBundle.jar");
        FileOutputStream fOut = new FileOutputStream(dynamicBundleFile);
        Manifest manifest = null;
        try {
            manifest = new Manifest(new FileInputStream(manifestFile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            try {
                fOut.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        byte[] buf = new byte[1024];
        try (JarOutputStream jarOut = new JarOutputStream((OutputStream)fOut, manifest);){
            int length;
            FileInputStream reader = null;
            int n = length = sourceDirectories == null ? 0 : sourceDirectories.length;
            for (int index = 0; index < length; ++index) {
                File sourceDirectory = sourceDirectories[index];
                FilesEnumerator enumerator = new FilesEnumerator(sourceDirectory);
                while (enumerator.hasMoreElements()) {
                    int len;
                    File file = enumerator.nextElement();
                    if (!file.isFile()) continue;
                    String entryName = null;
                    entryName = sourceDirectory.isDirectory() ? file.getAbsolutePath().substring(sourceDirectory.getAbsolutePath().length() + 1) : file.getName();
                    entryName = entryName.replace(File.separatorChar, '/');
                    jarOut.putNextEntry(new ZipEntry(entryName));
                    reader = new FileInputStream(file);
                    while ((len = reader.read(buf)) > 0) {
                        jarOut.write(buf, 0, len);
                    }
                    reader.close();
                    jarOut.closeEntry();
                }
            }
            jarOut.close();
            this.classloader.addFiltered(new File(destDirectory, "dynamicBundle.jar").toURI().toURL());
        }
    }

    public Bundle installDynamicBundle(URL url) {
        try {
            int length = this.loadDir.listFiles().length;
            String fileName = String.format("test%s.jar", length);
            File testFile = new File(this.loadDir, fileName);
            URL testFileURL = testFile.toURI().toURL();
            FileOutputStream output = new FileOutputStream(new File(this.loadDir, fileName));
            byte[] testJar = IOUtils.read((InputStream)url.openStream(), (boolean)true);
            IOUtils.write((byte[])testJar, (OutputStream)output);
            this.classloader.addFiltered(testFileURL);
            return this.getBundleContext().installBundle(testFileURL.toExternalForm());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    @AfterAll
    public void tearDown() throws Exception {
        long start = System.currentTimeMillis();
        this.frameworkClass.getDeclaredMethod(FRAMEWORK_STOP, new Class[0]).invoke(this.felix, new Object[0]);
        this.frameworkClass.getDeclaredMethod(FRAMEWORK_WAIT_FOR_STOP, FRAMEWORK_WAIT_FOR_STOP_TYPES).invoke(this.felix, 60000L);
        this.felix = null;
        File prefix = new File("target/felix");
        Stack<String> stack = new Stack<String>();
        for (String s : prefix.list()) {
            if (s.equals("bundle") || s.equals("conf")) continue;
            stack.push(s);
        }
        do {
            String current;
            File f;
            String[] list;
            if ((list = (f = new File(prefix, current = (String)stack.peek())).list()) != null && list.length > 0) {
                for (String s : list) {
                    stack.push(current + "/" + s);
                }
            } else {
                f.delete();
                stack.pop();
            }
        } while (!stack.isEmpty());
        new File(prefix, "load").mkdir();
        System.out.println("Felix stopped [" + (System.currentTimeMillis() - start) + "]");
        Thread.sleep(5000L);
    }

    @BeforeAll
    public void init() throws Exception {
        HashMap<String, Serializable> configuration = new HashMap<String, Serializable>();
        if (System.getSecurityManager() == null) {
            configuration.put("org.osgi.framework.security", (Serializable)((Object)"osgi"));
        }
        configuration.put("felix.cache.rootdir", (Serializable)((Object)this.felixDir.getPath()));
        configuration.put("org.osgi.framework.storage", (Serializable)((Object)"felix-cache"));
        configuration.put("org.osgi.framework.bootdelegation", (Serializable)((Object)"*"));
        configuration.put("org.osgi.framework.system.packages.extra", (Serializable)((Object)"org.eclipse.sensinact.gateway.test,org.slf4j,com.sun.net.httpserver,javax.activation,javax.net.ssl,javax.xml.parsers,javax.imageio,javax.management,javax.naming,javax.sql,javax.swing,javax.swing.border,javax.swing.event,javax.management.modelmbean,javax.management.remote,javax.security.auth,javax.security.cert,org.w3c.dom,org.xml.sax,org.xml.sax.helpers,sun.misc,javax.mail,javax.mail.internet,sun.security.action"));
        configuration.put("org.osgi.framework.storage.clean", (Serializable)((Object)"onFirstInit"));
        configuration.put("felix.auto.deploy.action", (Serializable)((Object)"install"));
        configuration.put("felix.log.level", (Serializable)((Object)"4"));
        configuration.put("felix.fileinstall.log.level", (Serializable)((Object)"4"));
        configuration.put("felix.fileinstall.dir", (Serializable)((Object)this.loadDir.getPath()));
        configuration.put("felix.fileinstall.noInitialDelay", (Serializable)((Object)"true"));
        configuration.put("felix.fileinstall.poll", (Serializable)((Object)"1000"));
        configuration.put("felix.fileinstall.bundles.new.start", (Serializable)((Object)"true"));
        configuration.put("org.osgi.framework.startlevel.beginning", (Serializable)((Object)"5"));
        configuration.put("felix.startlevel.bundle", (Serializable)((Object)"5"));
        configuration.put("org.eclipse.sensinact.simulated.gui.enabled", (Serializable)((Object)"false"));
        configuration.put("felix.bootdelegation.classloaders", new HashMap(){

            @Override
            public Object get(Object key) {
                if (Bundle.class.isAssignableFrom(key.getClass())) {
                    if (MidOSGiTestBak.this.isExcluded(((Bundle)key).getSymbolicName())) {
                        return null;
                    }
                    return MidOSGiTestBak.this.classloader;
                }
                return super.get(key);
            }
        });
        configuration.put("org.eclipse.sensinact.gateway.test.codeBase", (Serializable)((Object)this.getAllowedCodeBase()));
        this.doInit(configuration);
        Class<?> factoryClass = this.classloader.loadClass(FELIX_FRAMEWORK_FACTORY);
        Class<?> bundleClass = this.classloader.loadClass(BUNDLE);
        Class<?> autoProcessorClass = this.classloader.loadClass(AUTO_PROCESSOR);
        this.frameworkClass = this.classloader.loadClass(FELIX_FRAMEWORK);
        File manifestFile = new File("./target/generated-test-sources/META-INF/MANIFEST.MF");
        this.createDynamicBundle(manifestFile, this.bundleDir, new File("./target/classes"));
        Object factory = factoryClass.newInstance();
        this.felix = factoryClass.getDeclaredMethod(FRAMEWORK_FACTORY_INIT_FRAMEWORK, FRAMEWORK_FACTORY_INIT_FRAMEWORK_TYPES).invoke(factory, configuration);
        this.frameworkClass.getDeclaredMethod(FRAMEWORK_INIT, new Class[0]).invoke(this.felix, new Object[0]);
        this.context = (BundleContext)bundleClass.getDeclaredMethod(BUNDLE_GET_CONTEXT, new Class[0]).invoke(this.felix, new Object[0]);
        autoProcessorClass.getDeclaredMethod("process", Map.class, BundleContext.class).invoke(null, configuration, this.context);
        this.frameworkClass.getDeclaredMethod(FRAMEWORK_START, new Class[0]).invoke(this.felix, new Object[0]);
        Assertions.assertTrue((bundleClass == Bundle.class ? 1 : 0) != 0);
        Assertions.assertTrue(((Integer)bundleClass.getDeclaredMethod(BUNDLE_STATE, new Class[0]).invoke(this.felix, new Object[0]) == 32 ? 1 : 0) != 0);
        Thread.sleep(5000L);
    }

    protected String getAllowedCodeBase() {
        String m2 = this.getMavenRepository();
        String path = "file:".concat(m2.concat("/*"));
        path = path.concat(",http://felix.extensions:9/");
        String testPath = new File("target/test-classes").getAbsolutePath();
        path = path.concat(String.format(",file:%s%s", testPath.startsWith("/") ? "" : "/", testPath));
        path = path.concat("/*");
        return path;
    }

    protected String getMavenRepository() {
        String m2 = System.getenv().get("M2_REPO");
        if (m2 == null) {
            m2 = System.getProperty("user.home");
            m2 = m2.concat(".m2/repository");
        }
        if (!m2.startsWith("/")) {
            m2 = "/".concat(m2);
        }
        return m2;
    }

    static {
        try {
            Policy.setPolicy(new TestPolicy());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FRAMEWORK_FACTORY_INIT_FRAMEWORK_TYPES = new Class[]{Map.class};
        FRAMEWORK_WAIT_FOR_STOP_TYPES = new Class[]{Long.TYPE};
    }
}

