/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.manager.application;

import org.eclipse.sensinact.gateway.app.manager.application.SensiNactApplication;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.core.Core;
import org.eclipse.sensinact.gateway.core.Session;
import org.eclipse.sensinact.gateway.core.message.MidCallback;
import org.eclipse.sensinact.gateway.core.message.SnaErrorMessage;

public abstract class AbstractSensiNactApplication
implements SensiNactApplication {
    protected Mediator mediator;
    private final String privateKey;
    private final String name;
    private Session session;

    protected abstract SnaErrorMessage doStart();

    protected abstract SnaErrorMessage doStop();

    protected AbstractSensiNactApplication(final Mediator mediator, String name, final String privateKey) {
        this.session = (Session)mediator.callService(Core.class, (Executable)new Executable<Core, Session>(){

            public Session execute(Core core) throws Exception {
                return core.getApplicationSession(mediator, privateKey);
            }
        });
        this.mediator = mediator;
        this.name = name;
        this.privateKey = privateKey;
    }

    @Override
    public SnaErrorMessage start() {
        return this.doStart();
    }

    @Override
    public SnaErrorMessage stop() {
        SnaErrorMessage message = this.doStop();
        return message;
    }

    public Session getSession() {
        return this.session;
    }

    public String getName() {
        return this.name;
    }

    public MidCallback.Type getSnaCallBackType() {
        return MidCallback.Type.UNARY;
    }

    public long getLifetime() {
        return -1L;
    }

    public int getBufferSize() {
        return 0;
    }

    public int getSchedulerDelay() {
        return 0;
    }

    public String getJSON() {
        return null;
    }
}

