/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.basic.test;

import java.util.ArrayList;
import org.eclipse.sensinact.gateway.app.api.function.DataItf;
import org.eclipse.sensinact.gateway.app.api.function.FunctionUpdateListener;
import org.eclipse.sensinact.gateway.app.basic.math.AdditionFunction;
import org.eclipse.sensinact.gateway.app.basic.math.AssignmentFunction;
import org.eclipse.sensinact.gateway.app.basic.math.DivisionFunction;
import org.eclipse.sensinact.gateway.app.basic.math.ModuloFunction;
import org.eclipse.sensinact.gateway.app.basic.math.MultiplicationFunction;
import org.eclipse.sensinact.gateway.app.basic.math.SubtractionFunction;
import org.eclipse.sensinact.gateway.app.manager.component.data.ConstantData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMathFunction {
    private static final Logger LOG = LoggerFactory.getLogger(TestMathFunction.class);
    private FunctionUpdateListener listener = (FunctionUpdateListener)Mockito.mock(FunctionUpdateListener.class);

    @BeforeEach
    public void init() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)LOG.isDebugEnabled()).thenReturn((Object)false);
    }

    public void testAddition() {
        AdditionFunction function = new AdditionFunction();
        function.setListener(this.listener);
        ArrayList<ConstantData> variables = new ArrayList<ConstantData>();
        variables.add(new ConstantData((Object)1, Integer.class));
        variables.add(new ConstantData((Object)2, Integer.class));
        variables.add(new ConstantData((Object)3, Integer.class));
        function.process(variables);
        ((FunctionUpdateListener)Mockito.verify((Object)this.listener)).updatedResult((Object)6.0);
    }

    public void testSubtraction() {
        SubtractionFunction function = new SubtractionFunction();
        function.setListener(this.listener);
        ArrayList<ConstantData> variables = new ArrayList<ConstantData>();
        variables.add(new ConstantData((Object)10, Integer.class));
        variables.add(new ConstantData((Object)4, Integer.class));
        function.process(variables);
        ((FunctionUpdateListener)Mockito.verify((Object)this.listener)).updatedResult((Object)6.0);
    }

    public void testMultiplication() {
        MultiplicationFunction function = new MultiplicationFunction();
        function.setListener(this.listener);
        ArrayList<ConstantData> variables = new ArrayList<ConstantData>();
        variables.add(new ConstantData((Object)10, Integer.class));
        variables.add(new ConstantData((Object)10, Integer.class));
        variables.add(new ConstantData((Object)4, Integer.class));
        function.process(variables);
        ((FunctionUpdateListener)Mockito.verify((Object)this.listener)).updatedResult((Object)400.0);
    }

    public void testDivision() {
        DivisionFunction function = new DivisionFunction();
        function.setListener(this.listener);
        ArrayList<ConstantData> variables = new ArrayList<ConstantData>();
        variables.add(new ConstantData((Object)11, Integer.class));
        variables.add(new ConstantData((Object)4, Integer.class));
        function.process(variables);
        ((FunctionUpdateListener)Mockito.verify((Object)this.listener)).updatedResult((Object)2.75);
    }

    public void testModulo() {
        ModuloFunction function = new ModuloFunction();
        function.setListener(this.listener);
        ArrayList<ConstantData> variables = new ArrayList<ConstantData>();
        variables.add(new ConstantData((Object)11, Integer.class));
        variables.add(new ConstantData((Object)4, Integer.class));
        function.process(variables);
        ((FunctionUpdateListener)Mockito.verify((Object)this.listener)).updatedResult((Object)3.0);
    }

    public void testAssignment() {
        AssignmentFunction function = new AssignmentFunction();
        function.setListener(this.listener);
        ArrayList<ConstantData> variables = new ArrayList<ConstantData>();
        variables.add(new ConstantData((Object)11, Integer.class));
        Assertions.assertTrue((boolean)(((DataItf)variables.get(0)).getValue() instanceof Integer));
        Assertions.assertTrue((boolean)((DataItf)variables.get(0)).getValue().equals(11));
        function.process(variables);
        ((FunctionUpdateListener)Mockito.verify((Object)this.listener)).updatedResult((Object)11);
        variables.clear();
        variables.add(new ConstantData((Object)true, Boolean.class));
        Assertions.assertTrue((boolean)(((DataItf)variables.get(0)).getValue() instanceof Boolean));
        Assertions.assertTrue((boolean)((DataItf)variables.get(0)).getValue().equals(true));
        function.process(variables);
        ((FunctionUpdateListener)Mockito.verify((Object)this.listener)).updatedResult((Object)true);
        variables.clear();
        variables.add(new ConstantData((Object)Float.valueOf(1.0f), Float.class));
        Assertions.assertTrue((boolean)(((DataItf)variables.get(0)).getValue() instanceof Float));
        Assertions.assertTrue((boolean)((DataItf)variables.get(0)).getValue().equals(Float.valueOf(1.0f)));
        function.process(variables);
        ((FunctionUpdateListener)Mockito.verify((Object)this.listener)).updatedResult((Object)Float.valueOf(1.0f));
    }
}

