/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.basic.math;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import org.eclipse.sensinact.gateway.app.api.function.DataItf;
import org.eclipse.sensinact.gateway.app.basic.math.MathFunction;
import org.eclipse.sensinact.gateway.util.CastUtils;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuloFunction
extends MathFunction<Double> {
    private static final Logger LOG = LoggerFactory.getLogger(ModuloFunction.class);
    private static final String JSON_SCHEMA = "modulo.json";

    public static JSONObject getJSONSchemaFunction(BundleContext context) {
        try {
            return new JSONObject(new JSONTokener((Reader)new InputStreamReader(context.getBundle().getResource("/modulo.json").openStream())));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void process(List<DataItf> datas) {
        double result;
        try {
            double value = (Double)CastUtils.cast(Double.TYPE, (Object)datas.get(0).getValue());
            double modulo = (Double)CastUtils.cast(Double.TYPE, (Object)datas.get(1).getValue());
            result = value % modulo;
            if (LOG.isDebugEnabled()) {
                LOG.debug(value + " % " + modulo + " = " + result);
            }
        }
        catch (ClassCastException e) {
            result = Double.NaN;
            LOG.error(e.getMessage(), (Throwable)e);
        }
        super.update((Object)result);
    }
}

