/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.gateway.core.ActionResource;
import org.eclipse.sensinact.gateway.core.ResourceConfigCatalog;
import org.eclipse.sensinact.gateway.core.ResourceDescriptor;
import org.eclipse.sensinact.gateway.generic.ExtModelConfiguration;
import org.eclipse.sensinact.gateway.generic.ExtResourceConfig;
import org.eclipse.sensinact.gateway.generic.ExtResourceDescriptor;
import org.eclipse.sensinact.gateway.generic.parser.XmlResourceConfigHandler;

public class ExtResourceConfigCatalog
implements ResourceConfigCatalog {
    private Map<String, ExtResourceConfig> defaults;
    protected List<ExtResourceConfig> resourceConfigs = new ArrayList<ExtResourceConfig>();

    public ExtResourceConfigCatalog(XmlResourceConfigHandler handler) {
        this(handler, Collections.emptyMap());
    }

    public ExtResourceConfigCatalog(XmlResourceConfigHandler handler, Map<String, String> defaults) {
        HashMap<String, ExtResourceConfig> tmpDefaults = new HashMap<String, ExtResourceConfig>();
        if (handler != null) {
            Iterator<ExtResourceConfig> resourceIterator = handler.getXmlResourceConfigs();
            while (resourceIterator.hasNext()) {
                ExtResourceConfig resourceConfig = resourceIterator.next();
                this.resourceConfigs.add(resourceConfig);
                if (defaults == null) continue;
                String name = resourceConfig.getName();
                for (Map.Entry<String, String> entry : defaults.entrySet()) {
                    String serviceId = null;
                    String config = null;
                    serviceId = entry.getKey();
                    if (serviceId == null || (config = entry.getValue()) == null || !config.equals(name)) continue;
                    tmpDefaults.put(serviceId, resourceConfig);
                }
            }
        }
        this.defaults = Collections.unmodifiableMap(tmpDefaults);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ExtResourceConfig getResourceConfig(ResourceDescriptor resourceConfigDescriptor) {
        if (resourceConfigDescriptor == null) {
            return null;
        }
        ExtResourceConfig resourceConfig2 = null;
        String serviceName = resourceConfigDescriptor.serviceName();
        String resourceName = resourceConfigDescriptor.resourceName();
        byte[] identifier = null;
        String profile = resourceConfigDescriptor.profile();
        if (ExtResourceDescriptor.class.isAssignableFrom(resourceConfigDescriptor.getClass())) {
            identifier = ((ExtResourceDescriptor)resourceConfigDescriptor).identifier();
        }
        int index = -1;
        if (resourceName != null) {
            for (ExtResourceConfig resourceConfig2 : this.resourceConfigs) {
                String rawName;
                String string = rawName = serviceName != null ? resourceConfig2.getRawName(serviceName) : resourceConfig2.getRawName();
                if (resourceName.equalsIgnoreCase(rawName) && resourceConfig2.isProfiled(profile)) return resourceConfig2;
                resourceConfig2 = null;
            }
            return resourceConfig2;
        } else {
            if (identifier == null) return resourceConfig2;
            for (ExtResourceConfig resourceConfig2 : this.resourceConfigs) {
                if (ExtModelConfiguration.compareBytesArrays(identifier, resourceConfig2.getIdentifier())) break;
                resourceConfig2 = null;
            }
        }
        return resourceConfig2;
    }

    public List<ExtResourceConfig> getResourceConfigs(String serviceId) {
        return this.getResourceConfigs("#ANY_PROFILE#", serviceId);
    }

    public List<ExtResourceConfig> getResourceConfigs(String profile, String service) {
        String profileId = profile == null ? "#ANY_PROFILE#" : profile;
        String serviceId = service == null ? "#ANY_TARGET#" : service;
        ArrayList<ExtResourceConfig> list = new ArrayList<ExtResourceConfig>();
        ArrayList<ExtResourceConfig> actionslist = new ArrayList<ExtResourceConfig>();
        for (ExtResourceConfig resourceConfig : this.resourceConfigs) {
            if (!resourceConfig.isProfiled(profileId) || !resourceConfig.isTargeted(serviceId)) continue;
            if (ActionResource.class.isAssignableFrom(resourceConfig.getTypeConfig().getResourceImplementedInterface())) {
                actionslist.add(resourceConfig);
                continue;
            }
            list.add(resourceConfig);
        }
        list.addAll(actionslist);
        return list;
    }

    public ExtResourceConfig getDefaultResourceConfig(String serviceName) {
        return this.getDefaultResourceConfig("#ANY_PROFILE#", serviceName);
    }

    public ExtResourceConfig getDefaultResourceConfig(String profile, String serviceName) {
        return this.defaults.get(serviceName);
    }
}

