/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic.packet;

import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.sensinact.gateway.generic.packet.InvalidPacketException;
import org.eclipse.sensinact.gateway.generic.packet.Packet;
import org.eclipse.sensinact.gateway.generic.packet.PacketReader;
import org.eclipse.sensinact.gateway.generic.packet.PayloadFragment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPacketReader<P extends Packet>
implements PacketReader<P> {
    private static final Logger LOG = LoggerFactory.getLogger(PacketReader.class);
    protected CountDownLatch countDown = new CountDownLatch(1);
    protected ExecutorService worker = Executors.newSingleThreadExecutor();
    protected PayloadFragment subPacket;

    protected AbstractPacketReader() {
    }

    public Iterator<PayloadFragment> iterator() {
        return new Iterator<PayloadFragment>(){

            private void parse() {
                AbstractPacketReader.this.worker.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AbstractPacketReader.this.parse();
                        }
                        catch (InvalidPacketException e) {
                            LOG.error(e.getMessage(), (Throwable)e);
                        }
                    }
                });
            }

            private void await() {
                try {
                    AbstractPacketReader.this.countDown.await();
                    AbstractPacketReader.this.countDown = new CountDownLatch(1);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    AbstractPacketReader.this.setSubPacket(PayloadFragment.EOF_FRAGMENT);
                }
            }

            @Override
            public boolean hasNext() {
                if (AbstractPacketReader.this.subPacket == null) {
                    this.parse();
                    this.await();
                }
                return PayloadFragment.EOF_FRAGMENT != AbstractPacketReader.this.subPacket;
            }

            @Override
            public PayloadFragment next() {
                if (AbstractPacketReader.this.subPacket == null) {
                    this.parse();
                    this.await();
                }
                if (PayloadFragment.EOF_FRAGMENT == AbstractPacketReader.this.subPacket) {
                    return null;
                }
                PayloadFragment fragment = AbstractPacketReader.this.subPacket;
                AbstractPacketReader.this.subPacket = null;
                return fragment;
            }
        };
    }

    protected void setSubPacket(PayloadFragment subPacket) {
        if (subPacket == null) {
            return;
        }
        this.subPacket = subPacket;
        this.countDown.countDown();
    }
}

