/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security.test;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import org.eclipse.sensinact.gateway.common.primitive.Describable;
import org.eclipse.sensinact.gateway.core.AnonymousSession;
import org.eclipse.sensinact.gateway.core.Core;
import org.eclipse.sensinact.gateway.core.ServiceProvider;
import org.eclipse.sensinact.gateway.core.security.Authentication;
import org.eclipse.sensinact.gateway.core.security.Credentials;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.Extensions;
import org.osgi.test.common.annotation.InjectService;
import org.osgi.test.junit5.context.BundleContextExtension;
import org.osgi.test.junit5.context.InstalledBundleExtension;
import org.osgi.test.junit5.service.ServiceExtension;

@Extensions(value={@ExtendWith(value={BundleContextExtension.class}), @ExtendWith(value={InstalledBundleExtension.class}), @ExtendWith(value={ServiceExtension.class})})
@Disabled
public class TestSecurityPattern {
    private static final String SLIDERS_DEFAULT = "[\"slider01\",\"slider02\",\"slider11\"]";
    private static final String SLIDERS_PROP = "org.eclipse.sensinact.simulated.sliders";
    private static final String GUI_ENABLED = "org.eclipse.sensinact.simulated.gui.enabled";
    Method getDescription = Describable.class.getDeclaredMethod("getDescription", new Class[0]);

    public boolean isExcluded(String fileName) {
        switch (fileName) {
            case "org.apache.felix.framework.security.jar": {
                return true;
            }
        }
        return false;
    }

    protected void doInit(Map<String, String> configuration) {
        configuration.put("org.osgi.framework.system.packages.extra", "org.eclipse.sensinact.gateway.test,com.sun.net.httpserver,javax.mail,javax.mail.internet,javax.microedition.io,javax.management.modelmbean,javax.management.remote,javax.persistence,junit.framework,junit.textui,org.w3c.dom,org.xml.sax,org.xml.sax.helpers,sun.misc,sun.security.action");
        configuration.put(GUI_ENABLED, "false");
        configuration.put("org.eclipse.sensinact.gateway.security.jks.filename", "target/felix/bundle/keystore.jks");
        configuration.put("org.eclipse.sensinact.gateway.security.jks.password", "sensiNact_team");
        configuration.put("org.eclipse.sensinact.gateway.security.database", new File("../sensinact-security-core/src/test/resources/sensinact.sqlite").getAbsolutePath());
        configuration.put("felix.auto.start.1", "file:target/felix/bundle/org.osgi.service.component.jar file:target/felix/bundle/org.osgi.service.cm.jar file:target/felix/bundle/org.osgi.service.metatype.jar file:target/felix/bundle/org.osgi.namespace.extender.jar file:target/felix/bundle/org.osgi.util.promise.jar file:target/felix/bundle/org.osgi.util.function.jar file:target/felix/bundle/org.osgi.util.pushstream.jar file:target/felix/bundle/org.osgi.service.log.jar file:target/felix/bundle/org.apache.felix.log.jar file:target/felix/bundle/org.apache.felix.scr.jar file:target/felix/bundle/org.apache.felix.fileinstall.jar file:target/felix/bundle/org.apache.felix.configadmin.jar file:target/felix/bundle/org.apache.felix.framework.security.jar ");
        configuration.put("felix.auto.install.2", "file:target/felix/bundle/slf4j-api.jar file:target/felix/bundle/sensinact-utils.jar file:target/felix/bundle/sensinact-datastore-api.jar file:target/felix/bundle/sensinact-sqlite-connector.jar file:target/felix/bundle/sensinact-common.jar file:target/felix/bundle/sensinact-framework-extension.jar file:target/felix/bundle/sensinact-security-keybuilder.jar file:target/felix/bundle/sensinact-security-core.jar file:target/felix/bundle/slf4j-simple.jar");
        configuration.put("felix.auto.start.2", "file:target/felix/bundle/sensinact-test-configuration.jar file:target/felix/bundle/sensinact-signature-validator.jar file:target/felix/bundle/org.apache.felix.http.servlet-api.jar file:target/felix/bundle/org.apache.felix.http.api.jar file:target/felix/bundle/org.apache.felix.http.jetty.jar file:target/felix/bundle/org.apache.aries.javax.jax.rs-api.jar");
        configuration.put("felix.auto.start.3", "file:target/felix/bundle/sensinact-core.jar file:target/felix/bundle/sensinact-generic.jar ");
        configuration.put("felix.auto.start.4", "file:target/felix/bundle/slider.jar ");
        configuration.put(SLIDERS_PROP, SLIDERS_DEFAULT);
        configuration.put("felix.log.level", "4");
    }

    @Test
    public void testSecurityAccessWithPattern(@InjectService Core core) throws Throwable {
        AnonymousSession session = core.getAnonymousSession();
        Assertions.assertNotNull((Object)session);
        Set providers = session.serviceProviders();
        System.out.println("====================================>>>>>");
        System.out.println(providers);
        System.out.println("====================================>>>>>");
        Assertions.assertTrue((boolean)providers.isEmpty());
        Credentials credentials = new Credentials("cea", "sensiNact_team");
        session = core.getSession((Authentication)credentials);
        Assertions.assertNotNull((Object)session);
        providers = session.serviceProviders();
        Assertions.assertEquals((int)3, (int)providers.size());
        for (ServiceProvider serviceProvider : providers) {
            Assertions.assertEquals((int)2, (int)serviceProvider.getServices().size());
            System.out.println(serviceProvider.getDescription().getJSON());
        }
        credentials = new Credentials("fake", "fake");
        session = core.getSession((Authentication)credentials);
        Assertions.assertNotNull((Object)session);
        Assertions.assertNotNull((Object)session);
        providers = session.serviceProviders();
        Assertions.assertEquals((int)2, (int)providers.size());
        for (ServiceProvider serviceProvider : providers) {
            Assertions.assertEquals((int)1, (int)serviceProvider.getServices().size());
            System.out.println(serviceProvider.getDescription().getJSON());
        }
        credentials = new Credentials("fake2", "fake2");
        session = core.getSession((Authentication)credentials);
        Assertions.assertNotNull((Object)session);
        Assertions.assertNotNull((Object)session);
        providers = session.serviceProviders();
        Assertions.assertEquals((int)1, (int)providers.size());
        for (ServiceProvider serviceProvider : providers) {
            Assertions.assertEquals((int)1, (int)serviceProvider.getServices().size());
            System.out.println(serviceProvider.getDescription().getJSON());
        }
    }
}

