/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.util.stack;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.sensinact.gateway.util.stack.StackEngine;
import org.eclipse.sensinact.gateway.util.stack.StackEngineHandler;

public abstract class AbstractStackEngineHandler<E>
implements StackEngineHandler<E> {
    protected final StackEngine<E, StackEngineHandler<E>> eventEngine = new StackEngine(this, AbstractStackEngineHandler.getWorker());
    private static ScheduledExecutorService sharedExecutor;
    private static long referenceCount;

    public void stop() {
        this.eventEngine.stop();
        try {
            this.eventEngine.awaitTermination();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            AbstractStackEngineHandler.releaseWorker();
        }
    }

    public void close() {
        this.eventEngine.closeWhenEmpty();
        try {
            this.eventEngine.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            AbstractStackEngineHandler.releaseWorker();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ScheduledExecutorService getWorker() {
        Class<AbstractStackEngineHandler> clazz = AbstractStackEngineHandler.class;
        synchronized (AbstractStackEngineHandler.class) {
            ++referenceCount;
            if (sharedExecutor == null) {
                ScheduledThreadPoolExecutor worker = new ScheduledThreadPoolExecutor(1, r -> new Thread(r, "Stack Engine Worker Thread"));
                worker.setMaximumPoolSize(8);
                sharedExecutor = worker;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sharedExecutor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseWorker() {
        Class<AbstractStackEngineHandler> clazz = AbstractStackEngineHandler.class;
        synchronized (AbstractStackEngineHandler.class) {
            if (--referenceCount == 0L) {
                sharedExecutor.shutdownNow();
                sharedExecutor = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static {
        referenceCount = 0L;
    }
}

