/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.simulated.temperature.generator.osgi;

import java.util.Collections;
import java.util.Set;
import org.eclipse.sensinact.gateway.common.annotation.Property;
import org.eclipse.sensinact.gateway.common.bundle.AbstractActivator;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.core.SensiNactResourceModelConfiguration;
import org.eclipse.sensinact.gateway.generic.ExtModelConfiguration;
import org.eclipse.sensinact.gateway.generic.ExtModelConfigurationBuilder;
import org.eclipse.sensinact.gateway.generic.local.LocalProtocolStackEndpoint;
import org.eclipse.sensinact.gateway.simulated.temperature.generator.parser.DataParser;
import org.eclipse.sensinact.gateway.simulated.temperature.generator.parser.DeviceInfo;
import org.eclipse.sensinact.gateway.simulated.temperature.generator.reader.TemperaturesGeneratorPacket;
import org.eclipse.sensinact.gateway.simulated.temperature.generator.thread.TemperaturesGeneratorThreadManager;
import org.osgi.annotation.bundle.Header;
import org.osgi.framework.BundleContext;

@Header(name="Bundle-Activator", value="${@class}")
public class Activator
extends AbstractActivator<Mediator> {
    @Property(name="org.eclipse.sensinact.simulated.generator.amount", defaultValue="100")
    Integer DEVICES_NUMBER;
    private LocalProtocolStackEndpoint<TemperaturesGeneratorPacket> connector;
    private ExtModelConfiguration<TemperaturesGeneratorPacket> manager;
    private TemperaturesGeneratorThreadManager threadManager;

    public void doStart() throws Exception {
        if (this.manager == null) {
            this.manager = ExtModelConfigurationBuilder.instance((Mediator)this.mediator, TemperaturesGeneratorPacket.class).withResourceBuildPolicy((byte)(SensiNactResourceModelConfiguration.BuildPolicy.BUILD_NON_DESCRIBED.getPolicy() | SensiNactResourceModelConfiguration.BuildPolicy.BUILD_COMPLETE_ON_DESCRIPTION.getPolicy())).withServiceBuildPolicy((byte)(SensiNactResourceModelConfiguration.BuildPolicy.BUILD_NON_DESCRIBED.getPolicy() | SensiNactResourceModelConfiguration.BuildPolicy.BUILD_ON_DESCRIPTION.getPolicy())).withStartAtInitializationTime(true).build(new Object[]{"temperature-resource.xml", Collections.emptyMap()});
            this.manager.setObserved(Collections.singletonList("/sensor/temperature/category"));
        }
        if (this.connector == null) {
            this.connector = new LocalProtocolStackEndpoint(this.mediator);
        }
        this.connector.connect(this.manager);
        DataParser dataParser = new DataParser(this.mediator);
        Set<DeviceInfo> deviceInfoSet = dataParser.createDeviceInfosSet(this.DEVICES_NUMBER);
        this.threadManager = new TemperaturesGeneratorThreadManager(this.connector, deviceInfoSet);
        this.threadManager.startThreads();
    }

    public void doStop() throws Exception {
        this.threadManager.stopThreads();
        this.connector.stop();
    }

    public Mediator doInstantiate(BundleContext context) {
        return new Mediator(context);
    }
}

