/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.datastore.sqlite;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.sensinact.gateway.datastore.api.DataStoreConnectionProvider;
import org.eclipse.sensinact.gateway.datastore.api.UnableToConnectToDataStoreException;
import org.eclipse.sensinact.gateway.datastore.api.UnableToFindDataStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlite.Function;

public class SQLiteConnectionProvider
implements DataStoreConnectionProvider<Connection> {
    private static final Logger LOG = LoggerFactory.getLogger(SQLiteConnectionProvider.class);
    private File dbFile;
    private Connection connection;
    private AtomicInteger count;
    private AtomicBoolean stopped;

    public SQLiteConnectionProvider(String dbName) throws UnableToConnectToDataStoreException, UnableToFindDataStoreException {
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            throw new UnableToConnectToDataStoreException("'org.sqlite.JDBC' class not found", (Throwable)e);
        }
        this.connection = null;
        this.count = new AtomicInteger(0);
        this.stopped = new AtomicBoolean(false);
        this.setDataStoreName(dbName);
    }

    private void setDataStoreName(String dbName) throws UnableToFindDataStoreException {
        this.dbFile = new File(dbName).getAbsoluteFile();
        if (!this.dbFile.exists()) {
            throw new UnableToFindDataStoreException("Unable to find data base file : " + this.dbFile.getAbsolutePath());
        }
    }

    public synchronized Connection openConnection() {
        if (this.stopped.get()) {
            return null;
        }
        if (this.connection == null) {
            try {
                String connectionString = "jdbc:sqlite:/" + this.dbFile.getAbsolutePath();
                this.connection = DriverManager.getConnection(connectionString);
                this.connection.setAutoCommit(false);
                Function.create((Connection)this.connection, (String)"regexp", (Function)new SQLiteRegexp());
            }
            catch (SQLException e) {
                LOG.error("openConnection error :", (Throwable)e);
                return null;
            }
        }
        this.count.incrementAndGet();
        return this.connection;
    }

    public synchronized void closeConnection() {
        if (this.connection != null && this.count.decrementAndGet() == 0) {
            try {
                this.connection.close();
                this.connection = null;
            }
            catch (SQLException e) {
                LOG.error("openConnection error :", (Throwable)e);
            }
        }
    }

    public String getDataStoreName() {
        return this.dbFile.getAbsolutePath();
    }

    public void stop() {
        this.stopped.set(true);
    }

    public int getCount() {
        return this.count.get();
    }

    private static final class SQLiteRegexp
    extends Function {
        private SQLiteRegexp() {
        }

        protected void xFunc() throws SQLException {
            int found = 0;
            int parameters = super.args();
            if (parameters == 2) {
                String patternTxt = super.value_text(0);
                String sequenceTxt = super.value_text(1);
                try {
                    Pattern pattern = Pattern.compile(patternTxt);
                    if (pattern.matcher(sequenceTxt).matches()) {
                        found = 1;
                    }
                }
                catch (PatternSyntaxException e) {
                    super.error(e.getMessage());
                }
            }
            super.result(found);
        }
    }
}

