/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.core;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.aries.rsa.core.ClientServiceFactory;
import org.apache.aries.rsa.core.CloseHandler;
import org.apache.aries.rsa.core.event.EventProducer;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.ImportReference;
import org.osgi.service.remoteserviceadmin.ImportRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportRegistrationImpl
implements ImportRegistration,
ImportReference {
    private static final Logger LOG = LoggerFactory.getLogger(ImportRegistrationImpl.class);
    private volatile Throwable exception;
    private volatile ServiceRegistration importedService;
    private EndpointDescription endpoint;
    private volatile ClientServiceFactory clientServiceFactory;
    private CloseHandler closeHandler;
    private AtomicBoolean closed = new AtomicBoolean();
    private AtomicBoolean closing = new AtomicBoolean();
    private boolean detached;
    private ImportRegistrationImpl parent;
    private List<ImportRegistrationImpl> children;
    private EventProducer eventProducer;

    public ImportRegistrationImpl(Throwable ex) {
        this.exception = ex;
        this.initParent();
    }

    public ImportRegistrationImpl(EndpointDescription endpoint, CloseHandler closeHandler, EventProducer eventProducer) {
        this.endpoint = endpoint;
        this.closeHandler = closeHandler;
        this.eventProducer = eventProducer;
        this.initParent();
    }

    public ImportRegistrationImpl(ImportRegistration ir) {
        this.parent = ((ImportRegistrationImpl)ir).getParent();
        this.exception = this.parent.getException();
        this.endpoint = this.parent.getImportedEndpointDescription();
        this.clientServiceFactory = this.parent.clientServiceFactory;
        this.closeHandler = this.parent.closeHandler;
        this.parent.instanceAdded(this);
    }

    private void initParent() {
        this.parent = this;
        this.children = new ArrayList<ImportRegistrationImpl>(1);
    }

    private void ensureParent() {
        if (this.parent != this) {
            throw new IllegalStateException("this method may only be called on the parent");
        }
    }

    private synchronized void instanceAdded(ImportRegistrationImpl iri) {
        this.ensureParent();
        this.children.add(iri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void instanceClosed(ImportRegistration iri) {
        this.ensureParent();
        ImportRegistrationImpl importRegistrationImpl = this;
        synchronized (importRegistrationImpl) {
            this.children.remove(iri);
            if (!this.children.isEmpty() || this.detached || !this.closing.get()) {
                return;
            }
            this.detached = true;
        }
        LOG.debug("really closing ImportRegistration now");
        if (this.importedService != null) {
            try {
                this.importedService.unregister();
            }
            catch (IllegalStateException ise) {
                LOG.debug("imported service is already unregistered");
            }
            this.importedService = null;
        }
        if (this.clientServiceFactory != null) {
            this.clientServiceFactory.setCloseable(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        LOG.debug("close() called");
        ImportRegistrationImpl importRegistrationImpl = this;
        synchronized (importRegistrationImpl) {
            boolean curClosing = this.closing.getAndSet(true);
            if (curClosing || this.isInvalid()) {
                return;
            }
        }
        this.closeHandler.onClose(this);
        this.parent.instanceClosed(this);
        this.closed.set(true);
    }

    public void closeAll() {
        if (this == this.parent) {
            LOG.info("closing down all child ImportRegistrations");
            for (ImportRegistrationImpl ir : this.copyChildren()) {
                ir.close();
            }
            this.close();
        } else {
            this.parent.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ImportRegistrationImpl> copyChildren() {
        ImportRegistrationImpl importRegistrationImpl = this;
        synchronized (importRegistrationImpl) {
            return new ArrayList<ImportRegistrationImpl>(this.children);
        }
    }

    public EndpointDescription getImportedEndpointDescription() {
        return this.isInvalid() ? null : this.endpoint;
    }

    @Override
    public EndpointDescription getImportedEndpoint() {
        return this.getImportedEndpointDescription();
    }

    @Override
    public ServiceReference<?> getImportedService() {
        return this.isInvalid() || this.parent.importedService == null ? null : this.parent.importedService.getReference();
    }

    @Override
    public ImportReference getImportReference() {
        return this;
    }

    @Override
    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable ex) {
        this.exception = ex;
    }

    private synchronized boolean isInvalid() {
        return this.exception != null || this.closed.get();
    }

    public void setImportedServiceRegistration(ServiceRegistration sreg) {
        this.ensureParent();
        this.importedService = sreg;
    }

    public void setClientServiceFactory(ClientServiceFactory csf) {
        this.ensureParent();
        this.clientServiceFactory = csf;
    }

    public ImportRegistrationImpl getParent() {
        return this.parent;
    }

    @Override
    public boolean update(EndpointDescription endpoint) {
        this.importedService.setProperties(new Hashtable<String, Object>(endpoint.getProperties()));
        this.eventProducer.notifyUpdate(this);
        return true;
    }
}

