/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic;

import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.core.ModelConfiguration;
import org.eclipse.sensinact.gateway.core.SensiNactResourceModelConfiguration;
import org.eclipse.sensinact.gateway.generic.ExtModelConfigurationBuilder;
import org.eclipse.sensinact.gateway.generic.ProtocolStackEndpoint;
import org.eclipse.sensinact.gateway.generic.ProtocolStackEndpointConfigurator;
import org.eclipse.sensinact.gateway.generic.SensiNactBridgeConfigurationPojo;
import org.eclipse.sensinact.gateway.generic.packet.Packet;
import org.eclipse.sensinact.gateway.util.ReflectUtils;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ManagedProtocolStackEndpointFactory
implements ManagedServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ManagedProtocolStackEndpointFactory.class);
    private Map<String, ProtocolStackEndpoint> pids;
    private Mediator mediator;
    private final String name;

    protected abstract ProtocolStackEndpointConfigurator configurator();

    public ManagedProtocolStackEndpointFactory(Mediator mediator, String name) {
        this.mediator = mediator;
        this.name = name;
        this.pids = Collections.synchronizedMap(new HashMap());
    }

    public String getName() {
        return this.name;
    }

    public void updated(String servicePID, Dictionary<String, ?> dictionary) throws ConfigurationException {
        if (this.pids.containsKey(servicePID)) {
            this.deleted(servicePID);
        }
        try {
            SensiNactBridgeConfigurationPojo config = null;
            ProtocolStackEndpointConfigurator configurator = this.configurator();
            config = configurator != null ? new SensiNactBridgeConfigurationPojo(configurator) : new SensiNactBridgeConfigurationPojo();
            config.populate(dictionary);
            Class<? extends Packet> packetType = config.getPacketType();
            if (packetType == Packet.class && !config.isOutputOnly()) {
                throw new NullPointerException("No packet type defined");
            }
            byte serviceBuildPolicy = 0;
            for (SensiNactResourceModelConfiguration.BuildPolicy policy : config.getServiceBuildPolicy()) {
                serviceBuildPolicy = (byte)(serviceBuildPolicy | policy.getPolicy());
            }
            byte resourceBuildPolicy = 0;
            for (SensiNactResourceModelConfiguration.BuildPolicy policy : config.getResourceBuildPolicy()) {
                resourceBuildPolicy = (byte)(resourceBuildPolicy | policy.getPolicy());
            }
            Map<String, String> initialMap = config.getInitialProviders();
            ModelConfiguration configuration = ExtModelConfigurationBuilder.instance(this.mediator, packetType).withServiceBuildPolicy(serviceBuildPolicy).withResourceBuildPolicy(resourceBuildPolicy).withStartAtInitializationTime(config.isStartAtInitializationTime()).withObserved(Arrays.asList(config.getObserved())).build(new Object[]{config.getResourceDefinition(), initialMap});
            ProtocolStackEndpoint endpoint = (ProtocolStackEndpoint)ReflectUtils.getInstance(ProtocolStackEndpoint.class, config.getEndpointType(), (Object[])new Object[]{this.mediator});
            if (configurator != null) {
                configurator.preConnectConfiguration(endpoint, configuration, dictionary);
            }
            endpoint.connect(configuration);
            if (configurator != null) {
                configurator.postConnectConfiguration(endpoint, configuration, dictionary);
            }
            this.pids.put(servicePID, endpoint);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public void deleted(String servicePID) {
        try {
            ProtocolStackEndpoint endpoint = this.pids.remove(servicePID);
            endpoint.stop();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public void stop() {
        for (ProtocolStackEndpoint endpoint : this.pids.values()) {
            endpoint.stop();
        }
        this.pids.clear();
    }
}

