/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.simulated.slider.osgi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.sensinact.gateway.common.bundle.AbstractActivator;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.generic.ExtModelConfiguration;
import org.eclipse.sensinact.gateway.generic.ExtModelConfigurationBuilder;
import org.eclipse.sensinact.gateway.generic.local.LocalProtocolStackEndpoint;
import org.eclipse.sensinact.gateway.simulated.slider.api.SliderSetterItf;
import org.eclipse.sensinact.gateway.simulated.slider.internal.SliderAdapter;
import org.eclipse.sensinact.gateway.simulated.slider.internal.SliderGUI;
import org.eclipse.sensinact.gateway.simulated.slider.internal.SliderPacket;
import org.eclipse.sensinact.gateway.simulated.slider.internal.SliderSetter;
import org.json.JSONArray;
import org.osgi.annotation.bundle.Header;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@Header(name="Bundle-Activator", value="${@class}")
public class Activator
extends AbstractActivator<Mediator> {
    private static final String SLIDERS_DEFAULT = "[\"slider\"]";
    private static final String GUI_ENABLED = "org.eclipse.sensinact.simulated.gui.enabled";
    private LocalProtocolStackEndpoint<SliderPacket> connector;
    private List<SliderSetterItf> sliderPanels;
    private List<ServiceRegistration<SliderSetterItf>> sliderRegistrations;

    public void doStart() throws Exception {
        this.sliderPanels = new ArrayList<SliderSetterItf>();
        this.sliderRegistrations = new ArrayList<ServiceRegistration<SliderSetterItf>>();
        ExtModelConfiguration manager = ExtModelConfigurationBuilder.instance((Mediator)this.mediator, SliderPacket.class).withStartAtInitializationTime(true).build(new Object[]{"slider-resource.xml", Collections.emptyMap()});
        this.connector = new LocalProtocolStackEndpoint(this.mediator);
        this.connector.connect(manager);
        String sliders = (String)this.mediator.getProperty("org.eclipse.sensinact.simulated.sliders");
        if (sliders == null) {
            sliders = SLIDERS_DEFAULT;
        }
        JSONArray slidersArray = new JSONArray(sliders);
        for (int i = 0; i < slidersArray.length(); ++i) {
            String id = slidersArray.getString(i);
            SliderSetterItf sliderPanel = null;
            if ("true".equals(this.mediator.getProperty(GUI_ENABLED))) {
                sliderPanel = new SliderGUI(new SliderAdapter(id, this.connector));
                this.sliderPanels.add(sliderPanel);
            } else {
                sliderPanel = new SliderSetter(new SliderAdapter(id, this.connector));
                Hashtable<String, String> props = new Hashtable<String, String>();
                ((Dictionary)props).put("slider.id", id);
                ServiceRegistration sliderRegistration = this.mediator.getContext().registerService(SliderSetterItf.class, (Object)sliderPanel, props);
                this.sliderPanels.add(sliderPanel);
                this.sliderRegistrations.add((ServiceRegistration<SliderSetterItf>)sliderRegistration);
            }
            sliderPanel.move(0);
        }
    }

    public void doStop() throws Exception {
        while (!this.sliderRegistrations.isEmpty()) {
            try {
                this.sliderRegistrations.remove(0).unregister();
            }
            catch (IllegalStateException e) {}
        }
        while (!this.sliderPanels.isEmpty()) {
            this.sliderPanels.remove(0).stop();
        }
        this.connector.stop();
        this.connector = null;
    }

    public Mediator doInstantiate(BundleContext context) {
        return new Mediator(context);
    }
}

