/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core;

import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.constraint.Constraint;
import org.eclipse.sensinact.gateway.common.constraint.ConstraintFactory;
import org.eclipse.sensinact.gateway.common.constraint.InvalidConstraintDefinitionException;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.core.AbstractSession;
import org.eclipse.sensinact.gateway.core.ActionResource;
import org.eclipse.sensinact.gateway.core.AnonymousSession;
import org.eclipse.sensinact.gateway.core.AuthenticatedSession;
import org.eclipse.sensinact.gateway.core.Core;
import org.eclipse.sensinact.gateway.core.DataResource;
import org.eclipse.sensinact.gateway.core.ModelElementProxyBuildException;
import org.eclipse.sensinact.gateway.core.RegistryEndpoint;
import org.eclipse.sensinact.gateway.core.Resource;
import org.eclipse.sensinact.gateway.core.SensiNactResourceModel;
import org.eclipse.sensinact.gateway.core.Service;
import org.eclipse.sensinact.gateway.core.ServiceProvider;
import org.eclipse.sensinact.gateway.core.ServiceProviderImpl;
import org.eclipse.sensinact.gateway.core.Session;
import org.eclipse.sensinact.gateway.core.SessionKey;
import org.eclipse.sensinact.gateway.core.Sessions;
import org.eclipse.sensinact.gateway.core.filtering.FilteringCollection;
import org.eclipse.sensinact.gateway.core.message.AbstractMidAgentCallback;
import org.eclipse.sensinact.gateway.core.message.LocalAgent;
import org.eclipse.sensinact.gateway.core.message.LocalAgentImpl;
import org.eclipse.sensinact.gateway.core.message.MidAgentCallback;
import org.eclipse.sensinact.gateway.core.message.MidCallbackException;
import org.eclipse.sensinact.gateway.core.message.Recipient;
import org.eclipse.sensinact.gateway.core.message.ResourceIntent;
import org.eclipse.sensinact.gateway.core.message.SnaAgent;
import org.eclipse.sensinact.gateway.core.message.SnaFilter;
import org.eclipse.sensinact.gateway.core.message.SnaMessage;
import org.eclipse.sensinact.gateway.core.message.SnaUpdateMessageImpl;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.core.method.AccessMethodResponse;
import org.eclipse.sensinact.gateway.core.method.AccessMethodResponseBuilder;
import org.eclipse.sensinact.gateway.core.method.ActResponse;
import org.eclipse.sensinact.gateway.core.method.DescribeMethod;
import org.eclipse.sensinact.gateway.core.method.DescribeResponse;
import org.eclipse.sensinact.gateway.core.method.DescribeResponseBuilder;
import org.eclipse.sensinact.gateway.core.method.GetResponse;
import org.eclipse.sensinact.gateway.core.method.RemoteAccessMethodExecutable;
import org.eclipse.sensinact.gateway.core.method.SetResponse;
import org.eclipse.sensinact.gateway.core.method.SubscribeResponse;
import org.eclipse.sensinact.gateway.core.method.UnsubscribeResponse;
import org.eclipse.sensinact.gateway.core.remote.SensinactCoreBaseIFaceManager;
import org.eclipse.sensinact.gateway.core.remote.SensinactCoreBaseIFaceManagerFactory;
import org.eclipse.sensinact.gateway.core.remote.SensinactCoreBaseIface;
import org.eclipse.sensinact.gateway.core.security.AccessNode;
import org.eclipse.sensinact.gateway.core.security.AccessTree;
import org.eclipse.sensinact.gateway.core.security.AccountConnector;
import org.eclipse.sensinact.gateway.core.security.Authentication;
import org.eclipse.sensinact.gateway.core.security.InvalidCredentialException;
import org.eclipse.sensinact.gateway.core.security.MutableAccessTree;
import org.eclipse.sensinact.gateway.core.security.SecuredAccess;
import org.eclipse.sensinact.gateway.core.security.SecuredAccessException;
import org.eclipse.sensinact.gateway.core.security.SessionToken;
import org.eclipse.sensinact.gateway.core.security.User;
import org.eclipse.sensinact.gateway.core.security.UserKey;
import org.eclipse.sensinact.gateway.core.security.UserKeyBuilder;
import org.eclipse.sensinact.gateway.core.security.UserKeyBuilderFactory;
import org.eclipse.sensinact.gateway.core.security.UserManager;
import org.eclipse.sensinact.gateway.core.security.UserUpdater;
import org.eclipse.sensinact.gateway.datastore.api.DataStoreException;
import org.eclipse.sensinact.gateway.security.signature.api.BundleValidation;
import org.eclipse.sensinact.gateway.util.CryptoUtils;
import org.eclipse.sensinact.gateway.util.ReflectUtils;
import org.eclipse.sensinact.gateway.util.UriUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.condpermadmin.ConditionalPermissionAdmin;
import org.osgi.service.condpermadmin.ConditionalPermissionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class SensiNact
implements Core {
    private static final Logger LOG = LoggerFactory.getLogger(SensiNact.class);
    protected static final int LOCAL_ID = 0;
    private final AtomicInteger count = new AtomicInteger(1);
    private final Sessions sessions = new Sessions();
    private AccessTree<? extends AccessNode> anonymousTree;
    public Mediator mediator;
    private RegistryEndpoint registry;
    @Reference
    SecuredAccess securedAccess;
    @Reference
    private ConditionalPermissionAdmin cpa;
    private BundleContext bc;

    private static String getUri(boolean resolved, String namespace, String ... pathElements) {
        if (pathElements == null || pathElements.length == 0) {
            return null;
        }
        String providerId = resolved ? namespace + ":" + pathElements[0] : pathElements[0];
        String[] uriElements = new String[pathElements.length];
        if (pathElements.length > 1) {
            System.arraycopy(pathElements, 1, uriElements, 1, pathElements.length - 1);
        }
        uriElements[0] = providerId;
        return UriUtils.getUri((String[])uriElements);
    }

    private static <T, R extends AccessMethodResponse<T>> R createErrorResponse(Mediator mediator, String type, String uri, int statusCode, String message, Exception e) {
        Object response = AccessMethodResponse.error(mediator, uri, AccessMethod.Type.valueOf(type), statusCode, message, (Throwable)e);
        return response;
    }

    private static <T, R extends DescribeResponse<T>> R createErrorResponse(Mediator mediator, DescribeMethod.DescribeType type, String uri, int statusCode, String message, Exception e) {
        Object response = AccessMethodResponse.error(mediator, uri, type, statusCode, message, (Throwable)e);
        return response;
    }

    private final <R, P> R doPrivilegedService(final Class<P> p, final String f, final Executable<P, R> e) {
        Object r = AccessController.doPrivileged(new PrivilegedAction<R>(){

            @Override
            public R run() {
                return SensiNact.this.mediator.callService(p, f, e);
            }
        });
        return (R)r;
    }

    private final <P> Void doPrivilegedVoidServices(final Class<P> p, final String f, final Executable<P, Void> e) {
        return AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SensiNact.this.mediator.callServices(p, f, e);
                return null;
            }
        });
    }

    private final AccessTree<?> getAnonymousTree() {
        AccessTree<? extends AccessNode> tree = null;
        tree = MutableAccessTree.class.isAssignableFrom(this.anonymousTree.getClass()) ? ((MutableAccessTree)this.anonymousTree).clone() : this.anonymousTree;
        return tree;
    }

    public final AccessTree<?> getUserAccessTree(final String publicKey) {
        AccessTree<Object> tree = null;
        if (publicKey != null && !publicKey.startsWith("anonymous")) {
            tree = this.doPrivilegedService(SecuredAccess.class, null, new Executable<SecuredAccess, AccessTree<? extends AccessNode>>(){

                public AccessTree<? extends AccessNode> execute(SecuredAccess securedAccess) throws Exception {
                    AccessTree<? extends AccessNode> tree = securedAccess.getUserAccessTree(publicKey);
                    return tree;
                }
            });
        }
        if (tree == null) {
            tree = this.getAnonymousTree();
        }
        return tree;
    }

    @Activate
    public void activate(ComponentContext context) throws SecuredAccessException, BundleException, DataStoreException {
        this.bc = context.getBundleContext();
        this.mediator = new Mediator(this.bc);
        List types = ReflectUtils.getAllStringTypes((Bundle)this.bc.getBundle());
        String joinTypes = String.join((CharSequence)"\\,", types);
        ConditionalPermissionUpdate cpu = this.cpa.newConditionalPermissionUpdate();
        List piList = cpu.getConditionalPermissionInfos();
        ConditionalPermissionInfo cpiDeny = this.cpa.newConditionalPermissionInfo(String.format("DENY { [org.eclipse.sensinact.gateway.core.security.perm.StrictCodeBaseCondition \"%s\" \"!\"] (org.osgi.framework.ServicePermission \"org.eclipse.sensinact.gateway.core.Core\" \"register\")(org.osgi.framework.ServicePermission \"org.eclipse.sensinact.gateway.core.SensiNactResourceModel\" \"register,get\")(org.osgi.framework.ServicePermission \"org.eclipse.sensinact.gateway.core.SensiNactResourceModelElement\" \"register,get\")(org.osgi.framework.ServicePermission \"org.eclipse.sensinact.gateway.core.message.LocalAgent\" \"register,get\")(org.osgi.framework.ServicePermission \"org.eclipse.sensinact.gateway.core.message.RemoteAgent\" \"register,get\")(org.osgi.framework.ServicePermission \"org.eclipse.sensinact.gateway.core.remote.RemoteCore\" \"register,get\")(org.osgi.framework.ServicePermission \"org.eclipse.sensinact.gateway.core.security.SecuredAccess\" \"register,get\")(org.osgi.framework.ServicePermission \"org.eclipse.sensinact.gateway.core.security.UserManager\" \"register,get\")(org.osgi.framework.ServicePermission \"org.eclipse.sensinact.gateway.core.security.UserKeyBuilder\" \"register,get\")(org.osgi.framework.ServicePermission \"org.eclipse.sensinact.gateway.core.security.SecurityDataStoreService\" \"register,get\")} null", joinTypes));
        piList.add(cpiDeny);
        ConditionalPermissionInfo cpiAllow = null;
        cpiAllow = this.cpa.newConditionalPermissionInfo("ALLOW {[org.eclipse.sensinact.gateway.core.security.perm.CodeBaseCondition \"*\"](java.security.AllPermission \"\" \"\")} null");
        piList.add(cpiAllow);
        if (!cpu.commit()) {
            throw new ConcurrentModificationException("Permissions changed during update");
        }
        ServiceLoader<UserKeyBuilderFactory> userKeyBuilderFactoryLoader = ServiceLoader.load(UserKeyBuilderFactory.class, this.mediator.getClassLoader());
        for (UserKeyBuilderFactory factory : userKeyBuilderFactoryLoader) {
            if (factory == null) continue;
            factory.newInstance(this.mediator);
        }
        if (this.securedAccess == null) {
            throw new BundleException("A SecuredAccess service was excepted");
        }
        this.anonymousTree = this.securedAccess.getUserAccessTree("anonymous");
        this.registry = new RegistryEndpoint(this.mediator);
        ServiceLoader<SensinactCoreBaseIFaceManagerFactory> loader = ServiceLoader.load(SensinactCoreBaseIFaceManagerFactory.class, this.mediator.getClassLoader());
        for (SensinactCoreBaseIFaceManagerFactory factory : loader) {
            SensinactCoreBaseIFaceManager manager = factory.instance();
            if (manager == null) continue;
            manager.start(this.mediator);
            break;
        }
    }

    @Deactivate
    public void deactivate() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthenticatedSession getSession(final Authentication<?> authentication) throws InvalidKeyException, InvalidCredentialException {
        AuthenticatedSession session = null;
        if (authentication == null) {
            return null;
        }
        if (SessionToken.class.isAssignableFrom(authentication.getClass())) {
            session = this.getSession(((SessionToken)authentication).getAuthenticationMaterial());
        } else {
            UserKey userKey = this.doPrivilegedService(UserKeyBuilder.class, String.format("(identityMaterial=%s)", authentication.getClass().getCanonicalName()), new Executable<UserKeyBuilder, UserKey>(){

                public UserKey execute(UserKeyBuilder service) throws Exception {
                    return service.buildKey(authentication);
                }
            });
            if (userKey == null) {
                throw new InvalidCredentialException("Invalid credentials");
            }
            String pkey = userKey.getPublicKey();
            AccessTree<?> tree = this.getUserAccessTree(pkey);
            SessionKey sessionKey = new SessionKey(this.mediator, 0, this.nextToken(), tree, null);
            sessionKey.setUserKey(userKey);
            session = new SensiNactAuthenticatedSession(sessionKey.getToken());
            Sessions sessions = this.sessions;
            synchronized (sessions) {
                this.sessions.put(sessionKey, session);
            }
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthenticatedSession getSession(String token) {
        AuthenticatedSession session;
        Sessions sessions = this.sessions;
        synchronized (sessions) {
            session = (AuthenticatedSession)this.sessions.getSessionFromToken(token);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session getRemoteSession(String publicKey) {
        String sessionToken;
        int sessionCount = this.count.incrementAndGet();
        Session session = null;
        String filteredKey = publicKey;
        Class sessionClass = null;
        if (publicKey.startsWith("anonymous")) {
            filteredKey = publicKey + "_remote" + sessionCount;
            sessionClass = SensiNactAnonymousSession.class;
        } else {
            sessionClass = SensiNactAuthenticatedSession.class;
        }
        AtomicInteger atomicInteger = this.count;
        synchronized (atomicInteger) {
            sessionToken = this.nextToken();
        }
        AccessTree<?> tree = this.getUserAccessTree(filteredKey);
        SessionKey sessionKey = new SessionKey(this.mediator, sessionCount, sessionToken, tree, null);
        sessionKey.setUserKey(new UserKey(filteredKey));
        try {
            session = (Session)sessionClass.getDeclaredConstructor(SensiNact.class, String.class).newInstance(this, sessionKey.getToken());
            Sessions sessions = this.sessions;
            synchronized (sessions) {
                this.sessions.put(sessionKey, session);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnonymousSession getAnonymousSession() {
        int sessionCount = this.count.incrementAndGet();
        String sessionToken = this.nextToken();
        String pkey = "anonymous" + "_" + sessionCount;
        SessionKey sessionKey = new SessionKey(this.mediator, 0, sessionToken, this.getAnonymousTree(), null);
        sessionKey.setUserKey(new UserKey(pkey));
        SensiNactAnonymousSession session = new SensiNactAnonymousSession(sessionToken);
        Sessions sessions = this.sessions;
        synchronized (sessions) {
            this.sessions.put(sessionKey, session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session getApplicationSession(final Mediator mediator, final String privateKey) {
        final int sessionCount = this.count.incrementAndGet();
        final String sessionToken = this.nextToken();
        SessionKey skey = this.doPrivilegedService(SecuredAccess.class, null, new Executable<SecuredAccess, SessionKey>(){

            public SessionKey execute(SecuredAccess securedAccess) throws Exception {
                String publicKey = securedAccess.getApplicationPublicKey(privateKey);
                AccessTree tree = null;
                if (publicKey == null) {
                    publicKey = "anonymous" + "_" + sessionCount;
                    tree = SensiNact.this.getAnonymousTree();
                } else {
                    tree = securedAccess.getApplicationAccessTree(publicKey);
                }
                SessionKey sessionKey = new SessionKey(mediator, 0, sessionToken, tree, null);
                sessionKey.setUserKey(new UserKey(publicKey));
                return sessionKey;
            }
        });
        SensiNactAuthenticatedSession session = new SensiNactAuthenticatedSession(skey.getToken());
        Sessions sessions = this.sessions;
        synchronized (sessions) {
            this.sessions.put(skey, session);
        }
        return session;
    }

    @Override
    public String namespace() {
        return this.registry.namespace();
    }

    @Override
    public String registerAgent(Mediator mediator, MidAgentCallback callback, SnaFilter filter) {
        String agentKey = this.getAccessKey(mediator);
        final LocalAgent agent = LocalAgentImpl.createAgent(mediator, callback, filter, agentKey);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                agent.start();
                return null;
            }
        });
        return callback.getName();
    }

    private String getAccessKey(Mediator mediator) {
        final Bundle bundle = mediator.getContext().getBundle();
        final String bundleIdentifier = this.doPrivilegedService(BundleValidation.class, null, new Executable<BundleValidation, String>(){

            public String execute(BundleValidation bundleValidation) throws Exception {
                return bundleValidation.check(bundle);
            }
        });
        String publicKey = this.doPrivilegedService(SecuredAccess.class, null, new Executable<SecuredAccess, String>(){

            public String execute(SecuredAccess securedAccess) throws Exception {
                return securedAccess.getAgentPublicKey(bundleIdentifier);
            }
        });
        return publicKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session buildLocalSessionFromPublicKey(String publicKey) {
        SensiNactAuthenticatedSession session = null;
        this.count.incrementAndGet();
        String sessionToken = this.nextToken();
        AccessTree<?> tree = this.getUserAccessTree(publicKey);
        SessionKey sessionKey = new SessionKey(this.mediator, 0, sessionToken, tree, null);
        sessionKey.setUserKey(new UserKey(publicKey));
        try {
            session = new SensiNactAuthenticatedSession(sessionKey.getToken());
            Sessions sessions = this.sessions;
            synchronized (sessions) {
                this.sessions.put(sessionKey, session);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return session;
    }

    @Override
    public String registerIntent(Mediator mediator, Executable<Boolean, Void> onAccessible, String ... path) {
        final Bundle bundle = mediator.getContext().getBundle();
        final String bundleIdentifier = this.doPrivilegedService(BundleValidation.class, null, new Executable<BundleValidation, String>(){

            public String execute(BundleValidation bundleValidation) throws Exception {
                return bundleValidation.check(bundle);
            }
        });
        String intentKey = this.doPrivilegedService(SecuredAccess.class, null, new Executable<SecuredAccess, String>(){

            public String execute(SecuredAccess securedAccess) throws Exception {
                return securedAccess.getAgentPublicKey(bundleIdentifier);
            }
        });
        final ResourceIntent intent = new ResourceIntent(mediator, intentKey, onAccessible, path){

            @Override
            public boolean isAccessible(String path) {
                return SensiNact.this.isAccessible(this.getPublicKey(), path);
            }

            @Override
            public String namespace() {
                return SensiNact.this.namespace();
            }
        };
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                intent.start();
                return null;
            }
        });
        return intent.getName();
    }

    public void unregisterAgent(String identifier) {
        this.doPrivilegedService(SnaAgent.class, String.format("(org.eclipse.sensinact.gateway.agent.id=%s", identifier), new Executable<SnaAgent, Void>(){

            public Void execute(SnaAgent agent) throws Exception {
                agent.stop();
                return null;
            }
        });
    }

    protected Set<ServiceProvider> serviceProviders(String identifier, String filter) {
        SessionKey sessionKey = this.getSessionKeyFromToken(identifier);
        HashSet<ServiceProvider> set = new HashSet<ServiceProvider>();
        set.addAll(this.registry.serviceProviders(sessionKey, filter));
        return set;
    }

    protected ServiceProvider serviceProvider(String identifier, String serviceProviderId) {
        SessionKey sessionKey = this.getSessionKeyFromToken(identifier);
        return this.registry.serviceProvider(sessionKey, serviceProviderId);
    }

    protected Service service(String identifier, String serviceProviderId, String serviceId) {
        SessionKey sessionKey = this.getSessionKeyFromToken(identifier);
        return this.registry.service(sessionKey, serviceProviderId, serviceId);
    }

    protected Resource resource(String identifier, String serviceProviderId, String serviceId, String resourceId) {
        SessionKey sessionKey = this.getSessionKeyFromToken(identifier);
        return this.registry.resource(sessionKey, serviceProviderId, serviceId, resourceId);
    }

    protected boolean isAccessible(SessionKey sessionKey, String path) {
        return this.isAccessible(sessionKey.getPublicKey(), sessionKey.getAccessTree(), path);
    }

    public boolean isAccessible(String publicKey, String path) {
        return this.isAccessible(publicKey, this.getUserAccessTree(publicKey), path);
    }

    protected boolean isAccessible(String publicKey, AccessTree<?> tree, String path) {
        String[] uriElements = UriUtils.getUriElements((String)path);
        String[] providerElements = uriElements[0].split(":");
        String[] uri = new String[uriElements.length];
        if (uriElements.length > 1) {
            System.arraycopy(uriElements, 1, uri, 1, uriElements.length - 1);
        }
        uri[0] = providerElements.length > 1 ? providerElements[1] : providerElements[0];
        return this.registry.isAccessible(tree, UriUtils.getUri((String[])uri));
    }

    private <F> F remoteCoreInvocation(String serviceProviderId, Executable<SensinactCoreBaseIface, F> executable) {
        String[] serviceProviderIdElements = serviceProviderId.split(":");
        String remoteNamespace = serviceProviderIdElements[0];
        Object f = null;
        if (serviceProviderIdElements.length == 1 || remoteNamespace.length() == 0 || remoteNamespace.equals(this.namespace())) {
            return (F)f;
        }
        f = this.mediator.callService(SensinactCoreBaseIface.class, String.format("(%s=%s)", "org.eclipse.sensinact.remote.namespace", remoteNamespace), executable);
        return (F)f;
    }

    private JSONObject act(String identifier, String serviceProviderId, String serviceId, String resourceId, Object[] parameters) {
        SessionKey sessionKey = this.getSessionKeyFromToken(identifier);
        String response = this.remoteCoreInvocation(serviceProviderId, new RemoteAccessMethodExecutable(this.mediator, AccessMethod.Type.valueOf(AccessMethod.ACT), sessionKey.getPublicKey()).withServiceProvider(serviceProviderId).withService(serviceId).withResource(resourceId).with(RemoteAccessMethodExecutable.ARGUMENTS_TK, parameters));
        JSONObject object = new JSONObject(response);
        return object;
    }

    private JSONObject set(SessionKey sessionKey, String serviceProviderId, String serviceId, String resourceId, String attributeId, Object parameter, Object ... args) {
        String response = this.remoteCoreInvocation(serviceProviderId, new RemoteAccessMethodExecutable(this.mediator, AccessMethod.Type.valueOf(AccessMethod.SET), sessionKey.getPublicKey()).withServiceProvider(serviceProviderId).withService(serviceId).withResource(resourceId).withAttribute(attributeId).with(RemoteAccessMethodExecutable.VALUE_TK, parameter));
        JSONObject object = new JSONObject(response);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject get(String identifier, final String serviceProviderId, final String serviceId, final String resourceId, final String attributeId, Object ... args) {
        final SessionKey sessionKey = this.getSessionKeyFromToken(identifier);
        if (serviceProviderId.indexOf(40) < 0) {
            String response = this.remoteCoreInvocation(serviceProviderId, new RemoteAccessMethodExecutable(this.mediator, AccessMethod.Type.valueOf(AccessMethod.GET), sessionKey.getPublicKey()).withServiceProvider(serviceProviderId).withService(serviceId).withResource(resourceId).withAttribute(attributeId));
            JSONObject object = null;
            if (response != null) {
                object = new JSONObject(response);
            }
            return object;
        }
        ArrayList<Future<String>> results = new ArrayList<Future<String>>();
        ExecutorService executor = Executors.newFixedThreadPool(20);
        if (sessionKey.localID() == 0) {
            Collection references = null;
            try {
                references = this.bc.getServiceReferences(SensinactCoreBaseIface.class, String.format("(!(%s=%s))", "org.eclipse.sensinact.remote.namespace", this.namespace()));
            }
            catch (InvalidSyntaxException e) {
                LOG.debug(e.getMessage());
            }
            if (references != null) {
                for (ServiceReference serviceReference : references) {
                    SensinactCoreBaseIface core;
                    if (serviceReference == null || (core = (SensinactCoreBaseIface)this.bc.getService(serviceReference)) == null) continue;
                    results.add(executor.submit(new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            return core.get(sessionKey.getPublicKey(), serviceProviderId, serviceId, resourceId, attributeId);
                        }
                    }));
                }
            }
        }
        Collection<ServiceReference<SensiNactResourceModel>> modelReferences = this.registry.getReferences(sessionKey.getAccessTree(), serviceProviderId);
        try {
            for (ServiceReference serviceReference : modelReferences) {
                SensiNactResourceModel resourceModel;
                if (serviceReference == null || (resourceModel = (SensiNactResourceModel)this.bc.getService(serviceReference)) == null) continue;
                ServiceProvider p = null;
                try {
                    p = (ServiceProvider)((ServiceProviderImpl)resourceModel.getRootElement()).getProxy(sessionKey);
                }
                catch (ModelElementProxyBuildException modelElementProxyBuildException) {
                    continue;
                }
                List list = p.getServices();
                for (Service s : list) {
                    if (s == null || !s.isAccessible() || !this.match(serviceId, s.getName())) continue;
                    List resources = s.getResources();
                    for (Resource r : resources) {
                        if (r == null || !r.isAccessible() || !this.match(resourceId, r.getName())) continue;
                        final Resource resource = r;
                        Resource.Type type = (Resource.Type)resource.getType();
                        if (attributeId == null && Resource.Type.ACTION.equals((Object)type)) continue;
                        results.add(executor.submit(new Callable<String>(){

                            @Override
                            public String call() throws Exception {
                                if (attributeId == null) {
                                    return ((DataResource)resource).get(new Object[0]).getJSON();
                                }
                                return resource.get(attributeId, new Object[0]).getJSON();
                            }
                        }));
                    }
                }
            }
            StringBuilder builder = new StringBuilder();
            String string = String.format("/%s/%s/%s/%s", serviceProviderId, serviceId == null ? "*" : serviceId, resourceId == null ? "*" : resourceId, attributeId == null ? "{default-attribute}" : attributeId);
            builder.append("{\"statusCode\":200,\"response\":{\"name\":\"");
            builder.append(string);
            builder.append("\",\"type\":\"array\",\"value\":[");
            int index = 0;
            for (Future future : results) {
                try {
                    String result = (String)future.get();
                    if (index > 0) {
                        builder.append(",");
                    }
                    builder.append(result);
                    ++index;
                }
                catch (InterruptedException | CancellationException | ExecutionException e) {}
            }
            builder.append("]}}");
            JSONObject jSONObject = new JSONObject(builder.toString());
            return jSONObject;
        }
        finally {
            for (ServiceReference<SensiNactResourceModel> modelReference : modelReferences) {
                if (modelReference == null) continue;
                this.bc.ungetService(modelReference);
            }
        }
    }

    private JSONObject getResource(String identifier, final String serviceProviderId, final String serviceId, final String resourceId) {
        final SessionKey sessionKey = this.getSessionKeyFromToken(identifier);
        final String localNamespace = this.namespace();
        JSONObject object = this.remoteCoreInvocation(serviceProviderId, new Executable<SensinactCoreBaseIface, JSONObject>(){

            public JSONObject execute(SensinactCoreBaseIface core) throws Exception {
                if (core == null || core.namespace().equals(localNamespace)) {
                    return null;
                }
                return new JSONObject(core.getResource(sessionKey.getPublicKey(), serviceProviderId.substring(serviceProviderId.indexOf(58) + 1), serviceId, resourceId));
            }
        });
        return object;
    }

    private String getResources(String identifier, final String serviceProviderId, final String serviceId) {
        final SessionKey sessionKey = this.getSessionKeyFromToken(identifier);
        final String localNamespace = this.namespace();
        String object = this.remoteCoreInvocation(serviceProviderId, new Executable<SensinactCoreBaseIface, String>(){

            public String execute(SensinactCoreBaseIface core) throws Exception {
                if (core == null || core.namespace().equals(localNamespace)) {
                    return null;
                }
                return core.getResources(sessionKey.getPublicKey(), serviceProviderId.substring(serviceProviderId.indexOf(58) + 1), serviceId);
            }
        });
        return object;
    }

    private JSONObject getService(String identifier, final String serviceProviderId, final String serviceId) {
        final SessionKey sessionKey = this.getSessionKeyFromToken(identifier);
        final String localNamespace = this.namespace();
        JSONObject object = this.remoteCoreInvocation(serviceProviderId, new Executable<SensinactCoreBaseIface, JSONObject>(){

            public JSONObject execute(SensinactCoreBaseIface core) throws Exception {
                if (core == null || core.namespace().equals(localNamespace)) {
                    return null;
                }
                return new JSONObject(core.getService(sessionKey.getPublicKey(), serviceProviderId.substring(serviceProviderId.indexOf(58) + 1), serviceId));
            }
        });
        return object;
    }

    private String getServices(String identifier, final String serviceProviderId) {
        final SessionKey sessionKey = this.getSessionKeyFromToken(identifier);
        final String localNamespace = this.namespace();
        String object = this.remoteCoreInvocation(serviceProviderId, new Executable<SensinactCoreBaseIface, String>(){

            public String execute(SensinactCoreBaseIface core) throws Exception {
                if (core == null || core.namespace().equals(localNamespace)) {
                    return null;
                }
                return core.getServices(sessionKey.getPublicKey(), serviceProviderId.substring(serviceProviderId.indexOf(58) + 1));
            }
        });
        return object;
    }

    private JSONObject getProvider(String identifier, final String serviceProviderId) {
        final SessionKey sessionKey = this.getSessionKeyFromToken(identifier);
        final String localNamespace = this.namespace();
        JSONObject object = this.remoteCoreInvocation(serviceProviderId, new Executable<SensinactCoreBaseIface, JSONObject>(){

            public JSONObject execute(SensinactCoreBaseIface core) throws Exception {
                if (core == null || core.namespace().equals(localNamespace)) {
                    return null;
                }
                return new JSONObject(core.getProvider(sessionKey.getPublicKey(), serviceProviderId.substring(serviceProviderId.indexOf(58) + 1)));
            }
        });
        return object;
    }

    private String getProviders(String identifier, final String filter) {
        final SessionKey sessionKey = this.getSessionKeyFromToken(identifier);
        String effectiveFilter = null;
        if (filter != null && filter.length() > 0) {
            try {
                this.bc.createFilter(filter);
                effectiveFilter = filter;
            }
            catch (InvalidSyntaxException e) {
                effectiveFilter = null;
            }
        }
        String local = this.registry.getProviders(sessionKey, sessionKey.localID() != 0, effectiveFilter);
        if (sessionKey.localID() != 0) {
            return local;
        }
        final StringBuilder content = new StringBuilder();
        if (local != null && local.length() > 0) {
            content.append(local);
        }
        final String localNamespace = this.namespace();
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SensiNact.this.mediator.callServices(SensinactCoreBaseIface.class, null, (Executable)new Executable<SensinactCoreBaseIface, Void>(){

                    public Void execute(SensinactCoreBaseIface core) throws Exception {
                        if (core == null || core.namespace().equals(localNamespace)) {
                            return null;
                        }
                        String o = core.getProviders(sessionKey.getPublicKey(), filter);
                        if (o != null && o.length() > 0) {
                            if (content.length() > 0) {
                                content.append(",");
                            }
                            content.append(o);
                        }
                        return null;
                    }
                });
                return null;
            }
        });
        return content.toString();
    }

    private String getProvider(String identifier, String providerId, String filter) {
        SessionKey sessionKey = this.getSessionKeyFromToken(identifier);
        String effectiveFilter = null;
        if (filter != null && filter.length() > 0) {
            try {
                this.bc.createFilter(filter);
                effectiveFilter = filter;
            }
            catch (InvalidSyntaxException e) {
                effectiveFilter = null;
            }
        }
        String provider = this.registry.getProvider(sessionKey, sessionKey.localID() != 0, providerId, effectiveFilter);
        return provider;
    }

    protected String getAll(String identifier, final String filter) {
        final SessionKey sessionKey = this.getSessionKeyFromToken(identifier);
        String effectiveFilter = null;
        if (filter != null && filter.length() > 0) {
            try {
                this.bc.createFilter(filter);
                effectiveFilter = filter;
            }
            catch (InvalidSyntaxException e) {
                effectiveFilter = null;
            }
        }
        String local = this.registry.getAll(sessionKey, sessionKey.localID() != 0, effectiveFilter);
        if (sessionKey.localID() != 0) {
            return local;
        }
        final StringBuilder content = new StringBuilder();
        if (local != null && local.length() > 0) {
            content.append(local);
        }
        final String localNamespace = this.namespace();
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SensiNact.this.mediator.callServices(SensinactCoreBaseIface.class, null, (Executable)new Executable<SensinactCoreBaseIface, Void>(){

                    public Void execute(SensinactCoreBaseIface core) throws Exception {
                        if (core == null || core.namespace().equals(localNamespace)) {
                            return null;
                        }
                        String o = core.getAll(sessionKey.getPublicKey(), filter);
                        if (o != null && o.length() > 0) {
                            if (content.length() > 0) {
                                content.append(",");
                            }
                            content.append(o);
                        }
                        return null;
                    }
                });
                return null;
            }
        });
        return content.toString();
    }

    @Override
    public void close() {
        LOG.debug("closing sensiNact core");
        this.mediator.callService(SensinactCoreBaseIFaceManager.class, (Executable)new Executable<SensinactCoreBaseIFaceManager, Void>(){

            public Void execute(SensinactCoreBaseIFaceManager sensinactCoreBaseIFaceManager) throws Exception {
                sensinactCoreBaseIFaceManager.stop();
                return null;
            }
        });
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SensiNact.this.mediator.callServices(SensiNactResourceModel.class, (Executable)new Executable<SensiNactResourceModel, Void>(){

                    public Void execute(SensiNactResourceModel instance) throws Exception {
                        instance.unregister();
                        return null;
                    }
                });
                SensiNact.this.mediator.callServices(SnaAgent.class, (Executable)new Executable<SnaAgent, Void>(){

                    public Void execute(SnaAgent agent) throws Exception {
                        agent.stop();
                        return null;
                    }
                });
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SessionKey getSessionKeyFromToken(String sessionId) {
        SessionKey sessionKey;
        Sessions sessions = this.sessions;
        synchronized (sessions) {
            sessionKey = this.sessions.get(new Sessions.KeyExtractor<Sessions.KeyExtractorType>(Sessions.KeyExtractorType.TOKEN, sessionId));
        }
        if (sessionKey == null) {
            throw new IllegalArgumentException("Invalid session token");
        }
        return sessionKey;
    }

    private boolean match(String expected, String found) {
        if (expected == null) {
            return true;
        }
        if (found == null) {
            return false;
        }
        if (found.equals(expected)) {
            return true;
        }
        if (!expected.startsWith("(") || !expected.endsWith(")")) {
            return false;
        }
        String pattern = expected.substring(1, expected.length() - 1);
        boolean match = true;
        if (pattern.startsWith("*")) {
            int pos = found.length() - 1;
            for (int i = pattern.length() - 1; i > 0; --i) {
                if (pattern.charAt(i) != found.charAt(pos)) {
                    match = false;
                    break;
                }
                --pos;
            }
        } else if (pattern.endsWith("*")) {
            int pos = 0;
            for (int i = 0; i < pattern.length() - 1; ++i) {
                if (pattern.charAt(i) != found.charAt(pos)) {
                    match = false;
                    break;
                }
                ++pos;
            }
        } else {
            try {
                Pattern _pattern = Pattern.compile(pattern);
                match = _pattern.matcher(found).matches();
            }
            catch (Exception e) {
                match = false;
            }
        }
        return match;
    }

    private String nextToken() {
        boolean exists = false;
        String token = null;
        do {
            try {
                token = CryptoUtils.createToken();
            }
            catch (InvalidKeyException e) {
                token = Long.toHexString(System.currentTimeMillis());
            }
        } while (exists = this.sessions.get(new Sessions.KeyExtractor<Sessions.KeyExtractorType>(Sessions.KeyExtractorType.TOKEN, token)) != null);
        return token;
    }

    final class SensiNactAuthenticatedSession
    extends SensiNactSession
    implements AuthenticatedSession {
        SensiNactAuthenticatedSession(String identifier) {
            super(identifier);
        }

        @Override
        public final void changePassword(final String oldPassword, final String newPassword) throws SecuredAccessException {
            SessionKey sessionKey = SensiNact.this.getSessionKeyFromToken(this.getSessionId());
            final String publicKey = sessionKey.getPublicKey();
            SecuredAccessException exception = (SecuredAccessException)SensiNact.this.mediator.callService(UserManager.class, (Executable)new Executable<UserManager, SecuredAccessException>(){

                public SecuredAccessException execute(UserManager userManager) throws Exception {
                    User user = userManager.getUserFromPublicKey(publicKey);
                    try {
                        String encryptedPassword = CryptoUtils.cryptWithMD5((String)oldPassword);
                        userManager.updateField(user, "password", encryptedPassword, newPassword);
                    }
                    catch (SecuredAccessException e) {
                        return e;
                    }
                    catch (Exception e) {
                        return new SecuredAccessException(e);
                    }
                    return null;
                }
            });
        }
    }

    final class SensiNactAnonymousSession
    extends SensiNactSession
    implements AnonymousSession {
        SensiNactAnonymousSession(String identifier) {
            super(identifier);
        }

        @Override
        public final void registerUser(final String login, final String password, final String account, final String accountType) throws SecuredAccessException {
            SecuredAccessException exception = (SecuredAccessException)SensiNact.this.mediator.callService(UserManager.class, (Executable)new Executable<UserManager, SecuredAccessException>(){

                public SecuredAccessException execute(UserManager userManager) throws Exception {
                    try {
                        if (userManager.accountExists(account) || userManager.loginExists(login)) {
                            throw new SecuredAccessException("A user with this login or account already exists");
                        }
                        String token = SensiNact.this.nextToken();
                        UserUpdater userUpdater = userManager.createUser(token, login, password, account, accountType);
                        ServiceReference[] references = SensiNact.this.bc.getServiceReferences(AccountConnector.class.getName(), "(org.eclipse.sensinact.security.account.type=" + accountType + ")");
                        if (references == null || references.length == 0) {
                            throw new SecuredAccessException("No account connector");
                        }
                        for (int index = 0; index < references.length; ++index) {
                            AccountConnector connector = (AccountConnector)SensiNact.this.bc.getService(references[index]);
                            if (connector == null) continue;
                            connector.connect(token, userUpdater);
                            SensiNact.this.bc.ungetService(references[index]);
                            break;
                        }
                    }
                    catch (SecuredAccessException e) {
                        return e;
                    }
                    catch (Exception e) {
                        return new SecuredAccessException(e);
                    }
                    return null;
                }
            });
            if (exception != null) {
                throw exception;
            }
        }

        @Override
        public final void renewPassword(final String account) throws SecuredAccessException {
            SecuredAccessException exception = (SecuredAccessException)SensiNact.this.mediator.callService(UserManager.class, (Executable)new Executable<UserManager, SecuredAccessException>(){

                public SecuredAccessException execute(UserManager userManager) throws Exception {
                    User user = userManager.getUserFromAccount(account);
                    if (user == null) {
                        return new SecuredAccessException("No user found for this account");
                    }
                    try {
                        String token = SensiNact.this.nextToken();
                        UserUpdater userUpdater = userManager.renewUserPassword(token, account, user.getAccountType());
                        ServiceReference[] references = SensiNact.this.bc.getServiceReferences(AccountConnector.class.getName(), "(org.eclipse.sensinact.security.account.type=" + user.getAccountType() + ")");
                        if (references == null || references.length == 0) {
                            return new SecuredAccessException("No account connector");
                        }
                        for (int index = 0; index < references.length; ++index) {
                            AccountConnector connector = (AccountConnector)SensiNact.this.bc.getService(references[index]);
                            if (connector == null) continue;
                            connector.connect(token, userUpdater);
                            SensiNact.this.bc.ungetService(references[index]);
                            break;
                        }
                    }
                    catch (SecuredAccessException e) {
                        return e;
                    }
                    catch (Exception e) {
                        return new SecuredAccessException(e);
                    }
                    return null;
                }
            });
            if (exception != null) {
                throw exception;
            }
        }
    }

    public abstract class SensiNactSession
    extends AbstractSession {
        public SensiNactSession(String identifier) {
            super(identifier);
        }

        @Override
        public Set<ServiceProvider> serviceProviders(final String filter) {
            return AccessController.doPrivileged(new PrivilegedAction<Set<ServiceProvider>>(){

                @Override
                public Set<ServiceProvider> run() {
                    return SensiNact.this.serviceProviders(SensiNactSession.this.getSessionId(), filter);
                }
            });
        }

        @Override
        public ServiceProvider serviceProvider(final String serviceProviderName) {
            ServiceProvider provider = AccessController.doPrivileged(new PrivilegedAction<ServiceProvider>(){

                @Override
                public ServiceProvider run() {
                    return SensiNact.this.serviceProvider(SensiNactSession.this.getSessionId(), serviceProviderName);
                }
            });
            return provider;
        }

        @Override
        public SubscribeResponse registerSessionAgent(String requestId, final MidAgentCallback callback, final SnaFilter filter) {
            final SessionKey sessionKey = SensiNact.this.getSessionKeyFromToken(this.getSessionId());
            boolean registered = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return sessionKey.registerAgent(callback, filter);
                }
            });
            String uri = null;
            uri = filter != null ? filter.getSender() : "/";
            SubscribeResponse response = null;
            if (registered) {
                response = new SubscribeResponse(uri, AccessMethodResponse.Status.SUCCESS, 200);
                response.setResponse(new JSONObject().put("subscriptionId", (Object)callback.getName()));
            } else {
                response = (SubscribeResponse)SensiNact.createErrorResponse(SensiNact.this.mediator, AccessMethod.SUBSCRIBE, uri, 520, "Unable to subscribe", null);
            }
            return this.tatooRequestId(requestId, response);
        }

        @Override
        public UnsubscribeResponse unregisterSessionAgent(String requestId, final String agentId) {
            final SessionKey sessionKey = SensiNact.this.getSessionKeyFromToken(this.getSessionId());
            boolean unregistered = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    if (sessionKey != null && sessionKey.getPublicKey() != null) {
                        return sessionKey.unregisterAgent(agentId);
                    }
                    return false;
                }
            });
            UnsubscribeResponse response = null;
            if (unregistered) {
                response = new UnsubscribeResponse("/", AccessMethodResponse.Status.SUCCESS, 200);
                response.setResponse(new JSONObject().put("message", (Object)"The agent has been properly unregistered"));
            } else {
                response = (UnsubscribeResponse)SensiNact.createErrorResponse(SensiNact.this.mediator, AccessMethod.UNSUBSCRIBE, "/", 520, "Unable to unsubscribe", null);
            }
            return this.tatooRequestId(requestId, response);
        }

        @Override
        public SubscribeResponse registerSessionIntent(String requestId, Executable<Boolean, Void> callback, String ... resourcePath) {
            final SessionKey sessionKey = SensiNact.this.getSessionKeyFromToken(this.getSessionId());
            final ResourceIntent intent = new ResourceIntent(SensiNact.this.mediator, sessionKey.getPublicKey(), callback, resourcePath){

                @Override
                public boolean isAccessible(String path) {
                    return SensiNactSession.this.isAccessible(path);
                }

                @Override
                public String namespace() {
                    return SensiNact.this.namespace();
                }
            };
            boolean registered = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return sessionKey.registerAgent(intent.getName(), intent);
                }
            });
            SubscribeResponse response = null;
            if (registered) {
                response = new SubscribeResponse(intent.getCommonPath(), AccessMethodResponse.Status.SUCCESS, 200);
                response.setResponse(new JSONObject().put("subscriptionId", (Object)intent.getName()));
            } else {
                response = (SubscribeResponse)SensiNact.createErrorResponse(SensiNact.this.mediator, AccessMethod.SUBSCRIBE, intent.getCommonPath(), 520, "Unable to subscribe", null);
            }
            return this.tatooRequestId(requestId, response);
        }

        @Override
        public UnsubscribeResponse unregisterSessionIntent(String requestId, final String intentId) {
            final SessionKey sessionKey = SensiNact.this.getSessionKeyFromToken(this.getSessionId());
            boolean unregistered = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    if (sessionKey != null && sessionKey.getPublicKey() != null) {
                        return sessionKey.unregisterAgent(intentId);
                    }
                    return false;
                }
            });
            UnsubscribeResponse response = null;
            if (unregistered) {
                response = new UnsubscribeResponse("/", AccessMethodResponse.Status.SUCCESS, 200);
                response.setResponse(new JSONObject().put("message", (Object)"The intent has been properly unregistered"));
            } else {
                response = (UnsubscribeResponse)SensiNact.createErrorResponse(SensiNact.this.mediator, AccessMethod.UNSUBSCRIBE, "/", 520, "Unable to unsubscribe", null);
            }
            return this.tatooRequestId(requestId, response);
        }

        @Override
        public GetResponse get(String requestId, final String serviceProviderId, final String serviceId, final String resourceId, final String attributeId, final Object ... args) {
            final SessionKey sessionKey = SensiNact.this.getSessionKeyFromToken(this.getSessionId());
            String uri = SensiNact.getUri(sessionKey.localID() != 0, SensiNact.this.namespace(), new String[]{serviceProviderId, serviceId, resourceId});
            Resource resource = this.resource(serviceProviderId, serviceId, resourceId);
            GetResponse response = null;
            if (resource != null) {
                response = attributeId == null ? (!((Resource.Type)resource.getType()).equals((Object)Resource.Type.ACTION) ? ((DataResource)resource).get(args) : (GetResponse)SensiNact.createErrorResponse(SensiNact.this.mediator, AccessMethod.GET, uri, 404, "Unknown Method", null)) : resource.get(attributeId, args);
                return this.tatooRequestId(requestId, response);
            }
            if (serviceProviderId.indexOf(40) < 0 && sessionKey.localID() != 0) {
                response = (GetResponse)SensiNact.createErrorResponse(SensiNact.this.mediator, AccessMethod.GET, uri, 404, "Resource not found", null);
                return this.tatooRequestId(requestId, response);
            }
            JSONObject object = AccessController.doPrivileged(new PrivilegedAction<JSONObject>(){

                @Override
                public JSONObject run() {
                    return SensiNact.this.get(sessionKey.getToken(), serviceProviderId, serviceId, resourceId, attributeId, args);
                }
            });
            try {
                response = (GetResponse)this.responseFromJSONObject(SensiNact.this.mediator, uri, AccessMethod.GET, object);
            }
            catch (Exception e) {
                response = (GetResponse)SensiNact.createErrorResponse(SensiNact.this.mediator, AccessMethod.GET, uri, 500, "Internal server error", e);
            }
            return this.tatooRequestId(requestId, response);
        }

        @Override
        public SetResponse set(String requestId, final String serviceProviderId, final String serviceId, final String resourceId, final String attributeId, final Object parameter, final Object ... args) {
            final SessionKey sessionKey = SensiNact.this.getSessionKeyFromToken(this.getSessionId());
            String uri = SensiNact.getUri(sessionKey.localID() != 0, SensiNact.this.namespace(), new String[]{serviceProviderId, serviceId, resourceId});
            Resource resource = this.resource(serviceProviderId, serviceId, resourceId);
            SetResponse response = null;
            if (resource != null) {
                response = attributeId == null ? (!((Resource.Type)resource.getType()).equals((Object)Resource.Type.ACTION) ? ((DataResource)resource).set(parameter, args) : (SetResponse)SensiNact.createErrorResponse(SensiNact.this.mediator, AccessMethod.SET, uri, 404, "Unknown Method", null)) : resource.set(attributeId, parameter, args);
                return this.tatooRequestId(requestId, response);
            }
            if (sessionKey.localID() != 0) {
                response = (SetResponse)SensiNact.createErrorResponse(SensiNact.this.mediator, AccessMethod.SET, uri, 404, "Resource not found", null);
                return this.tatooRequestId(requestId, response);
            }
            JSONObject object = AccessController.doPrivileged(new PrivilegedAction<JSONObject>(){

                @Override
                public JSONObject run() {
                    return SensiNact.this.set(sessionKey, serviceProviderId, serviceId, resourceId, attributeId, parameter, args);
                }
            });
            try {
                response = (SetResponse)this.responseFromJSONObject(SensiNact.this.mediator, uri, AccessMethod.SET, object);
            }
            catch (Exception e) {
                response = (SetResponse)SensiNact.createErrorResponse(SensiNact.this.mediator, AccessMethod.SET, uri, 500, "Internal server error", e);
            }
            return this.tatooRequestId(requestId, response);
        }

        @Override
        public ActResponse act(String requestId, final String serviceProviderId, final String serviceId, final String resourceId, final Object[] parameters) {
            final SessionKey sessionKey = SensiNact.this.getSessionKeyFromToken(this.getSessionId());
            ActResponse response = null;
            String uri = SensiNact.getUri(sessionKey.localID() != 0, SensiNact.this.namespace(), new String[]{serviceProviderId, serviceId, resourceId});
            Resource resource = this.resource(serviceProviderId, serviceId, resourceId);
            if (resource != null) {
                response = !((Resource.Type)resource.getType()).equals((Object)Resource.Type.ACTION) ? (ActResponse)SensiNact.createErrorResponse(SensiNact.this.mediator, AccessMethod.ACT, uri, 404, "Unknown Method", null) : (parameters != null && parameters.length > 0 ? ((ActionResource)resource).act(parameters) : ((ActionResource)resource).act(new Object[0]));
                return this.tatooRequestId(requestId, response);
            }
            if (sessionKey.localID() != 0) {
                response = (ActResponse)SensiNact.createErrorResponse(SensiNact.this.mediator, AccessMethod.ACT, uri, 404, "Resource not found", null);
                return this.tatooRequestId(requestId, response);
            }
            JSONObject object = AccessController.doPrivileged(new PrivilegedAction<JSONObject>(){

                @Override
                public JSONObject run() {
                    return SensiNact.this.act(sessionKey.getPublicKey(), serviceProviderId, serviceId, resourceId, parameters);
                }
            });
            try {
                response = (ActResponse)this.responseFromJSONObject(SensiNact.this.mediator, uri, AccessMethod.ACT, object);
            }
            catch (Exception e) {
                response = (ActResponse)SensiNact.createErrorResponse(SensiNact.this.mediator, AccessMethod.ACT, uri, 500, "Internal server error", e);
            }
            return this.tatooRequestId(requestId, response);
        }

        @Override
        public SubscribeResponse subscribe(final String requestId, final String serviceProviderId, final String serviceId, final String resourceId, final Recipient recipient, JSONArray conditions, String policy, Object ... args) {
            boolean accessible;
            final SessionKey sessionKey = SensiNact.this.getSessionKeyFromToken(this.getSessionId());
            SubscribeResponse response = null;
            String uri = SensiNact.getUri(sessionKey.localID() != 0, SensiNact.this.namespace(), new String[]{serviceProviderId, serviceId, resourceId});
            Resource resource = this.resource(serviceProviderId, serviceId, resourceId);
            if (resource != null) {
                if (!((Resource.Type)resource.getType()).equals((Object)Resource.Type.ACTION)) {
                    Constraint constraint = null;
                    if (conditions != null && conditions.length() > 0) {
                        try {
                            constraint = ConstraintFactory.Loader.load((ClassLoader)SensiNact.this.mediator.getClassLoader(), (JSONArray)conditions);
                        }
                        catch (InvalidConstraintDefinitionException e) {
                            LOG.error(e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                    response = ((DataResource)resource).subscribe(recipient, constraint == null ? Collections.emptySet() : Collections.singleton(constraint), policy, args);
                } else {
                    response = (SubscribeResponse)SensiNact.createErrorResponse(SensiNact.this.mediator, AccessMethod.SUBSCRIBE, uri, 404, "Unknown Method", null);
                }
                return this.tatooRequestId(requestId, response);
            }
            Boolean acc = (Boolean)SensiNact.this.remoteCoreInvocation(uri, (Executable)new Executable<SensinactCoreBaseIface, Boolean>(){

                public Boolean execute(SensinactCoreBaseIface core) throws Exception {
                    return core.isAccessible(sessionKey.getPublicKey(), serviceProviderId, serviceId, resourceId);
                }
            });
            boolean bl = accessible = acc == null ? false : acc;
            if (sessionKey.localID() != 0 || !accessible) {
                response = (SubscribeResponse)SensiNact.createErrorResponse(SensiNact.this.mediator, AccessMethod.SUBSCRIBE, uri, 404, "Resource not found", null);
                return this.tatooRequestId(requestId, response);
            }
            final String uriRemote = String.format("/%s/%s/%s", serviceProviderId, serviceId, resourceId);
            response = new SubscribeResponse(uriRemote, AccessMethodResponse.Status.SUCCESS);
            response.setResponse(new JSONObject().put("subscriptionId", (Object)recipient.toString()));
            AbstractMidAgentCallback cb = new AbstractMidAgentCallback(true, true, recipient.toString()){

                @Override
                public void doHandle(SnaUpdateMessageImpl message) throws MidCallbackException {
                    JSONObject oj = new JSONObject(message.getJSON());
                    if (oj.getString("uri").startsWith(uriRemote)) {
                        LOG.info("remote: Subscription response {}", (Object)oj.toString());
                        try {
                            recipient.callback(requestId, new SnaMessage[]{message});
                        }
                        catch (Exception e) {
                            throw new MidCallbackException(e);
                        }
                    }
                }
            };
            SnaFilter filter = new SnaFilter(SensiNact.this.mediator, uriRemote.concat("/value"), true, false);
            filter.addHandledType(SnaMessage.Type.UPDATE);
            Constraint constraint = null;
            if (conditions != null && conditions.length() > 0) {
                try {
                    constraint = ConstraintFactory.Loader.load((ClassLoader)SensiNact.this.mediator.getClassLoader(), (JSONArray)conditions);
                }
                catch (InvalidConstraintDefinitionException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
            filter.addCondition(constraint);
            SensiNact.this.registerAgent(SensiNact.this.mediator, cb, filter);
            return this.tatooRequestId(requestId, response);
        }

        @Override
        public UnsubscribeResponse unsubscribe(String requestId, final String serviceProviderId, final String serviceId, final String resourceId, String subscriptionId, Object ... args) {
            boolean accessible;
            final SessionKey sessionKey = SensiNact.this.getSessionKeyFromToken(this.getSessionId());
            UnsubscribeResponse response = null;
            String uri = SensiNact.getUri(sessionKey.localID() != 0, SensiNact.this.namespace(), new String[]{serviceProviderId, serviceId, resourceId});
            Resource resource = this.resource(serviceProviderId, serviceId, resourceId);
            if (resource != null) {
                response = !((Resource.Type)resource.getType()).equals((Object)Resource.Type.ACTION) ? ((DataResource)resource).unsubscribe(subscriptionId, args) : (UnsubscribeResponse)SensiNact.createErrorResponse(SensiNact.this.mediator, AccessMethod.UNSUBSCRIBE, uri, 404, "Unknown Method", null);
                return this.tatooRequestId(requestId, response);
            }
            Boolean acc = (Boolean)SensiNact.this.remoteCoreInvocation(uri, (Executable)new Executable<SensinactCoreBaseIface, Boolean>(){

                public Boolean execute(SensinactCoreBaseIface core) throws Exception {
                    return core.isAccessible(sessionKey.getPublicKey(), serviceProviderId, serviceId, resourceId);
                }
            });
            boolean bl = accessible = acc == null ? false : acc;
            if (sessionKey.localID() != 0 || !accessible) {
                response = (UnsubscribeResponse)SensiNact.createErrorResponse(SensiNact.this.mediator, AccessMethod.UNSUBSCRIBE, uri, 404, "Resource not found", null);
                return this.tatooRequestId(requestId, response);
            }
            String uriRemote = String.format("/%s/%s/%s", serviceProviderId, serviceId, resourceId);
            response = new UnsubscribeResponse(uriRemote, AccessMethodResponse.Status.SUCCESS, 200);
            response.setResponse(new JSONObject().put("message", (Object)"unsubscription done"));
            SensiNact.this.mediator.callService(SnaAgent.class, "(org.eclipse.sensinact.gateway.agent.id=" + subscriptionId + ")", (Executable)new Executable<SnaAgent, Void>(){

                public Void execute(SnaAgent agent) throws Exception {
                    agent.stop();
                    return null;
                }
            });
            return this.tatooRequestId(requestId, response);
        }

        @Override
        public DescribeResponse<String> getAll(String requestId, String filter, FilteringCollection filterCollection) {
            SessionKey sessionKey = SensiNact.this.getSessionKeyFromToken(this.getSessionId());
            DescribeResponse response = null;
            DescribeMethod method = new DescribeMethod(SensiNact.this.mediator, "/", null, DescribeMethod.DescribeType.COMPLETE_LIST);
            AccessMethodResponseBuilder builder = method.createAccessMethodResponseBuilder(null);
            final String ldapFilter = filterCollection != null ? filterCollection.composeLDAPFormatedFilter(filter) : filter;
            String all = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return SensiNact.this.getAll(SensiNactSession.this.getSessionId(), ldapFilter);
                }
            });
            if (all == null) {
                response = SensiNact.createErrorResponse(SensiNact.this.mediator, DescribeMethod.DescribeType.COMPLETE_LIST, "/", 500, "Internal server error", null);
                return this.tatooRequestId(requestId, response);
            }
            if (sessionKey.localID() != 0) {
                builder.setAccessMethodObjectResult(all);
                response = (DescribeResponse)builder.createAccessMethodResponse(AccessMethodResponse.Status.SUCCESS);
                return this.tatooRequestId(requestId, response);
            }
            String result = "[" + all + "]";
            if (filterCollection != null) {
                result = filterCollection.apply(result);
            }
            builder.setAccessMethodObjectResult(result);
            response = (DescribeResponse)builder.createAccessMethodResponse(AccessMethodResponse.Status.SUCCESS);
            if (filterCollection != null) {
                response.put("filters", new JSONArray(filterCollection.filterJsonDefinition()), filterCollection.hideFilter());
            }
            return this.tatooRequestId(requestId, response);
        }

        @Override
        public DescribeResponse<String> getProviders(String requestId, FilteringCollection filterCollection) {
            SessionKey sessionKey = SensiNact.this.getSessionKeyFromToken(this.getSessionId());
            DescribeResponse response = null;
            DescribeMethod method = new DescribeMethod(SensiNact.this.mediator, "/", null, DescribeMethod.DescribeType.PROVIDERS_LIST);
            AccessMethodResponseBuilder builder = method.createAccessMethodResponseBuilder(null);
            final String ldapFilter = filterCollection != null ? filterCollection.composeLDAPFormatedFilter(null) : null;
            String providers = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return SensiNact.this.getProviders(SensiNactSession.this.getSessionId(), ldapFilter);
                }
            });
            if (providers == null) {
                response = SensiNact.createErrorResponse(SensiNact.this.mediator, DescribeMethod.DescribeType.PROVIDERS_LIST, "/", 404, "Internal server error", null);
                return this.tatooRequestId(requestId, response);
            }
            if (sessionKey.localID() != 0) {
                builder.setAccessMethodObjectResult(providers);
                response = (DescribeResponse)builder.createAccessMethodResponse(AccessMethodResponse.Status.SUCCESS);
                return this.tatooRequestId(requestId, response);
            }
            String result = "[" + providers + "]";
            if (filterCollection != null) {
                result = filterCollection.apply(result);
            }
            builder.setAccessMethodObjectResult(result);
            response = (DescribeResponse)builder.createAccessMethodResponse(AccessMethodResponse.Status.SUCCESS);
            if (filterCollection != null) {
                response.put("filters", new JSONArray(filterCollection.filterJsonDefinition()), filterCollection.hideFilter());
            }
            return this.tatooRequestId(requestId, response);
        }

        @Override
        public DescribeResponse<JSONObject> getProvider(String requestId, final String serviceProviderId) {
            SessionKey sessionKey = SensiNact.this.getSessionKeyFromToken(this.getSessionId());
            String uri = SensiNact.getUri(sessionKey.localID() != 0, SensiNact.this.namespace(), new String[]{serviceProviderId});
            DescribeResponse<JSONObject> response = null;
            DescribeMethod method = new DescribeMethod(SensiNact.this.mediator, uri, null, DescribeMethod.DescribeType.PROVIDER);
            AccessMethodResponseBuilder builder = method.createAccessMethodResponseBuilder(null);
            ServiceProvider provider = this.serviceProvider(serviceProviderId);
            if (provider != null) {
                builder.setAccessMethodObjectResult(new JSONObject(provider.getDescription().getJSON()));
                return (DescribeResponse)this.tatooRequestId(requestId, builder.createAccessMethodResponse());
            }
            if (sessionKey.localID() != 0) {
                response = SensiNact.createErrorResponse(SensiNact.this.mediator, DescribeMethod.DescribeType.PROVIDER, uri, 404, "Service provider not found", null);
                return this.tatooRequestId(requestId, response);
            }
            JSONObject object = AccessController.doPrivileged(new PrivilegedAction<JSONObject>(){

                @Override
                public JSONObject run() {
                    return SensiNact.this.getProvider(SensiNactSession.this.getSessionId(), serviceProviderId);
                }
            });
            response = this.describeFromJSONObject(SensiNact.this.mediator, (DescribeResponseBuilder<JSONObject>)builder, DescribeMethod.DescribeType.PROVIDER, object);
            return this.tatooRequestId(requestId, response);
        }

        @Override
        public DescribeResponse<String> getServices(String requestId, final String serviceProviderId, FilteringCollection filterCollection) {
            SessionKey sessionKey = SensiNact.this.getSessionKeyFromToken(this.getSessionId());
            String uri = SensiNact.getUri(sessionKey.localID() != 0, SensiNact.this.namespace(), new String[]{serviceProviderId});
            DescribeResponse response = null;
            DescribeMethod method = new DescribeMethod(SensiNact.this.mediator, uri, null, DescribeMethod.DescribeType.SERVICES_LIST);
            AccessMethodResponseBuilder builder = method.createAccessMethodResponseBuilder(null);
            ServiceProvider provider = this.serviceProvider(serviceProviderId);
            String services = null;
            if (provider == null) {
                if (sessionKey.localID() != 0) {
                    response = SensiNact.createErrorResponse(SensiNact.this.mediator, DescribeMethod.DescribeType.SERVICES_LIST, uri, 404, "Service provider not found", null);
                    return this.tatooRequestId(requestId, response);
                }
                services = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return SensiNact.this.getServices(SensiNactSession.this.getSessionId(), serviceProviderId);
                    }
                });
            } else {
                services = this.joinElementNames(provider);
            }
            if (services == null) {
                response = SensiNact.createErrorResponse(SensiNact.this.mediator, DescribeMethod.DescribeType.SERVICES_LIST, uri, 404, "Service provider not found", null);
                return this.tatooRequestId(requestId, response);
            }
            if (sessionKey.localID() != 0) {
                builder.setAccessMethodObjectResult(services);
                response = (DescribeResponse)builder.createAccessMethodResponse(AccessMethodResponse.Status.SUCCESS);
                return this.tatooRequestId(requestId, response);
            }
            String result = "[" + services + "]";
            if (filterCollection != null) {
                result = filterCollection.apply(result);
            }
            builder.setAccessMethodObjectResult(result);
            response = (DescribeResponse)builder.createAccessMethodResponse(AccessMethodResponse.Status.SUCCESS);
            if (filterCollection != null) {
                response.put("filters", new JSONArray(filterCollection.filterJsonDefinition()), filterCollection.hideFilter());
            }
            return this.tatooRequestId(requestId, response);
        }

        @Override
        public DescribeResponse<JSONObject> getService(String requestId, final String serviceProviderId, final String serviceId) {
            SessionKey sessionKey = SensiNact.this.getSessionKeyFromToken(this.getSessionId());
            String uri = SensiNact.getUri(sessionKey.localID() != 0, SensiNact.this.namespace(), new String[]{serviceProviderId, serviceId});
            DescribeResponse response = null;
            DescribeMethod method = new DescribeMethod(SensiNact.this.mediator, uri, null, DescribeMethod.DescribeType.SERVICE);
            AccessMethodResponseBuilder builder = method.createAccessMethodResponseBuilder(null);
            Service service = this.service(serviceProviderId, serviceId);
            if (service != null) {
                builder.setAccessMethodObjectResult(new JSONObject(service.getDescription().getJSON()));
                return (DescribeResponse)this.tatooRequestId(requestId, builder.createAccessMethodResponse());
            }
            if (sessionKey.localID() != 0) {
                response = SensiNact.createErrorResponse(SensiNact.this.mediator, DescribeMethod.DescribeType.SERVICE, uri, 404, "Service not found", null);
                return this.tatooRequestId(requestId, response);
            }
            JSONObject object = AccessController.doPrivileged(new PrivilegedAction<JSONObject>(){

                @Override
                public JSONObject run() {
                    return SensiNact.this.getService(SensiNactSession.this.getSessionId(), serviceProviderId, serviceId);
                }
            });
            return this.tatooRequestId(requestId, this.describeFromJSONObject(SensiNact.this.mediator, (DescribeResponseBuilder<JSONObject>)builder, DescribeMethod.DescribeType.SERVICE, object));
        }

        @Override
        public DescribeResponse<String> getResources(String requestId, final String serviceProviderId, final String serviceId, FilteringCollection filterCollection) {
            SessionKey sessionKey = SensiNact.this.getSessionKeyFromToken(this.getSessionId());
            String uri = SensiNact.getUri(sessionKey.localID() != 0, SensiNact.this.namespace(), new String[]{serviceProviderId, serviceId});
            DescribeResponse response = null;
            DescribeMethod method = new DescribeMethod(SensiNact.this.mediator, uri, null, DescribeMethod.DescribeType.RESOURCES_LIST);
            AccessMethodResponseBuilder builder = method.createAccessMethodResponseBuilder(null);
            Service service = this.service(serviceProviderId, serviceId);
            String resources = null;
            if (service == null) {
                if (sessionKey.localID() != 0) {
                    response = SensiNact.createErrorResponse(SensiNact.this.mediator, DescribeMethod.DescribeType.RESOURCES_LIST, uri, 404, "Service not found", null);
                    return this.tatooRequestId(requestId, response);
                }
                resources = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return SensiNact.this.getResources(SensiNactSession.this.getSessionId(), serviceProviderId, serviceId);
                    }
                });
            } else {
                resources = this.joinElementNames(service);
            }
            if (resources == null) {
                response = SensiNact.createErrorResponse(SensiNact.this.mediator, DescribeMethod.DescribeType.RESOURCES_LIST, uri, 404, "Service not found", null);
                return this.tatooRequestId(requestId, response);
            }
            if (sessionKey.localID() != 0) {
                builder.setAccessMethodObjectResult(resources);
                response = (DescribeResponse)builder.createAccessMethodResponse(AccessMethodResponse.Status.SUCCESS);
                return this.tatooRequestId(requestId, response);
            }
            String result = "[" + resources + "]";
            if (filterCollection != null) {
                result = filterCollection.apply(result);
            }
            builder.setAccessMethodObjectResult(result);
            response = (DescribeResponse)builder.createAccessMethodResponse(AccessMethodResponse.Status.SUCCESS);
            if (filterCollection != null) {
                response.put("filters", new JSONArray(filterCollection.filterJsonDefinition()), filterCollection.hideFilter());
            }
            return this.tatooRequestId(requestId, response);
        }

        @Override
        public DescribeResponse<JSONObject> getResource(String requestId, final String serviceProviderId, final String serviceId, final String resourceId) {
            SessionKey sessionKey = SensiNact.this.getSessionKeyFromToken(this.getSessionId());
            String uri = SensiNact.getUri(sessionKey.localID() != 0, SensiNact.this.namespace(), new String[]{serviceProviderId, serviceId, resourceId});
            AccessMethodResponseBuilder builder = new DescribeMethod(SensiNact.this.mediator, uri, null, DescribeMethod.DescribeType.RESOURCE).createAccessMethodResponseBuilder(null);
            Resource resource = this.resource(serviceProviderId, serviceId, resourceId);
            DescribeResponse response = null;
            if (resource != null) {
                builder.setAccessMethodObjectResult(new JSONObject(resource.getDescription().getJSONDescription()));
                return (DescribeResponse)this.tatooRequestId(requestId, builder.createAccessMethodResponse());
            }
            if (sessionKey.localID() != 0) {
                response = SensiNact.createErrorResponse(SensiNact.this.mediator, DescribeMethod.DescribeType.RESOURCE, uri, 404, "Resource not found", null);
                return this.tatooRequestId(requestId, response);
            }
            JSONObject object = AccessController.doPrivileged(new PrivilegedAction<JSONObject>(){

                @Override
                public JSONObject run() {
                    return SensiNact.this.getResource(SensiNactSession.this.getSessionId(), serviceProviderId, serviceId, resourceId);
                }
            });
            return this.tatooRequestId(requestId, this.describeFromJSONObject(SensiNact.this.mediator, (DescribeResponseBuilder<JSONObject>)builder, DescribeMethod.DescribeType.RESOURCE, object));
        }

        @Override
        public boolean isAccessible(String serviceProviderId, String serviceId, String resourceId) {
            return this.isAccessible(UriUtils.getUri((String[])new String[]{serviceProviderId, serviceId, resourceId}));
        }

        private final boolean isAccessible(final String path) {
            final SessionKey sessionKey = SensiNact.this.getSessionKeyFromToken(this.getSessionId());
            Boolean accessible = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    boolean isAccessible = SensiNact.this.isAccessible(sessionKey, path);
                    if (!isAccessible && sessionKey.localID() == 0) {
                        final String[] uriElements = UriUtils.getUriElements((String)path);
                        if (uriElements.length < 3) {
                            return false;
                        }
                        final String[] providerElements = uriElements[0].split(":");
                        Boolean bool = (Boolean)SensiNact.this.remoteCoreInvocation(uriElements[0], (Executable)new Executable<SensinactCoreBaseIface, Boolean>(){

                            public Boolean execute(SensinactCoreBaseIface core) throws Exception {
                                if (core.isAccessible(sessionKey.getPublicKey(), providerElements.length > 1 ? providerElements[1] : providerElements[0], uriElements[1], uriElements[2])) {
                                    return true;
                                }
                                return false;
                            }
                        });
                        return bool == null ? false : bool;
                    }
                    return isAccessible;
                }
            });
            return accessible == null ? false : accessible;
        }
    }
}

