/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.core.Sessions;
import org.eclipse.sensinact.gateway.core.message.LocalAgentImpl;
import org.eclipse.sensinact.gateway.core.message.MidAgentCallback;
import org.eclipse.sensinact.gateway.core.message.RemoteAgentCallback;
import org.eclipse.sensinact.gateway.core.message.RemoteAgentImpl;
import org.eclipse.sensinact.gateway.core.message.SnaAgent;
import org.eclipse.sensinact.gateway.core.message.SnaFilter;
import org.eclipse.sensinact.gateway.core.security.AccessNode;
import org.eclipse.sensinact.gateway.core.security.AccessTree;
import org.eclipse.sensinact.gateway.core.security.UserKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionKey {
    private static final Logger LOG = LoggerFactory.getLogger(SessionKey.class);
    private Mediator mediator;
    private String token;
    private UserKey userKey;
    private int localID;
    private AccessTree<? extends AccessNode> tree;
    private List<String> agents;
    private Sessions.SessionObserver observer;

    public SessionKey(Mediator mediator, int localID, String token, AccessTree<? extends AccessNode> tree, Sessions.SessionObserver observer) {
        this.localID = localID;
        this.token = token;
        this.tree = tree;
        this.agents = new ArrayList<String>();
        this.mediator = mediator;
        this.observer = observer;
    }

    public AccessTree<? extends AccessNode> getAccessTree() {
        return this.tree;
    }

    public int localID() {
        return this.localID;
    }

    public void setUserKey(UserKey userKey) {
        this.userKey = userKey;
    }

    public String getPublicKey() {
        return this.userKey.getPublicKey();
    }

    public String getToken() {
        return this.token;
    }

    public boolean registerAgent(MidAgentCallback callback, SnaFilter filter) {
        if (this.agents.contains(callback.getName())) {
            LOG.warn("Agent '%s' already registered", (Object)callback.getName());
            return false;
        }
        SnaAgent agent = null;
        agent = RemoteAgentCallback.class.isAssignableFrom(callback.getClass()) ? new RemoteAgentImpl(this.mediator, (RemoteAgentCallback)callback, filter, this.getPublicKey()) : LocalAgentImpl.createAgent(this.mediator, callback, filter, this.getPublicKey());
        return this.registerAgent(callback.getName(), agent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerAgent(String agentId, SnaAgent agent) {
        if (this.agents.contains(agentId)) {
            LOG.warn("Agent %s already registered", (Object)agentId);
            return false;
        }
        SessionKey sessionKey = this;
        synchronized (sessionKey) {
            this.agents.add(agentId);
            agent.start();
        }
        return true;
    }

    public boolean unregisterAgent(String agentId) {
        if (!this.agents.remove(agentId)) {
            return false;
        }
        return (Boolean)this.mediator.callService(SnaAgent.class, String.format("(org.eclipse.sensinact.gateway.agent.id=%s)", agentId), (Executable)new Executable<SnaAgent, Boolean>(){

            public Boolean execute(SnaAgent agent) throws Exception {
                try {
                    agent.stop();
                    return true;
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                    return false;
                }
            }
        });
    }

    private String getAgentsFilter() {
        if (this.agents.size() == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        if (this.agents.size() > 1) {
            builder.append("(|");
        }
        Iterator<String> it = this.agents.iterator();
        while (it.hasNext()) {
            builder.append("(");
            builder.append("org.eclipse.sensinact.gateway.agent.id=");
            builder.append(it.next());
            builder.append(")");
        }
        if (this.agents.size() > 1) {
            builder.append(")");
        }
        return builder.toString();
    }

    void unregisterAgents() {
        if (this.agents.size() == 0) {
            return;
        }
        String filter = this.getAgentsFilter();
        this.mediator.callServices(SnaAgent.class, filter, (Executable)new Executable<SnaAgent, Void>(){

            public Void execute(SnaAgent agent) throws Exception {
                agent.stop();
                return null;
            }
        });
        this.agents.clear();
    }

    public void finalize() throws Throwable {
        this.unregisterAgents();
        if (this.observer != null) {
            this.observer.disappearing(this.getPublicKey());
        }
    }
}

