/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.sensinact.gateway.core.VariablePatternValue;

public class StringPatternValue {
    private static final Logger LOG = Logger.getLogger(StringPatternValue.class.getName());
    public static final String PATTERN_STR = "\\$\\(([^\\)]+)\\)";
    public static final Pattern PATTERN;
    private final String value;
    private final String raw;
    private final boolean isPattern;
    private VariablePatternValue variable;

    public StringPatternValue(String value) {
        this(null, value);
    }

    public StringPatternValue(VariablePatternValue variable, String value) {
        if (value == null || PATTERN == null) {
            this.value = null;
            this.raw = null;
            this.isPattern = false;
        } else {
            this.value = value;
            Matcher matcher = PATTERN.matcher(value);
            this.isPattern = matcher.matches();
            this.raw = this.isPattern ? matcher.group(1) : null;
        }
        this.variable = variable == null ? new DefaultVariablePatternValue() : variable;
    }

    public boolean isPattern() {
        return this.isPattern;
    }

    public String build() {
        if (!this.isPattern) {
            return this.value;
        }
        return this.raw + "_" + this.variable.next();
    }

    public String getLast() {
        if (!this.isPattern) {
            return this.value;
        }
        String var = this.variable.get();
        if (var == null) {
            var = this.variable.next();
        }
        return this.raw + "_" + var;
    }

    public String getRaw() {
        if (!this.isPattern) {
            return this.value;
        }
        return this.raw;
    }

    public void reset() {
        this.variable.reset();
    }

    static {
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(PATTERN_STR);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
        PATTERN = pattern;
    }

    private final class DefaultVariablePatternValue
    implements VariablePatternValue {
        private final AtomicInteger count = new AtomicInteger(0);

        DefaultVariablePatternValue() {
        }

        @Override
        public String next() {
            return String.valueOf(this.count.getAndIncrement());
        }

        @Override
        public String get() {
            int c = this.count.get();
            if (c == 0) {
                return null;
            }
            return String.valueOf(c - 1);
        }

        @Override
        public void reset() {
            this.count.set(0);
        }
    }
}

