/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.method;

import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.common.primitive.InvalidValueException;
import org.eclipse.sensinact.gateway.core.method.DynamicParameterValue;
import org.eclipse.sensinact.gateway.core.method.Parameter;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicParameter
extends Parameter {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicParameter.class);

    public DynamicParameter(Mediator mediator, String name, Class<?> type, DynamicParameterValue value) throws InvalidValueException {
        super(mediator, name, type);
        this.fixed = true;
        this.fixedValue = value;
    }

    @Override
    public void reset() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("reset not implemented for DynamicParameter");
        }
    }

    @Override
    public Object getValue() {
        return ((DynamicParameterValue)this.fixedValue).getValue();
    }

    @Override
    public String getJSON() {
        JSONObject description = super.getJSONObject();
        description.put("value", (Object)((DynamicParameterValue)this.fixedValue).getJSON());
        return description.toString();
    }

    protected void setResourceValueExtractor(Executable<Void, Object> extractor) {
        if (this.fixedValue != null) {
            ((DynamicParameterValue)this.fixedValue).setResourceValueExtractor(extractor);
        }
    }

    @Override
    public Object clone() {
        try {
            return new DynamicParameter(this.mediator, this.name, this.type, (DynamicParameterValue)this.fixedValue);
        }
        catch (InvalidValueException e) {
            return null;
        }
    }
}

