/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.method.trigger;

import java.util.ArrayList;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.constraint.ConstraintConstantPair;
import org.eclipse.sensinact.gateway.common.constraint.ConstraintFactory;
import org.eclipse.sensinact.gateway.common.primitive.InvalidValueException;
import org.eclipse.sensinact.gateway.core.method.trigger.AbstractAccessMethodTrigger;
import org.eclipse.sensinact.gateway.core.method.trigger.AccessMethodTrigger;
import org.eclipse.sensinact.gateway.core.method.trigger.AccessMethodTriggerFactory;
import org.eclipse.sensinact.gateway.core.method.trigger.ConditionalConstant;
import org.eclipse.sensinact.gateway.core.method.trigger.Constant;
import org.eclipse.sensinact.gateway.core.method.trigger.Copy;
import org.json.JSONArray;
import org.json.JSONObject;

public class DefaultAccessMethodTriggerFactory
implements AccessMethodTriggerFactory {
    @Override
    public boolean handle(String type) {
        try {
            return AccessMethodTrigger.Type.valueOf(type) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public AccessMethodTrigger newInstance(Mediator mediator, JSONObject jsonTrigger) throws InvalidValueException {
        if (JSONObject.NULL.equals(jsonTrigger)) {
            throw new InvalidValueException("Null JSON trigger definition");
        }
        AbstractAccessMethodTrigger trigger = null;
        try {
            String jsonType = jsonTrigger.getString("type");
            AccessMethodTrigger.Type type = AccessMethodTrigger.Type.valueOf(jsonType);
            String builder = jsonTrigger.getString("builder");
            boolean passOn = jsonTrigger.optBoolean("passOn");
            Object argument = jsonTrigger.opt("argument");
            switch (type) {
                case CONDITIONAL: {
                    int length;
                    ArrayList<ConstraintConstantPair> constraints = new ArrayList<ConstraintConstantPair>();
                    JSONArray constants = jsonTrigger.optJSONArray("constants");
                    int n = length = constants == null ? 0 : constants.length();
                    for (int constantsIndex = 0; constantsIndex < length; ++constantsIndex) {
                        JSONObject constantObject = constants.getJSONObject(constantsIndex);
                        constraints.add(new ConstraintConstantPair(ConstraintFactory.Loader.load((ClassLoader)mediator.getClassLoader(), (Object)constantObject.opt("constraint")), constantObject.opt("constant")));
                    }
                    trigger = new ConditionalConstant(argument, builder, passOn, constraints);
                    break;
                }
                case CONSTANT: {
                    trigger = new Constant(argument, passOn);
                    break;
                }
                case COPY: {
                    trigger = new Copy(argument, builder, passOn);
                    break;
                }
                default: {
                    throw new InvalidValueException("Unknown calculation identifier :" + jsonType);
                }
            }
        }
        catch (Exception e) {
            throw new InvalidValueException((Throwable)e);
        }
        return trigger;
    }
}

