/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security;

import org.eclipse.sensinact.gateway.core.security.AccessLevel;
import org.eclipse.sensinact.gateway.core.security.AccessLevelImpl;

public enum AccessLevelOption {
    UNAUTHORIZED(0),
    ANONYMOUS(1),
    AUTHENTICATED(2),
    ADMIN(3),
    OWNER(4);

    private final AccessLevel accessLevel;

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    private AccessLevelOption(int level) {
        this.accessLevel = new AccessLevelImpl(level);
    }

    public static AccessLevelOption valueOf(AccessLevel accessLevel) {
        int length;
        if (accessLevel == null) {
            return ANONYMOUS;
        }
        AccessLevelOption option = null;
        AccessLevelOption[] options = AccessLevelOption.values();
        int n = length = options == null ? 0 : options.length;
        for (int index = 0; index < length; ++index) {
            if (options[index].getAccessLevel().getLevel() != accessLevel.getLevel()) continue;
            option = options[index];
            break;
        }
        return option == null ? UNAUTHORIZED : option;
    }
}

