/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.core.security.AccessLevelOption;
import org.eclipse.sensinact.gateway.core.security.AccessProfile;
import org.eclipse.sensinact.gateway.core.security.AccessProfileOption;
import org.eclipse.sensinact.gateway.core.security.ImmutableAccessNode;
import org.eclipse.sensinact.gateway.core.security.MethodAccess;
import org.eclipse.sensinact.gateway.core.security.MethodAccessibility;
import org.eclipse.sensinact.gateway.core.security.MethodAccessibilityImpl;
import org.eclipse.sensinact.gateway.core.security.MutableAccessNode;
import org.eclipse.sensinact.gateway.util.tree.ImmutablePathNode;
import org.eclipse.sensinact.gateway.util.tree.PathNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessNodeImpl<N extends AccessNodeImpl<N>>
extends PathNode<N>
implements MutableAccessNode {
    private static final Logger LOG = LoggerFactory.getLogger(AccessNodeImpl.class);
    protected Map<AccessLevelOption, List<MethodAccessibility>> accesses = new EnumMap<AccessLevelOption, List<MethodAccessibility>>(AccessLevelOption.class);
    private AccessProfile profile;

    public AccessNodeImpl(String name, boolean isPattern) {
        super(name, isPattern);
    }

    @Override
    public AccessProfile getProfile() {
        return this.profile;
    }

    @Override
    public void withAccessProfile(AccessProfileOption option) {
        this.withAccessProfile(option.getAccessProfile());
    }

    @Override
    public void withAccessProfile(AccessProfile profile) {
        if (this.profile != null || profile == null) {
            return;
        }
        this.profile = profile;
        try {
            int length;
            Set<MethodAccess> methodAccesses = profile.getMethodAccesses();
            if (methodAccesses.isEmpty()) {
                return;
            }
            int[] accessLevels = null;
            Iterator<AccessLevelOption> iterator = Arrays.asList(AccessLevelOption.values()).iterator();
            AccessMethod.Type[] types = AccessMethod.Type.values();
            accessLevels = new int[types.length];
            for (MethodAccess methodAccess : methodAccesses) {
                int level = methodAccess.getAccessLevel().getLevel();
                int ind = methodAccess.getMethod().ordinal();
                accessLevels[ind] = level;
            }
            int index = -1;
            int n = length = types == null ? 0 : types.length;
            while (iterator.hasNext()) {
                AccessLevelOption optionLevel = iterator.next();
                for (index = 0; index < length; ++index) {
                    this.setAccessibleMethod(types[index], optionLevel, accessLevels[index] <= optionLevel.getAccessLevel().getLevel());
                }
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<MethodAccessibility> getAccessibleMethods(AccessLevelOption accessLevelOption) {
        ArrayList<MethodAccessibility> accesses = new ArrayList<MethodAccessibility>();
        AccessMethod.Type[] types = AccessMethod.Type.values();
        int length = types.length;
        for (int index = 0; index < length; ++index) {
            accesses.add(new MethodAccessibilityImpl(types[index], accessLevelOption, this.isAccessibleMethod(types[index], accessLevelOption)));
        }
        return accesses;
    }

    protected void setAccessibleMethod(AccessMethod.Type accessMethod, AccessLevelOption optionLevel, boolean accessibility) {
        List<MethodAccessibility> methodAccesses = this.accesses.get((Object)optionLevel);
        if (methodAccesses == null) {
            methodAccesses = new ArrayList<MethodAccessibility>();
            this.accesses.put(optionLevel, methodAccesses);
        }
        MethodAccessibilityImpl methodAccessibilities = new MethodAccessibilityImpl(accessMethod, optionLevel, accessibility);
        methodAccesses.add(methodAccessibilities);
    }

    protected boolean isAccessibleMethod(AccessMethod.Type accessMethod, AccessLevelOption optionLevel) {
        boolean accessible = false;
        List methodAccesses = this.accesses == null ? Collections.emptyList() : Optional.ofNullable(this.accesses.get((Object)optionLevel)).orElse(Collections.emptyList());
        Optional<MethodAccessibility> found = methodAccesses.stream().filter(ma -> ma.getName().equals(accessMethod.name())).findFirst();
        accessible = found.isPresent() ? found.get().isAccessible() : (this.parent == null ? false : ((AccessNodeImpl)this.parent).isAccessibleMethod(accessMethod, optionLevel));
        return accessible;
    }

    @Override
    public AccessLevelOption getAccessLevelOption(AccessMethod.Type method) {
        int length;
        AccessLevelOption[] accessLevelOptions = AccessLevelOption.values();
        int n = length = accessLevelOptions == null ? 0 : accessLevelOptions.length;
        for (int index = 0; index < length; ++index) {
            if (!this.isAccessibleMethod(method, accessLevelOptions[index])) continue;
            return accessLevelOptions[index];
        }
        return AccessLevelOption.OWNER;
    }

    public <P extends ImmutablePathNode<P>> P immutable(Class<P> ic, P parent) {
        return (P)new ImmutableAccessNode((ImmutableAccessNode)parent, this.nodeName, this.isPattern, this.children, this.profile);
    }

    public N clone() {
        AccessNodeImpl clone = null;
        try {
            clone = (AccessNodeImpl)this.getClass().getConstructor(String.class, Boolean.TYPE).newInstance(this.nodeName, this.isPattern);
            clone.withAccessProfile(this.profile);
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                clone.add((PathNode)((AccessNodeImpl)iterator.next()).clone());
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return (N)clone;
    }
}

