/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.core.security.AccessLevel;
import org.eclipse.sensinact.gateway.core.security.AccessLevelImpl;
import org.eclipse.sensinact.gateway.core.security.AccessProfile;
import org.eclipse.sensinact.gateway.core.security.AccessProfileImpl;
import org.eclipse.sensinact.gateway.core.security.MethodAccess;
import org.eclipse.sensinact.gateway.core.security.MethodAccessImpl;

public enum AccessProfileOption {
    DEFAULT(new HashMap<AccessMethod.Type, Integer>(){
        {
            this.put(AccessMethod.Type.valueOf(AccessMethod.GET), new Integer(1));
            this.put(AccessMethod.Type.valueOf(AccessMethod.SET), new Integer(2));
            this.put(AccessMethod.Type.valueOf(AccessMethod.ACT), new Integer(2));
            this.put(AccessMethod.Type.valueOf(AccessMethod.SUBSCRIBE), new Integer(1));
            this.put(AccessMethod.Type.valueOf(AccessMethod.UNSUBSCRIBE), new Integer(1));
            this.put(AccessMethod.Type.valueOf(AccessMethod.DESCRIBE), new Integer(1));
        }
    }),
    ALL_ANONYMOUS(new HashMap<AccessMethod.Type, Integer>(){
        {
            this.put(AccessMethod.Type.valueOf(AccessMethod.GET), new Integer(1));
            this.put(AccessMethod.Type.valueOf(AccessMethod.SET), new Integer(1));
            this.put(AccessMethod.Type.valueOf(AccessMethod.ACT), new Integer(1));
            this.put(AccessMethod.Type.valueOf(AccessMethod.SUBSCRIBE), new Integer(1));
            this.put(AccessMethod.Type.valueOf(AccessMethod.UNSUBSCRIBE), new Integer(1));
            this.put(AccessMethod.Type.valueOf(AccessMethod.DESCRIBE), new Integer(1));
        }
    }),
    NO_ANONYMOUS(new HashMap<AccessMethod.Type, Integer>(){
        {
            this.put(AccessMethod.Type.valueOf(AccessMethod.GET), new Integer(2));
            this.put(AccessMethod.Type.valueOf(AccessMethod.SET), new Integer(2));
            this.put(AccessMethod.Type.valueOf(AccessMethod.ACT), new Integer(2));
            this.put(AccessMethod.Type.valueOf(AccessMethod.SUBSCRIBE), new Integer(2));
            this.put(AccessMethod.Type.valueOf(AccessMethod.UNSUBSCRIBE), new Integer(2));
            this.put(AccessMethod.Type.valueOf(AccessMethod.DESCRIBE), new Integer(2));
        }
    }),
    ADMIN(new HashMap<AccessMethod.Type, Integer>(){
        {
            this.put(AccessMethod.Type.valueOf(AccessMethod.GET), new Integer(3));
            this.put(AccessMethod.Type.valueOf(AccessMethod.SET), new Integer(3));
            this.put(AccessMethod.Type.valueOf(AccessMethod.ACT), new Integer(3));
            this.put(AccessMethod.Type.valueOf(AccessMethod.SUBSCRIBE), new Integer(3));
            this.put(AccessMethod.Type.valueOf(AccessMethod.UNSUBSCRIBE), new Integer(3));
            this.put(AccessMethod.Type.valueOf(AccessMethod.DESCRIBE), new Integer(3));
        }
    }),
    OWNER(new HashMap<AccessMethod.Type, Integer>(){
        {
            this.put(AccessMethod.Type.valueOf(AccessMethod.GET), new Integer(3));
            this.put(AccessMethod.Type.valueOf(AccessMethod.SET), new Integer(4));
            this.put(AccessMethod.Type.valueOf(AccessMethod.ACT), new Integer(4));
            this.put(AccessMethod.Type.valueOf(AccessMethod.SUBSCRIBE), new Integer(3));
            this.put(AccessMethod.Type.valueOf(AccessMethod.UNSUBSCRIBE), new Integer(3));
            this.put(AccessMethod.Type.valueOf(AccessMethod.DESCRIBE), new Integer(3));
        }
    });

    private final AccessProfileImpl accessProfile;

    private static final Set<MethodAccess> buildMethodAccesses(HashMap<AccessMethod.Type, Integer> map) {
        HashSet<MethodAccess> methodAccesses = new HashSet<MethodAccess>();
        for (Map.Entry<AccessMethod.Type, Integer> entry : map.entrySet()) {
            AccessMethod.Type type = entry.getKey();
            AccessLevelImpl accessLevel = new AccessLevelImpl(entry.getValue());
            methodAccesses.add(new MethodAccessImpl(accessLevel, type));
        }
        return methodAccesses;
    }

    public static AccessProfileOption valueOf(AccessProfile profile) {
        if (profile == null) {
            return ALL_ANONYMOUS;
        }
        Set<MethodAccess> methodAccesses = profile.getMethodAccesses();
        HashMap<AccessMethod.Type, AccessLevel> profileMap = new HashMap<AccessMethod.Type, AccessLevel>();
        for (MethodAccess methodAccess : methodAccesses) {
            profileMap.put(methodAccess.getMethod(), methodAccess.getAccessLevel());
        }
        AccessProfileOption[] values = AccessProfileOption.values();
        int length = values == null ? 0 : values.length;
        AccessProfileOption value = null;
        for (int index = 0; index < length; ++index) {
            AccessProfile optionProfile = values[index].getAccessProfile();
            Set<MethodAccess> optionAccesses = optionProfile.getMethodAccesses();
            Iterator<MethodAccess> optionIterator = optionAccesses.iterator();
            boolean found = true;
            while (optionIterator.hasNext()) {
                MethodAccess methodAccess = optionIterator.next();
                if (((AccessLevel)profileMap.get(methodAccess.getMethod())).getLevel() == methodAccess.getAccessLevel().getLevel()) continue;
                found = false;
                break;
            }
            if (!found) continue;
            value = values[index];
            break;
        }
        return value;
    }

    public AccessProfile getAccessProfile() {
        return this.accessProfile;
    }

    private AccessProfileOption(HashMap<AccessMethod.Type, Integer> map) {
        Set<MethodAccess> methodAccesses = AccessProfileOption.buildMethodAccesses(map);
        this.accessProfile = new AccessProfileImpl(methodAccesses);
    }
}

