/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.common.execution;

import java.util.Arrays;
import org.eclipse.sensinact.gateway.common.execution.Execution;
import org.json.JSONArray;

public interface ErrorHandler {
    public int handle(Exception var1);

    public int getPolicy();

    public JSONArray getStackTrace();

    public int getExceptions();

    public void setAlternative(Execution var1);

    public void setAlternativeParameters(Object[] var1);

    public Object getAlternativeResult();

    public static class Policy {
        public static final int CONTINUE = 1;
        public static final int STOP = 16;
        public static final int ROLLBACK = 256;
        public static final int IGNORE = 4096;
        public static final int ALTERNATIVE = 65536;
        public static final int LOG = 0x100000;
        public static final int DEFAULT_POLICY = 0x100010;

        public static int valueOf(int[] policies) {
            int length;
            int policy = 0;
            int n = length = policies == null ? 0 : policies.length;
            for (int index = 0; index < length; ++index) {
                policy |= policies[index];
            }
            return policy;
        }

        public static int[] valueOf(int policy) {
            int length;
            int[] policies = new int[]{1, 16, 256, 4096, 0x100000};
            int[] effectivePolicies = new int[policies.length];
            int pos = 0;
            int n = length = policies == null ? 0 : policies.length;
            for (int index = 0; index < length; ++index) {
                if (!Policy.contains(policy, policies[index])) continue;
                effectivePolicies[pos++] = policies[index];
            }
            if (pos == 0) {
                return new int[0];
            }
            return Arrays.copyOfRange(effectivePolicies, 0, pos);
        }

        public static boolean contains(int policy, int errorHandlerPolicy) {
            return (policy & errorHandlerPolicy) == errorHandlerPolicy;
        }
    }
}

