/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.common.interpolator;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.eclipse.sensinact.gateway.common.annotation.Property;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.interpolator.exception.IncompleteDataException;
import org.eclipse.sensinact.gateway.common.interpolator.exception.InterpolationException;
import org.eclipse.sensinact.gateway.common.interpolator.exception.InvalidValueException;
import org.eclipse.sensinact.gateway.common.interpolator.exception.ObjectInstantiationException;

public class Interpolator {
    private static final Logger LOG = Logger.getLogger(Interpolator.class.getName());
    private final Map<String, String> propertiesInjected = new HashMap<String, String>();
    private PropertyBucket propertyBucket;

    public Interpolator(Mediator mediator) {
        this.propertyBucket = new MediatorPropertyBucket(mediator);
    }

    public Interpolator(Map<?, ?> map) {
        this.propertyBucket = new MapPropertyBucket(map);
    }

    public Interpolator(Dictionary<String, ?> dictionary) {
        this.propertyBucket = new DictionaryPropertyBucket(dictionary);
    }

    public <E> E getInstance(E object) throws InterpolationException {
        try {
            for (Field field : object.getClass().getDeclaredFields()) {
                Pattern patternValidation;
                field.setAccessible(true);
                Property annotation = field.getAnnotation(Property.class);
                if (annotation == null) continue;
                String propertyName = annotation.name().trim().equals("") ? field.getName() : annotation.name();
                Object value = this.propertyBucket.get(propertyName);
                if (!annotation.defaultValue().trim().equals("") && value == null) {
                    value = annotation.defaultValue();
                }
                if (annotation.mandatory() && value == null) {
                    throw new IncompleteDataException(String.format("mandatory field \"%s\" is missing in property table", field.getName()));
                }
                if (!annotation.validationRegex().trim().equals("") && value != null && !(patternValidation = Pattern.compile(annotation.validationRegex())).matcher(value.toString()).matches()) {
                    LOG.log(Level.SEVERE, String.format("field value %s, on field {}, is invalid with respect to the regex %s required", value.toString(), field.getName(), annotation.validationRegex()));
                    throw new InvalidValueException(String.format("field value \"%s\", on field \"%s\", is invalid with respect to the regex \"%s\" required", value.toString(), field.getName(), annotation.validationRegex()));
                }
                if (value == null) continue;
                try {
                    this.propertiesInjected.put(propertyName, value.toString());
                    String typeClass = field.getType().getCanonicalName();
                    if (typeClass.equals("java.lang.String")) {
                        field.set(object, value);
                        continue;
                    }
                    if (typeClass.equals("java.lang.Integer")) {
                        field.set(object, Integer.parseInt(value.toString()));
                        continue;
                    }
                    if (typeClass.equals("java.lang.Long")) {
                        field.set(object, Long.parseLong(value.toString()));
                        continue;
                    }
                    if (typeClass.equals("java.lang.Float")) {
                        field.set(object, Float.valueOf(Float.parseFloat(value.toString())));
                        continue;
                    }
                    if (!typeClass.equals("java.lang.Boolean")) continue;
                    field.set(object, Boolean.parseBoolean(value.toString()));
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, String.format("value %s could not be inject on field %s of the type %s in POJO %s", value.toString(), field.getName(), field.getType().getCanonicalName(), object.getClass().toString()), e);
                    throw new InvalidValueException(String.format("value \"%s\" could not be inject on field \"%s\" of the type \"%s\" in POJO \"%s\"", value.toString(), field.getName(), field.getType().getCanonicalName(), object.getClass().toString()));
                }
            }
            return object;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to create instance of object to receive interpolation", e);
            throw new InterpolationException(e);
        }
    }

    public <T> T getNewInstance(Class<T> clazz) throws InterpolationException {
        try {
            T object = clazz.newInstance();
            return this.getInstance(object);
        }
        catch (InstantiationException e) {
            LOG.log(Level.SEVERE, "Failed to create instance of object to receive interpolation", e);
            throw new ObjectInstantiationException(e);
        }
        catch (IllegalAccessException e) {
            LOG.log(Level.SEVERE, "Failed to create instance of object to receive interpolation", e);
            throw new ObjectInstantiationException(e);
        }
    }

    public Map<String, String> getPropertiesInjected() {
        return Collections.unmodifiableMap(this.propertiesInjected);
    }

    private class DictionaryPropertyBucket
    implements PropertyBucket {
        private final Dictionary<String, ?> dictionary;

        DictionaryPropertyBucket(Dictionary<String, ?> dictionary) {
            this.dictionary = dictionary;
        }

        @Override
        public Object get(String property) {
            return this.dictionary.get(property);
        }
    }

    private class MapPropertyBucket
    implements PropertyBucket {
        private final Map<?, ?> map;

        MapPropertyBucket(Map<?, ?> map) {
            this.map = map;
        }

        @Override
        public Object get(String property) {
            return this.map.get(property);
        }
    }

    private class MediatorPropertyBucket
    implements PropertyBucket {
        private final Mediator mediator;

        MediatorPropertyBucket(Mediator mediator) {
            this.mediator = mediator;
        }

        @Override
        public Object get(String property) {
            return this.mediator.getProperty(property);
        }
    }

    private static interface PropertyBucket {
        public Object get(String var1);
    }
}

