/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.ttn.listener;

import java.util.List;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.generic.packet.InvalidPacketException;
import org.eclipse.sensinact.gateway.generic.packet.Packet;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.device.MqttProtocolStackEndpoint;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.util.listener.MqttTopicMessage;
import org.eclipse.sensinact.gateway.sthbnd.ttn.listener.TtnDownlinkListener;
import org.eclipse.sensinact.gateway.sthbnd.ttn.model.TtnSubPacket;
import org.eclipse.sensinact.gateway.sthbnd.ttn.model.TtnUplinkPayload;
import org.eclipse.sensinact.gateway.sthbnd.ttn.packet.TtnUplinkPacket;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TtnUplinkListener
extends MqttTopicMessage {
    private static final Logger LOG = LoggerFactory.getLogger(TtnUplinkListener.class);
    public static final String DOWNLINK_MARKER = "#DOWNLINK#";
    private final Mediator mediator;
    private final MqttProtocolStackEndpoint endpoint;
    private TtnDownlinkListener dowlinkListener;

    public TtnUplinkListener(Mediator mediator, TtnDownlinkListener downlinkListener, MqttProtocolStackEndpoint endpoint) {
        this.mediator = mediator;
        this.endpoint = endpoint;
        this.dowlinkListener = downlinkListener;
    }

    public void messageReceived(String topic, String message) {
        TtnUplinkPayload payload;
        String device;
        block9: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Uplink message: " + message);
            }
            device = topic.split("/")[2];
            JSONObject json = new JSONObject(message);
            payload = null;
            try {
                payload = new TtnUplinkPayload(this.mediator, json);
            }
            catch (JSONException e) {
                if (!LOG.isErrorEnabled()) break block9;
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        if (payload != null) {
            List<TtnSubPacket<?>> subPackets = payload.getSubPackets();
            if (subPackets.isEmpty()) {
                return;
            }
            int i = 0;
            while (i < subPackets.size()) {
                TtnSubPacket<?> subPacket = subPackets.get(i);
                if (DOWNLINK_MARKER.equals(subPacket.getMetadata())) {
                    this.dowlinkListener.messageReceived(payload.getApplicationId(), payload.getDeviceId(), subPacket.getValue());
                    subPackets.remove(i);
                    continue;
                }
                ++i;
            }
            TtnUplinkPacket packet = new TtnUplinkPacket(device, subPackets);
            try {
                this.endpoint.process((Packet)packet);
            }
            catch (InvalidPacketException e) {
                e.printStackTrace();
            }
        }
    }
}

