/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security.access.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.core.security.AccessLevelOption;
import org.eclipse.sensinact.gateway.core.security.AccessNode;
import org.eclipse.sensinact.gateway.core.security.AccessNodeImpl;
import org.eclipse.sensinact.gateway.core.security.AccessProfile;
import org.eclipse.sensinact.gateway.core.security.AccessProfileImpl;
import org.eclipse.sensinact.gateway.core.security.AccessProfileOption;
import org.eclipse.sensinact.gateway.core.security.AccessTree;
import org.eclipse.sensinact.gateway.core.security.AccessTreeImpl;
import org.eclipse.sensinact.gateway.core.security.AuthorizationService;
import org.eclipse.sensinact.gateway.core.security.ImmutableAccessNode;
import org.eclipse.sensinact.gateway.core.security.ImmutableAccessTree;
import org.eclipse.sensinact.gateway.core.security.MethodAccessImpl;
import org.eclipse.sensinact.gateway.core.security.MutableAccessNode;
import org.eclipse.sensinact.gateway.core.security.MutableAccessTree;
import org.eclipse.sensinact.gateway.core.security.SecuredAccess;
import org.eclipse.sensinact.gateway.core.security.SecuredAccessException;
import org.eclipse.sensinact.gateway.core.security.SecurityDataStoreService;
import org.eclipse.sensinact.gateway.core.security.access.impl.AuthorizationServiceImpl;
import org.eclipse.sensinact.gateway.core.security.dao.AgentDAO;
import org.eclipse.sensinact.gateway.core.security.dao.ApplicationDAO;
import org.eclipse.sensinact.gateway.core.security.dao.AuthenticatedAccessLevelDAO;
import org.eclipse.sensinact.gateway.core.security.dao.BundleDAO;
import org.eclipse.sensinact.gateway.core.security.dao.DAOException;
import org.eclipse.sensinact.gateway.core.security.dao.ObjectDAO;
import org.eclipse.sensinact.gateway.core.security.dao.ObjectProfileAccessDAO;
import org.eclipse.sensinact.gateway.core.security.entity.AgentEntity;
import org.eclipse.sensinact.gateway.core.security.entity.ApplicationEntity;
import org.eclipse.sensinact.gateway.core.security.entity.AuthenticatedAccessLevelEntity;
import org.eclipse.sensinact.gateway.core.security.entity.BundleEntity;
import org.eclipse.sensinact.gateway.core.security.entity.ObjectEntity;
import org.eclipse.sensinact.gateway.datastore.api.DataStoreException;
import org.eclipse.sensinact.gateway.datastore.api.DataStoreService;
import org.eclipse.sensinact.gateway.util.UriUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class SecuredAccessImpl
implements SecuredAccess {
    private static final Logger LOG = LoggerFactory.getLogger(SecuredAccessImpl.class);
    private final SecurityDataStoreService dataStoreService;
    private BundleDAO bundleDAO;
    private AgentDAO agentDAO;
    private ApplicationDAO applicationDAO;
    private ObjectDAO objectDAO;
    private ObjectProfileAccessDAO objectProfileAccessDAO;
    private AuthenticatedAccessLevelDAO authenticatedAccessLevelDAO;
    private ObjectEntity root;
    private AccessProfileOption rootObjectProfileOption;
    private ServiceRegistration<AuthorizationService> authorizationRegistration;

    @Activate
    public SecuredAccessImpl(BundleContext ctx, @Reference SecurityDataStoreService dataStore) throws SecuredAccessException {
        this.dataStoreService = dataStore;
        try {
            this.applicationDAO = new ApplicationDAO((DataStoreService)this.dataStoreService);
            this.agentDAO = new AgentDAO((DataStoreService)this.dataStoreService);
            this.objectDAO = new ObjectDAO((DataStoreService)this.dataStoreService);
            this.bundleDAO = new BundleDAO((DataStoreService)this.dataStoreService);
            this.objectProfileAccessDAO = new ObjectProfileAccessDAO((DataStoreService)this.dataStoreService);
            this.authenticatedAccessLevelDAO = new AuthenticatedAccessLevelDAO((DataStoreService)this.dataStoreService);
            this.root = (ObjectEntity)this.objectDAO.select(Collections.singletonMap("OID", 0L)).get(0);
            this.rootObjectProfileOption = this.objectProfileAccessDAO.getAccessProfileOption(this.root.getObjectProfileEntity());
            this.authorizationRegistration = ctx.registerService(AuthorizationService.class, (Object)new AuthorizationServiceImpl(this.authenticatedAccessLevelDAO), null);
        }
        catch (DAOException | DataStoreException e) {
            throw new SecuredAccessException((Throwable)e);
        }
    }

    @Deactivate
    void stop() {
        if (this.authorizationRegistration != null) {
            this.authorizationRegistration.unregister();
        }
    }

    public void buildAccessNodesHierarchy(String signature, String name, MutableAccessTree<? extends MutableAccessNode> tree) throws SecuredAccessException {
        try {
            if (name == null) {
                throw new NullPointerException("The sensiNact resource model's name is missing");
            }
            if (!this.checkIdentifier(signature, name)) {
                if (signature == null) {
                    throw new SecuredAccessException(String.format("A '%s' sensiNact resource model already exists in the data store", name));
                }
                throw new SecuredAccessException("Invalid bundle identifier");
            }
            if (signature != null) {
                this.buildNodes(tree, this.objectDAO.find(UriUtils.getUri((String[])new String[]{name})));
            }
        }
        catch (DAOException e) {
            throw new SecuredAccessException((Throwable)((Object)e));
        }
        catch (Exception e) {
            throw new SecuredAccessException((Throwable)e);
        }
    }

    public MutableAccessTree<? extends MutableAccessNode> getAccessTree(String signature) throws SecuredAccessException {
        MutableAccessTree tree = null;
        BundleEntity object = null;
        AccessProfileOption option = null;
        try {
            option = signature == null || (object = this.bundleDAO.find(signature)) == null ? this.rootObjectProfileOption : this.objectProfileAccessDAO.getAccessProfileOption(object.getObjectProfileEntity());
            tree = new AccessTreeImpl().withAccessProfile(option);
        }
        catch (Exception e) {
            throw new SecuredAccessException((Throwable)e);
        }
        return tree;
    }

    public AccessTree<? extends AccessNode> getUserAccessTree(String publicKey) throws SecuredAccessException {
        AccessTreeImpl tree = null;
        AccessLevelOption option = null;
        try {
            HashMap<String, Object> directive = new HashMap<String, Object>();
            directive.put("UOID", 0L);
            directive.put("PUBLIC_KEY", publicKey);
            List entities = this.authenticatedAccessLevelDAO.select(directive);
            option = entities == null || entities.size() != 1 ? AccessLevelOption.ANONYMOUS : ((AuthenticatedAccessLevelEntity)entities.get(0)).getAccessLevelOption();
            AccessMethod.Type[] types = AccessMethod.Type.values();
            int length = types == null ? 0 : types.length;
            HashSet<MethodAccessImpl> methodAccesses = new HashSet<MethodAccessImpl>();
            for (int index = 0; index < length; ++index) {
                methodAccesses.add(new MethodAccessImpl(option.getAccessLevel(), types[index]));
            }
            tree = new AccessTreeImpl();
            ((AccessNodeImpl)tree.getRoot()).withAccessProfile((AccessProfile)new AccessProfileImpl(methodAccesses));
            this.buildTree((MutableAccessTree<? extends MutableAccessNode>)tree, publicKey);
            return (AccessTree)tree.immutable(ImmutableAccessTree.class, ImmutableAccessNode.class);
        }
        catch (Exception e) {
            throw new SecuredAccessException((Throwable)e);
        }
    }

    private void buildTree(MutableAccessTree<? extends MutableAccessNode> tree, String publicKey) throws SecuredAccessException {
        if (publicKey == null || publicKey.startsWith("anonymous")) {
            return;
        }
        try {
            int length;
            HashMap<String, Object> directive = new HashMap<String, Object>();
            directive.put("PUBLIC_KEY", publicKey);
            List entities = this.authenticatedAccessLevelDAO.select(directive);
            Iterator iterator = entities.iterator();
            directive.clear();
            AccessMethod.Type[] types = AccessMethod.Type.values();
            int n = length = types == null ? 0 : types.length;
            while (iterator.hasNext()) {
                AuthenticatedAccessLevelEntity entity = (AuthenticatedAccessLevelEntity)iterator.next();
                AccessLevelOption option = entity.getAccessLevelOption();
                long objectId = entity.getObjectId();
                if (objectId == 0L) continue;
                directive.put("OID", objectId);
                List objectEntities = this.objectDAO.select(directive);
                if (objectEntities == null || objectEntities.size() != 1) continue;
                HashSet<MethodAccessImpl> methodAccesses = new HashSet<MethodAccessImpl>();
                for (int index = 0; index < length; ++index) {
                    methodAccesses.add(new MethodAccessImpl(option.getAccessLevel(), types[index]));
                }
                Stack<ObjectEntity> family = new Stack<ObjectEntity>();
                ObjectEntity familyMember = (ObjectEntity)objectEntities.get(0);
                while (familyMember != null && familyMember.getIdentifier() != 0L) {
                    family.push(familyMember);
                    directive.clear();
                    directive.put("OID", familyMember.getParent());
                    objectEntities = this.objectDAO.select(directive);
                    familyMember = objectEntities.isEmpty() ? null : (ObjectEntity)objectEntities.get(0);
                }
                MutableAccessNode node = null;
                while (!family.isEmpty()) {
                    familyMember = (ObjectEntity)family.pop();
                    node = tree.add(familyMember.getPath(), familyMember.isPattern());
                }
                node.withAccessProfile((AccessProfile)new AccessProfileImpl(methodAccesses));
            }
        }
        catch (Exception e) {
            throw new SecuredAccessException((Throwable)e);
        }
    }

    public AccessTree<? extends AccessNode> getApplicationAccessTree(String publicKey) throws SecuredAccessException {
        AccessTreeImpl tree = null;
        AccessLevelOption option = null;
        try {
            HashMap<String, Object> directive = new HashMap<String, Object>();
            directive.put("UOID", 0L);
            directive.put("PUBLIC_KEY", publicKey == null ? "anonymous" : publicKey);
            List entities = this.authenticatedAccessLevelDAO.select(directive);
            option = entities == null || entities.size() != 1 ? AccessLevelOption.ANONYMOUS : ((AuthenticatedAccessLevelEntity)entities.get(0)).getAccessLevelOption();
            AccessMethod.Type[] types = AccessMethod.Type.values();
            int length = types == null ? 0 : types.length;
            HashSet<MethodAccessImpl> methodAccesses = new HashSet<MethodAccessImpl>();
            for (int index = 0; index < length; ++index) {
                methodAccesses.add(new MethodAccessImpl(option.getAccessLevel(), types[index]));
            }
            tree = new AccessTreeImpl();
            ((AccessNodeImpl)tree.getRoot()).withAccessProfile((AccessProfile)new AccessProfileImpl(methodAccesses));
            this.buildTree((MutableAccessTree<? extends MutableAccessNode>)tree, publicKey);
        }
        catch (Exception e) {
            throw new SecuredAccessException((Throwable)e);
        }
        return (AccessTree)tree.immutable(ImmutableAccessTree.class, ImmutableAccessNode.class);
    }

    private boolean checkIdentifier(String signature, String name) throws SecuredAccessException {
        try {
            if (name == null) {
                return false;
            }
            List<ObjectEntity> entities = this.objectDAO.find(UriUtils.getUri((String[])new String[]{name}), true);
            if (entities.size() == 0) {
                return true;
            }
            BundleEntity bundle = this.bundleDAO.find(signature);
            if (bundle == null) {
                return false;
            }
            while (!entities.isEmpty()) {
                ObjectEntity entity = entities.remove(0);
                if (bundle.getIdentifier() != entity.getBundleEntity()) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new SecuredAccessException((Throwable)e);
        }
    }

    private void buildNodes(MutableAccessTree<? extends MutableAccessNode> tree, List<ObjectEntity> objectEntities) throws SecuredAccessException {
        if (objectEntities == null || objectEntities.isEmpty()) {
            return;
        }
        while (!objectEntities.isEmpty()) {
            ObjectEntity objectEntity = objectEntities.remove(0);
            if (objectEntity.getPath() == null) continue;
            try {
                AccessProfileOption option = this.objectProfileAccessDAO.getAccessProfileOption(objectEntity.getObjectProfileEntity());
                tree.add(objectEntity.getPath(), objectEntity.isPattern()).withAccessProfile(option);
                this.buildNodes(tree, this.objectDAO.findChildren(objectEntity.getIdentifier()));
            }
            catch (Exception e) {
                throw new SecuredAccessException((Throwable)e);
            }
        }
    }

    public String getAgentPublicKey(String signature) throws SecuredAccessException, DataStoreException {
        try {
            String agentKey = null;
            AgentEntity entity = this.agentDAO.findFromBundle(signature);
            if (entity != null) {
                agentKey = entity.getPublicKey();
            }
            return agentKey;
        }
        catch (DAOException e) {
            throw new SecuredAccessException((Throwable)((Object)e));
        }
    }

    public String getApplicationPublicKey(String privateKey) throws SecuredAccessException {
        try {
            String publicKey = null;
            ApplicationEntity entity = this.applicationDAO.findFromPrivateKey(privateKey);
            if (entity != null) {
                publicKey = entity.getPublicKey();
            }
            return publicKey;
        }
        catch (DAOException | DataStoreException e) {
            throw new SecuredAccessException((Throwable)e);
        }
    }

    @Deactivate
    void close() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("closing sensiNact secured access");
        }
        if (this.authorizationRegistration != null) {
            try {
                this.authorizationRegistration.unregister();
            }
            catch (IllegalStateException e) {
                try {
                    LOG.debug(e.getMessage());
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }
}

